/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util;

import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.Math;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.text.MessageFormat;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Calendar;
import org.ocpsoft.prettytime.natty.java.util.Date;
import org.ocpsoft.prettytime.natty.java.util.TimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.parameter.Value;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.TimeZones;

public final class Dates
extends Object {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_WEEK = 604800000L;
    public static final int DAYS_PER_WEEK = 7;
    public static final int PRECISION_SECOND = 0;
    public static final int PRECISION_DAY = 1;
    public static final int MAX_WEEKS_PER_YEAR = 53;
    public static final int MAX_DAYS_PER_YEAR = 366;
    public static final int MAX_DAYS_PER_MONTH = 31;
    private static final String INVALID_WEEK_MESSAGE = "org.ocpsoft.prettytime.natty.Invalid week number [{0}]";
    private static final String INVALID_YEAR_DAY_MESSAGE = "org.ocpsoft.prettytime.natty.Invalid year day [{0}]";
    private static final String INVALID_MONTH_DAY_MESSAGE = "org.ocpsoft.prettytime.natty.Invalid month day [{0}]";

    private Dates() {
    }

    public static int getAbsWeekNo(Date date, int weekNo) {
        if (weekNo == 0 || weekNo < -53 || weekNo > 53) {
            throw new IllegalArgumentException(MessageFormat.format((String)"org.ocpsoft.prettytime.natty.Invalid week number [{0}]", (Object[])new Object[]{new Integer(weekNo)}));
        }
        if (weekNo > 0) {
            return weekNo;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        ArrayList weeks = new ArrayList();
        cal.set(3, 1);
        while (cal.get(1) == year) {
            weeks.add((Object)new Integer(cal.get(3)));
            cal.add(3, 1);
        }
        return ((Integer)weeks.get(weeks.size() + weekNo)).intValue();
    }

    public static int getAbsYearDay(Date date, int yearDay) {
        if (yearDay == 0 || yearDay < -366 || yearDay > 366) {
            throw new IllegalArgumentException(MessageFormat.format((String)"org.ocpsoft.prettytime.natty.Invalid year day [{0}]", (Object[])new Object[]{new Integer(yearDay)}));
        }
        if (yearDay > 0) {
            return yearDay;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        ArrayList days = new ArrayList();
        cal.set(6, 1);
        while (cal.get(1) == year) {
            days.add((Object)new Integer(cal.get(6)));
            cal.add(6, 1);
        }
        return ((Integer)days.get(days.size() + yearDay)).intValue();
    }

    public static int getAbsMonthDay(Date date, int monthDay) {
        if (monthDay == 0 || monthDay < -31 || monthDay > 31) {
            throw new IllegalArgumentException(MessageFormat.format((String)"org.ocpsoft.prettytime.natty.Invalid month day [{0}]", (Object[])new Object[]{new Integer(monthDay)}));
        }
        if (monthDay > 0) {
            return monthDay;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        ArrayList days = new ArrayList();
        cal.set(5, 1);
        while (cal.get(2) == month) {
            days.add((Object)new Integer(cal.get(5)));
            cal.add(5, 1);
        }
        return ((Integer)days.get(days.size() + monthDay)).intValue();
    }

    public static org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date getInstance(Date date, Value type) {
        if (Value.DATE.equals(type)) {
            return new org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date(date);
        }
        return new DateTime(date);
    }

    public static Calendar getCalendarInstance(org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date date) {
        DateTime dateTime;
        Calendar instance = null;
        instance = date instanceof DateTime ? ((dateTime = (DateTime)date).getTimeZone() != null ? Calendar.getInstance((TimeZone)dateTime.getTimeZone()) : (dateTime.isUtc() ? Calendar.getInstance((TimeZone)TimeZones.getUtcTimeZone()) : Calendar.getInstance())) : Calendar.getInstance((TimeZone)TimeZones.getDateTimeZone());
        return instance;
    }

    public static long round(long time, int precision) {
        return Dates.round(time, precision, TimeZone.getDefault());
    }

    public static long round(long time, int precision, TimeZone tz) {
        if (precision == 0 && time % 1000L == 0L) {
            return time;
        }
        Calendar cal = Calendar.getInstance((TimeZone)tz);
        cal.setTimeInMillis(time);
        if (precision == 1) {
            cal.set(11, 0);
            cal.clear(12);
            cal.clear(13);
            cal.clear(14);
        } else if (precision == 0) {
            cal.clear(14);
        }
        return cal.getTimeInMillis();
    }

    public static long getCurrentTimeRounded() {
        return (long)Math.floor((double)((double)System.currentTimeMillis() / 1000.0)) * 1000L;
    }
}

