/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util;

import org.ocpsoft.prettytime.natty.java.io.FileInputStream;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.net.URL;
import org.ocpsoft.prettytime.natty.java.nio.charset.Charset;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.HashMap;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.CalendarBuilder;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.ParserException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Calendar;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ComponentList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ConstraintViolationException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.IndexedComponentList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Property;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VTimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.parameter.TzId;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Method;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Uid;

public final class Calendars
extends org.ocpsoft.prettytime.natty.java.lang.Object {
    private Calendars() {
    }

    public static Calendar load(String filename) throws IOException, ParserException {
        FileInputStream fin = new FileInputStream(filename);
        CalendarBuilder builder = new CalendarBuilder();
        return builder.build((InputStream)fin);
    }

    public static Calendar load(URL url) throws IOException, ParserException {
        CalendarBuilder builder = new CalendarBuilder();
        return builder.build(url.openStream());
    }

    public static Calendar merge(Calendar c1, Calendar c2) {
        Calendar result = new Calendar();
        result.getProperties().addAll((Collection)c1.getProperties());
        Iterator i = c2.getProperties().iterator();
        while (i.hasNext()) {
            Property p = (Property)i.next();
            if (result.getProperties().contains(p)) continue;
            result.getProperties().add(p);
        }
        result.getComponents().addAll((Collection)c1.getComponents());
        i = c2.getComponents().iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (result.getComponents().contains(c)) continue;
            result.getComponents().add(c);
        }
        return result;
    }

    public static Calendar wrap(Component component) {
        ComponentList components = new ComponentList();
        components.add(component);
        return new Calendar(components);
    }

    public static Calendar[] split(Calendar calendar) {
        if (calendar.getComponents().size() <= 1 || calendar.getComponents((String)"org.ocpsoft.prettytime.natty.VTIMEZONE").size() == calendar.getComponents().size()) {
            return new Calendar[]{calendar};
        }
        IndexedComponentList timezones = new IndexedComponentList(calendar.getComponents((String)"org.ocpsoft.prettytime.natty.VTIMEZONE"), (String)"org.ocpsoft.prettytime.natty.TZID");
        HashMap calendars = new HashMap();
        Iterator i = calendar.getComponents().iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            if (c instanceof VTimeZone) continue;
            Uid uid = (Uid)c.getProperty((String)"org.ocpsoft.prettytime.natty.UID");
            Calendar uidCal = (Calendar)calendars.get((org.ocpsoft.prettytime.natty.java.lang.Object)uid);
            if (uidCal == null) {
                uidCal = new Calendar(calendar.getProperties(), new ComponentList());
                Iterator mp = uidCal.getProperties((String)"org.ocpsoft.prettytime.natty.METHOD").iterator();
                while (mp.hasNext()) {
                    uidCal.getProperties().remove(mp.next());
                }
                calendars.put((org.ocpsoft.prettytime.natty.java.lang.Object)uid, (org.ocpsoft.prettytime.natty.java.lang.Object)uidCal);
            }
            Iterator j = c.getProperties().iterator();
            while (j.hasNext()) {
                Property p = (Property)j.next();
                TzId tzid = (TzId)p.getParameter((String)"org.ocpsoft.prettytime.natty.TZID");
                if (tzid == null) continue;
                VTimeZone timezone = (VTimeZone)timezones.getComponent(tzid.getValue());
                if (uidCal.getComponents().contains(timezone)) continue;
                uidCal.getComponents().add(timezone);
            }
            uidCal.getComponents().add(c);
        }
        return (Calendar[])calendars.values().toArray((org.ocpsoft.prettytime.natty.java.lang.Object[])new Calendar[calendars.values().size()]);
    }

    public static Uid getUid(Calendar calendar) throws ConstraintViolationException {
        Uid uid = null;
        Iterator i = calendar.getComponents().iterator();
        while (i.hasNext()) {
            Component c = (Component)i.next();
            Iterator j = c.getProperties((String)"org.ocpsoft.prettytime.natty.UID").iterator();
            while (j.hasNext()) {
                Uid foundUid = (Uid)j.next();
                if (uid != null && !uid.equals(foundUid)) {
                    throw new ConstraintViolationException((String)"org.ocpsoft.prettytime.natty.More than one UID found in calendar");
                }
                uid = foundUid;
            }
        }
        if (uid == null) {
            throw new ConstraintViolationException((String)"org.ocpsoft.prettytime.natty.Calendar must specify a single unique identifier (UID)");
        }
        return uid;
    }

    public static String getContentType(Calendar calendar, Charset charset) {
        StringBuffer b = new StringBuffer((String)"org/ocpsoft/prettytime/natty/text/calendar");
        Method method = (Method)calendar.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD");
        if (method != null) {
            b.append((String)"org.ocpsoft.prettytime.natty.; method=");
            b.append(method.getValue());
        }
        if (charset != null) {
            b.append((String)"org.ocpsoft.prettytime.natty.; charset=");
            b.append((org.ocpsoft.prettytime.natty.java.lang.Object)charset);
        }
        return b.toString();
    }
}

