/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.UnsupportedOperationException;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Parameter;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ParameterList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Property;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PropertyFactory;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.parameter.TzId;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.parameter.Value;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.ParameterValidator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.Strings;

public abstract class DateProperty
extends Property {
    private static final long serialVersionUID = 3160883132732961321L;
    private Date date;
    private TimeZone timeZone;

    public DateProperty(String name, ParameterList parameters, PropertyFactory factory) {
        super(name, parameters, factory);
    }

    public DateProperty(String name, PropertyFactory factory) {
        super(name, factory);
    }

    public DateProperty(String name, TimeZone timezone, PropertyFactory factory) {
        super(name, factory);
        this.updateTimeZone(timezone);
    }

    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date date) {
        this.date = date;
        if (date instanceof DateTime) {
            if (Value.DATE.equals(this.getParameter((String)"org.ocpsoft.prettytime.natty.VALUE"))) {
                this.getParameters().replace(Value.DATE_TIME);
            }
            this.updateTimeZone(((DateTime)date).getTimeZone());
        } else {
            if (date != null) {
                this.getParameters().replace(Value.DATE);
            }
            this.updateTimeZone(null);
        }
    }

    public void setValue(String value) throws ParseException {
        if (Value.DATE.equals(this.getParameter((String)"org.ocpsoft.prettytime.natty.VALUE"))) {
            this.updateTimeZone(null);
            this.date = new Date(value);
        } else {
            this.date = new DateTime(value, this.timeZone);
        }
    }

    public String getValue() {
        return Strings.valueOf((Object)this.getDate());
    }

    public void setTimeZone(TimeZone timezone) {
        this.updateTimeZone(timezone);
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    private void updateTimeZone(TimeZone timezone) {
        this.timeZone = timezone;
        if (timezone != null) {
            if (this.getDate() != null && !(this.getDate() instanceof DateTime)) {
                throw new UnsupportedOperationException((String)"org.ocpsoft.prettytime.natty.TimeZone is not applicable to current value");
            }
            if (this.getDate() != null) {
                ((DateTime)this.getDate()).setTimeZone(timezone);
            }
            this.getParameters().replace(new TzId(timezone.getID()));
        } else {
            this.setUtc(this.isUtc());
        }
    }

    public final void setUtc(boolean utc) {
        if (this.getDate() != null && this.getDate() instanceof DateTime) {
            ((DateTime)this.getDate()).setUtc(utc);
        }
        this.getParameters().remove(this.getParameter((String)"org.ocpsoft.prettytime.natty.TZID"));
    }

    public final boolean isUtc() {
        if (this.getDate() instanceof DateTime) {
            return ((DateTime)this.getDate()).isUtc();
        }
        return false;
    }

    public void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.VALUE", this.getParameters());
        if (this.isUtc()) {
            ParameterValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.TZID", this.getParameters());
        } else {
            ParameterValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TZID", this.getParameters());
        }
        Value value = (Value)this.getParameter((String)"org.ocpsoft.prettytime.natty.VALUE");
        if (this.getDate() instanceof DateTime) {
            if (value != null && !Value.DATE_TIME.equals(value)) {
                throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.VALUE parameter [").append((Object)value).append((String)"org.ocpsoft.prettytime.natty.] is invalid for DATE-TIME instance").toString());
            }
            DateTime dateTime = (DateTime)this.date;
            Parameter tzId = this.getParameter((String)"org.ocpsoft.prettytime.natty.TZID");
            if (!(dateTime.getTimeZone() == null || tzId != null && tzId.getValue().equals((Object)dateTime.getTimeZone().getID()))) {
                throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.TZID parameter [").append((Object)tzId).append((String)"org.ocpsoft.prettytime.natty.] does not match the timezone [").append(dateTime.getTimeZone().getID()).append((String)"org.ocpsoft.prettytime.natty.]").toString());
            }
        } else if (this.getDate() != null) {
            if (value == null) {
                throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.VALUE parameter [").append((Object)Value.DATE).append((String)"org.ocpsoft.prettytime.natty.] must be specified for DATE instance").toString());
            }
            if (!Value.DATE.equals(value)) {
                throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.VALUE parameter [").append((Object)value).append((String)"org.ocpsoft.prettytime.natty.] is invalid for DATE instance").toString());
            }
        }
    }

    public Property copy() throws IOException, URISyntaxException, ParseException {
        Property copy = super.copy();
        ((DateProperty)copy).timeZone = this.timeZone;
        ((DateProperty)copy).setValue(this.getValue());
        return copy;
    }
}

