/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ComponentList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Validator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.CalendarComponent;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.Observance;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.LastModified;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Method;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.TzId;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.TzUrl;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.PropertyValidator;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.ObjectUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public class VTimeZone
extends CalendarComponent {
    private static final long serialVersionUID = 5629679741050917815L;
    private final Validator itipValidator = new ITIPValidator();
    private ComponentList observances;

    public VTimeZone() {
        super((String)"org.ocpsoft.prettytime.natty.VTIMEZONE");
        this.observances = new ComponentList();
    }

    public VTimeZone(PropertyList properties) {
        super((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", properties);
        this.observances = new ComponentList();
    }

    public VTimeZone(ComponentList observances) {
        super((String)"org.ocpsoft.prettytime.natty.VTIMEZONE");
        this.observances = observances;
    }

    public VTimeZone(PropertyList properties, ComponentList observances) {
        super((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", properties);
        this.observances = observances;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append((String)"org.ocpsoft.prettytime.natty.BEGIN");
        b.append(':');
        b.append(this.getName());
        b.append((String)"org.ocpsoft.prettytime.natty.\r\n");
        b.append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getProperties());
        b.append((org.ocpsoft.prettytime.natty.java.lang.Object)this.observances);
        b.append((String)"org.ocpsoft.prettytime.natty.END");
        b.append(':');
        b.append(this.getName());
        b.append((String)"org.ocpsoft.prettytime.natty.\r\n");
        return b.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.TZID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TZURL", this.getProperties());
        if (this.getObservances().getComponent((String)"org.ocpsoft.prettytime.natty.STANDARD") == null && this.getObservances().getComponent((String)"org.ocpsoft.prettytime.natty.DAYLIGHT") == null) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.Sub-components [STANDARD,DAYLIGHT] must be specified at least once");
        }
        Iterator i = this.getObservances().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).validate(recurse);
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return this.itipValidator;
    }

    public final ComponentList getObservances() {
        return this.observances;
    }

    public final Observance getApplicableObservance(Date date) {
        Observance latestObservance = null;
        Date latestOnset = null;
        Iterator i = this.getObservances().iterator();
        while (i.hasNext()) {
            Observance observance = (Observance)i.next();
            Date onset = observance.getLatestOnset(date);
            if (latestOnset != null && (onset == null || !onset.after(latestOnset))) continue;
            latestOnset = onset;
            latestObservance = observance;
        }
        return latestObservance;
    }

    public final TzId getTimeZoneId() {
        return (TzId)this.getProperty((String)"org.ocpsoft.prettytime.natty.TZID");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED");
    }

    public final TzUrl getTimeZoneUrl() {
        return (TzUrl)this.getProperty((String)"org.ocpsoft.prettytime.natty.TZURL");
    }

    public boolean equals(org.ocpsoft.prettytime.natty.java.lang.Object arg0) {
        if (arg0 instanceof VTimeZone) {
            return super.equals(arg0) && ObjectUtils.equals((org.ocpsoft.prettytime.natty.java.lang.Object)this.observances, (org.ocpsoft.prettytime.natty.java.lang.Object)((VTimeZone)arg0).getObservances());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getName()).append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getProperties()).append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getObservances()).toHashCode();
    }

    public Component copy() throws ParseException, IOException, URISyntaxException {
        VTimeZone copy = (VTimeZone)super.copy();
        copy.observances = new ComponentList(this.observances);
        return copy;
    }

    private class ITIPValidator
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ITIPValidator() {
        }

        public void validate() throws ValidationException {
            Iterator i = VTimeZone.this.getObservances().iterator();
            while (i.hasNext()) {
                Observance observance = (Observance)i.next();
                PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", observance.getProperties());
                PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.TZOFFSETFROM", observance.getProperties());
                PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.TZOFFSETTO", observance.getProperties());
                PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", observance.getProperties());
                PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TZNAME", observance.getProperties());
            }
        }
    }
}

