/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component;

import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.HashMap;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ComponentList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.DateRange;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Dur;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Period;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PeriodList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Validator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.CalendarComponent;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VEvent;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.parameter.FbType;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Contact;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.DtEnd;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.DtStamp;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.DtStart;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Duration;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.FreeBusy;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Method;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Organizer;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Uid;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Url;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.CompatibilityHints;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.PropertyValidator;

public class VFreeBusy
extends CalendarComponent {
    private static final long serialVersionUID = 1046534053331139832L;
    private final Map methodValidators = new HashMap();

    public VFreeBusy() {
        super((String)"org.ocpsoft.prettytime.natty.VFREEBUSY");
        this.methodValidators.put((org.ocpsoft.prettytime.natty.java.lang.Object)Method.PUBLISH, (org.ocpsoft.prettytime.natty.java.lang.Object)new PublishValidator());
        this.methodValidators.put((org.ocpsoft.prettytime.natty.java.lang.Object)Method.REPLY, (org.ocpsoft.prettytime.natty.java.lang.Object)new ReplyValidator());
        this.methodValidators.put((org.ocpsoft.prettytime.natty.java.lang.Object)Method.REQUEST, (org.ocpsoft.prettytime.natty.java.lang.Object)new RequestValidator());
        this.getProperties().add(new DtStamp());
    }

    public VFreeBusy(PropertyList properties) {
        super((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", properties);
        this.methodValidators.put((org.ocpsoft.prettytime.natty.java.lang.Object)Method.PUBLISH, (org.ocpsoft.prettytime.natty.java.lang.Object)new PublishValidator());
        this.methodValidators.put((org.ocpsoft.prettytime.natty.java.lang.Object)Method.REPLY, (org.ocpsoft.prettytime.natty.java.lang.Object)new ReplyValidator());
        this.methodValidators.put((org.ocpsoft.prettytime.natty.java.lang.Object)Method.REQUEST, (org.ocpsoft.prettytime.natty.java.lang.Object)new RequestValidator());
    }

    public VFreeBusy(DateTime start, DateTime end) {
        this();
        this.getProperties().add(new DtStart(start, true));
        this.getProperties().add(new DtEnd(end, true));
    }

    public VFreeBusy(DateTime start, DateTime end, Dur duration) {
        this();
        this.getProperties().add(new DtStart(start, true));
        this.getProperties().add(new DtEnd(end, true));
        this.getProperties().add(new Duration(duration));
    }

    public VFreeBusy(VFreeBusy request, ComponentList components) {
        this();
        DtStart start = (DtStart)request.getProperty((String)"org.ocpsoft.prettytime.natty.DTSTART");
        DtEnd end = (DtEnd)request.getProperty((String)"org.ocpsoft.prettytime.natty.DTEND");
        Duration duration = (Duration)request.getProperty((String)"org.ocpsoft.prettytime.natty.DURATION");
        this.getProperties().add(new DtStart(start.getDate(), true));
        this.getProperties().add(new DtEnd(end.getDate(), true));
        if (duration != null) {
            this.getProperties().add(new Duration(duration.getDuration()));
            DateTime freeStart = new DateTime(start.getDate());
            DateTime freeEnd = new DateTime(end.getDate());
            FreeBusy fb = new FreeTimeBuilder().start(freeStart).end(freeEnd).duration(duration.getDuration()).components(components).build();
            if (fb != null && !fb.getPeriods().isEmpty()) {
                this.getProperties().add(fb);
            }
        } else {
            DateTime busyStart = new DateTime(start.getDate());
            DateTime busyEnd = new DateTime(end.getDate());
            FreeBusy fb = new BusyTimeBuilder().start(busyStart).end(busyEnd).components(components).build();
            if (fb != null && !fb.getPeriods().isEmpty()) {
                this.getProperties().add(fb);
            }
        }
    }

    private PeriodList getConsumedTime(ComponentList components, DateTime rangeStart, DateTime rangeEnd) {
        PeriodList periods = new PeriodList();
        Iterator i = components.getComponents((String)"org.ocpsoft.prettytime.natty.VEVENT").iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            periods.addAll((Collection)((VEvent)component).getConsumedTime(rangeStart, rangeEnd, false));
        }
        return periods.normalise();
    }

    public final void validate(boolean recurse) throws ValidationException {
        if (!CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", this.getProperties());
        }
        PropertyValidator validator = PropertyValidator.getInstance();
        validator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CONTACT", this.getProperties());
        validator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTSTART", this.getProperties());
        validator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTEND", this.getProperties());
        validator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DURATION", this.getProperties());
        validator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTSTAMP", this.getProperties());
        validator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.ORGANIZER", this.getProperties());
        validator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.UID", this.getProperties());
        validator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", this.getProperties());
        validator.assertNone((String)"org.ocpsoft.prettytime.natty.RRULE", this.getProperties());
        validator.assertNone((String)"org.ocpsoft.prettytime.natty.EXRULE", this.getProperties());
        validator.assertNone((String)"org.ocpsoft.prettytime.natty.RDATE", this.getProperties());
        validator.assertNone((String)"org.ocpsoft.prettytime.natty.EXDATE", this.getProperties());
        DtStart dtStart = (DtStart)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTSTART");
        if (dtStart != null && !dtStart.isUtc()) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.DTSTART must be specified in UTC time");
        }
        DtEnd dtEnd = (DtEnd)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTEND");
        if (dtEnd != null && !dtEnd.isUtc()) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.DTEND must be specified in UTC time");
        }
        if (dtStart != null && dtEnd != null && !dtStart.getDate().before(dtEnd.getDate())) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.Property [DTEND] must be later in time than [DTSTART]");
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return (Validator)this.methodValidators.get((org.ocpsoft.prettytime.natty.java.lang.Object)method);
    }

    public final Contact getContact() {
        return (Contact)this.getProperty((String)"org.ocpsoft.prettytime.natty.CONTACT");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTSTART");
    }

    public final DtEnd getEndDate() {
        return (DtEnd)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTEND");
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty((String)"org.ocpsoft.prettytime.natty.DURATION");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTSTAMP");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty((String)"org.ocpsoft.prettytime.natty.ORGANIZER");
    }

    public final Url getUrl() {
        return (Url)this.getProperty((String)"org.ocpsoft.prettytime.natty.URL");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty((String)"org.ocpsoft.prettytime.natty.UID");
    }

    private class RequestValidator
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private RequestValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrMore((String)"org.ocpsoft.prettytime.natty.ATTENDEE", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTEND", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.FREEBUSY", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DURATION", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.REQUEST-STATUS", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.URL", VFreeBusy.this.getProperties());
        }
    }

    private class ReplyValidator
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ReplyValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ATTENDEE", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTEND", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DURATION", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VFreeBusy.this.getProperties());
        }
    }

    private class PublishValidator
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private PublishValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrMore((String)"org.ocpsoft.prettytime.natty.FREEBUSY", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTEND", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.ATTENDEE", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DURATION", VFreeBusy.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.REQUEST-STATUS", VFreeBusy.this.getProperties());
        }
    }

    private class FreeTimeBuilder
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        private DateTime start;
        private DateTime end;
        private Dur duration;
        private ComponentList components;

        private FreeTimeBuilder() {
        }

        public FreeTimeBuilder start(DateTime start) {
            this.start = start;
            return this;
        }

        public FreeTimeBuilder end(DateTime end) {
            this.end = end;
            return this;
        }

        private FreeTimeBuilder duration(Dur duration) {
            this.duration = duration;
            return this;
        }

        public FreeTimeBuilder components(ComponentList components) {
            this.components = components;
            return this;
        }

        public FreeBusy build() {
            FreeBusy fb = new FreeBusy();
            fb.getParameters().add(FbType.FREE);
            PeriodList periods = VFreeBusy.this.getConsumedTime(this.components, this.start, this.end);
            DateRange range = new DateRange(this.start, this.end);
            periods.add(new Period(this.end, this.end));
            DateTime lastPeriodEnd = new DateTime(this.start);
            Iterator i = periods.iterator();
            while (i.hasNext()) {
                Duration freeDuration;
                Period period = (Period)i.next();
                if ((range.contains(period) || range.intersects(period) && period.getStart().after(range.getRangeStart())) && (freeDuration = new Duration(lastPeriodEnd, period.getStart())).getDuration().compareTo(this.duration) >= 0) {
                    fb.getPeriods().add(new Period(lastPeriodEnd, freeDuration.getDuration()));
                }
                if (!period.getEnd().after(lastPeriodEnd)) continue;
                lastPeriodEnd = period.getEnd();
            }
            return fb;
        }
    }

    private class BusyTimeBuilder
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        private DateTime start;
        private DateTime end;
        private ComponentList components;

        private BusyTimeBuilder() {
        }

        public BusyTimeBuilder start(DateTime start) {
            this.start = start;
            return this;
        }

        public BusyTimeBuilder end(DateTime end) {
            this.end = end;
            return this;
        }

        public BusyTimeBuilder components(ComponentList components) {
            this.components = components;
            return this;
        }

        public FreeBusy build() {
            PeriodList periods = VFreeBusy.this.getConsumedTime(this.components, this.start, this.end);
            DateRange range = new DateRange(this.start, this.end);
            periods.setUtc(true);
            Iterator i = periods.iterator();
            while (i.hasNext()) {
                Period period = (Period)i.next();
                if (range.intersects(period)) continue;
                periods.remove(period);
            }
            return new FreeBusy(periods);
        }
    }
}

