/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.util.HashMap;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ComponentList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Dur;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Parameter;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Period;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PeriodList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Validator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.CalendarComponent;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VAlarm;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.parameter.Value;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Clazz;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Created;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Description;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.DtEnd;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.DtStamp;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.DtStart;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Duration;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Geo;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.LastModified;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Location;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Method;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Organizer;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Priority;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.RecurrenceId;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Sequence;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Status;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Summary;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Transp;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Uid;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Url;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.CompatibilityHints;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.ComponentValidator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.Dates;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.PropertyValidator;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.ObjectUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public class VEvent
extends CalendarComponent {
    private static final long serialVersionUID = 2547948989200697335L;
    private final Map methodValidators = new HashMap();
    private ComponentList alarms;

    public VEvent() {
        super((String)"org.ocpsoft.prettytime.natty.VEVENT");
        this.methodValidators.put((Object)Method.ADD, (Object)new AddValidator());
        this.methodValidators.put((Object)Method.CANCEL, (Object)new CancelValidator());
        this.methodValidators.put((Object)Method.COUNTER, (Object)new CounterValidator());
        this.methodValidators.put((Object)Method.DECLINE_COUNTER, (Object)new DeclineCounterValidator());
        this.methodValidators.put((Object)Method.PUBLISH, (Object)new PublishValidator());
        this.methodValidators.put((Object)Method.REFRESH, (Object)new RefreshValidator());
        this.methodValidators.put((Object)Method.REPLY, (Object)new ReplyValidator());
        this.methodValidators.put((Object)Method.REQUEST, (Object)new RequestValidator());
        this.alarms = new ComponentList();
        this.getProperties().add(new DtStamp());
    }

    public VEvent(PropertyList properties) {
        super((String)"org.ocpsoft.prettytime.natty.VEVENT", properties);
        this.methodValidators.put((Object)Method.ADD, (Object)new AddValidator());
        this.methodValidators.put((Object)Method.CANCEL, (Object)new CancelValidator());
        this.methodValidators.put((Object)Method.COUNTER, (Object)new CounterValidator());
        this.methodValidators.put((Object)Method.DECLINE_COUNTER, (Object)new DeclineCounterValidator());
        this.methodValidators.put((Object)Method.PUBLISH, (Object)new PublishValidator());
        this.methodValidators.put((Object)Method.REFRESH, (Object)new RefreshValidator());
        this.methodValidators.put((Object)Method.REPLY, (Object)new ReplyValidator());
        this.methodValidators.put((Object)Method.REQUEST, (Object)new RequestValidator());
        this.alarms = new ComponentList();
    }

    public VEvent(PropertyList properties, ComponentList alarms) {
        super((String)"org.ocpsoft.prettytime.natty.VEVENT", properties);
        this.methodValidators.put((Object)Method.ADD, (Object)new AddValidator());
        this.methodValidators.put((Object)Method.CANCEL, (Object)new CancelValidator());
        this.methodValidators.put((Object)Method.COUNTER, (Object)new CounterValidator());
        this.methodValidators.put((Object)Method.DECLINE_COUNTER, (Object)new DeclineCounterValidator());
        this.methodValidators.put((Object)Method.PUBLISH, (Object)new PublishValidator());
        this.methodValidators.put((Object)Method.REFRESH, (Object)new RefreshValidator());
        this.methodValidators.put((Object)Method.REPLY, (Object)new ReplyValidator());
        this.methodValidators.put((Object)Method.REQUEST, (Object)new RequestValidator());
        this.alarms = alarms;
    }

    public VEvent(Date start, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Summary(summary));
    }

    public VEvent(Date start, Date end, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new DtEnd(end));
        this.getProperties().add(new Summary(summary));
    }

    public VEvent(Date start, Dur duration, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Duration(duration));
        this.getProperties().add(new Summary(summary));
    }

    public final ComponentList getAlarms() {
        return this.alarms;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append((String)"org.ocpsoft.prettytime.natty.BEGIN");
        b.append(':');
        b.append(this.getName());
        b.append((String)"org.ocpsoft.prettytime.natty.\r\n");
        b.append((Object)this.getProperties());
        b.append((Object)this.getAlarms());
        b.append((String)"org.ocpsoft.prettytime.natty.END");
        b.append(':');
        b.append(this.getName());
        b.append((String)"org.ocpsoft.prettytime.natty.\r\n");
        return b.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        Iterator iterator = this.getAlarms().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (!(component instanceof VAlarm)) {
                throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Component [").append(component.getName()).append((String)"org.ocpsoft.prettytime.natty.] may not occur in VEVENT").toString());
            }
            ((VAlarm)component).validate(recurse);
        }
        if (!CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", this.getProperties());
        }
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", this.getProperties());
        Status status = (Status)this.getProperty((String)"org.ocpsoft.prettytime.natty.STATUS");
        if (!(status == null || Status.VEVENT_TENTATIVE.getValue().equals((Object)status.getValue()) || Status.VEVENT_CONFIRMED.getValue().equals((Object)status.getValue()) || Status.VEVENT_CANCELLED.getValue().equals((Object)status.getValue()))) {
            throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Status property [").append(status.toString()).append((String)"org.ocpsoft.prettytime.natty.] is not applicable for VEVENT").toString());
        }
        try {
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DTEND", this.getProperties());
        }
        catch (ValidationException ve) {
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DURATION", this.getProperties());
        }
        if (this.getProperty((String)"org.ocpsoft.prettytime.natty.DTEND") != null) {
            DtStart start = (DtStart)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTSTART");
            DtEnd end = (DtEnd)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTEND");
            if (start != null) {
                Parameter startValue = start.getParameter((String)"org.ocpsoft.prettytime.natty.VALUE");
                Parameter endValue = end.getParameter((String)"org.ocpsoft.prettytime.natty.VALUE");
                boolean startEndValueMismatch = false;
                if (endValue != null) {
                    if (startValue != null && !endValue.equals(startValue)) {
                        startEndValueMismatch = true;
                    } else if (startValue == null && !Value.DATE_TIME.equals(endValue)) {
                        startEndValueMismatch = true;
                    }
                } else if (startValue != null && !Value.DATE_TIME.equals(startValue)) {
                    startEndValueMismatch = true;
                }
                if (startEndValueMismatch) {
                    throw new ValidationException((String)"org.ocpsoft.prettytime.natty.Property [DTEND] must have the same [VALUE] as [DTSTART]");
                }
            }
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return (Validator)this.methodValidators.get((Object)method);
    }

    public final PeriodList getConsumedTime(Date rangeStart, Date rangeEnd) {
        return this.getConsumedTime(rangeStart, rangeEnd, true);
    }

    public final PeriodList getConsumedTime(Date rangeStart, Date rangeEnd, boolean normalise) {
        PeriodList periods = new PeriodList();
        if (!Transp.TRANSPARENT.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.TRANSP")) && !(periods = this.calculateRecurrenceSet(new Period(new DateTime(rangeStart), new DateTime(rangeEnd)))).isEmpty() && normalise) {
            periods = periods.normalise();
        }
        return periods;
    }

    public final VEvent getOccurrence(Date date) throws IOException, URISyntaxException, ParseException {
        PeriodList consumedTime = this.getConsumedTime(date, date);
        Iterator i = consumedTime.iterator();
        while (i.hasNext()) {
            Period p = (Period)i.next();
            if (!p.getStart().equals((Object)date)) continue;
            VEvent occurrence = (VEvent)this.copy();
            occurrence.getProperties().add(new RecurrenceId(date));
            return occurrence;
        }
        return null;
    }

    public final Clazz getClassification() {
        return (Clazz)this.getProperty((String)"org.ocpsoft.prettytime.natty.CLASS");
    }

    public final Created getCreated() {
        return (Created)this.getProperty((String)"org.ocpsoft.prettytime.natty.CREATED");
    }

    public final Description getDescription() {
        return (Description)this.getProperty((String)"org.ocpsoft.prettytime.natty.DESCRIPTION");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTSTART");
    }

    public final Geo getGeographicPos() {
        return (Geo)this.getProperty((String)"org.ocpsoft.prettytime.natty.GEO");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED");
    }

    public final Location getLocation() {
        return (Location)this.getProperty((String)"org.ocpsoft.prettytime.natty.LOCATION");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty((String)"org.ocpsoft.prettytime.natty.ORGANIZER");
    }

    public final Priority getPriority() {
        return (Priority)this.getProperty((String)"org.ocpsoft.prettytime.natty.PRIORITY");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTSTAMP");
    }

    public final Sequence getSequence() {
        return (Sequence)this.getProperty((String)"org.ocpsoft.prettytime.natty.SEQUENCE");
    }

    public final Status getStatus() {
        return (Status)this.getProperty((String)"org.ocpsoft.prettytime.natty.STATUS");
    }

    public final Summary getSummary() {
        return (Summary)this.getProperty((String)"org.ocpsoft.prettytime.natty.SUMMARY");
    }

    public final Transp getTransparency() {
        return (Transp)this.getProperty((String)"org.ocpsoft.prettytime.natty.TRANSP");
    }

    public final Url getUrl() {
        return (Url)this.getProperty((String)"org.ocpsoft.prettytime.natty.URL");
    }

    public final RecurrenceId getRecurrenceId() {
        return (RecurrenceId)this.getProperty((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID");
    }

    public final DtEnd getEndDate() {
        return this.getEndDate(true);
    }

    public final DtEnd getEndDate(boolean deriveFromDuration) {
        DtEnd dtEnd = (DtEnd)this.getProperty((String)"org.ocpsoft.prettytime.natty.DTEND");
        if (dtEnd == null && deriveFromDuration && this.getDuration() != null) {
            DtStart dtStart = this.getStartDate();
            Duration vEventDuration = this.getDuration();
            dtEnd = new DtEnd(Dates.getInstance(vEventDuration.getDuration().getTime(dtStart.getDate()), (Value)dtStart.getParameter((String)"org.ocpsoft.prettytime.natty.VALUE")));
            if (dtStart.isUtc()) {
                dtEnd.setUtc(true);
            }
        }
        return dtEnd;
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty((String)"org.ocpsoft.prettytime.natty.DURATION");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty((String)"org.ocpsoft.prettytime.natty.UID");
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof VEvent) {
            return super.equals(arg0) && ObjectUtils.equals((Object)this.alarms, (Object)((VEvent)arg0).getAlarms());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getProperties()).append((Object)this.getAlarms()).toHashCode();
    }

    public Component copy() throws ParseException, IOException, URISyntaxException {
        VEvent copy = (VEvent)super.copy();
        copy.alarms = new ComponentList(this.alarms);
        return copy;
    }

    private class RequestValidator
    extends Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private RequestValidator() {
        }

        public void validate() throws ValidationException {
            if (!CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertOneOrMore((String)"org.ocpsoft.prettytime.natty.ATTENDEE", VEvent.this.getProperties());
            }
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", VEvent.this.getProperties());
            Iterator i = VEvent.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.REQUEST);
            }
        }
    }

    private class ReplyValidator
    extends Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ReplyValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ATTENDEE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", VEvent.this.getProperties());
            ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", VEvent.this.getAlarms());
        }
    }

    private class RefreshValidator
    extends Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private RefreshValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ATTENDEE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.ATTACH", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.CONTACT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.EXDATE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.EXRULE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RDATE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RELATED-TO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.REQUEST-STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RRULE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.URL", VEvent.this.getProperties());
            ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", VEvent.this.getAlarms());
        }
    }

    private class PublishValidator
    extends Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private PublishValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            if (!CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VEvent.this.getProperties());
                PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.SUMMARY", VEvent.this.getProperties());
            }
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", VEvent.this.getProperties());
            if (!CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.ATTENDEE", VEvent.this.getProperties());
            }
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.REQUEST-STATUS", VEvent.this.getProperties());
            Iterator i = VEvent.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.PUBLISH);
            }
        }
    }

    private class DeclineCounterValidator
    extends Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private DeclineCounterValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.ATTACH", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.ATTENDEE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.CONTACT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.EXDATE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.EXRULE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RDATE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RELATED-TO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RRULE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.URL", VEvent.this.getProperties());
            ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", VEvent.this.getAlarms());
        }
    }

    private class CounterValidator
    extends Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private CounterValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            if (!CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VEvent.this.getProperties());
            }
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", VEvent.this.getProperties());
            Iterator i = VEvent.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.COUNTER);
            }
        }
    }

    private class CancelValidator
    extends Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private CancelValidator() {
        }

        public final void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.REQUEST-STATUS", VEvent.this.getProperties());
            ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", VEvent.this.getAlarms());
        }
    }

    private class AddValidator
    extends Object
    implements Validator {
        private static final long serialVersionUID = 1L;

        private AddValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.URL", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone((String)"org.ocpsoft.prettytime.natty.REQUEST-STATUS", VEvent.this.getProperties());
            Iterator i = VEvent.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.ADD);
            }
        }
    }
}

