/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.Math;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.text.DecimalFormat;
import org.ocpsoft.prettytime.natty.java.text.NumberFormat;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory;

public class UtcOffset
extends Object
implements Serializable {
    private static final long serialVersionUID = 5883111996721531728L;
    private static final int HOUR_START_INDEX = 1;
    private static final int HOUR_END_INDEX = 3;
    private static final int MINUTE_START_INDEX = 3;
    private static final int MINUTE_END_INDEX = 5;
    private static final int SECOND_START_INDEX = 5;
    private static final int SECOND_END_INDEX = 7;
    private static final NumberFormat HOUR_FORMAT = new DecimalFormat((String)"org.ocpsoft.prettytime.natty.00");
    private static final NumberFormat MINUTE_FORMAT = new DecimalFormat((String)"org.ocpsoft.prettytime.natty.00");
    private static final NumberFormat SECOND_FORMAT = new DecimalFormat((String)"org.ocpsoft.prettytime.natty.00");
    private long offset;
    static /* synthetic */ Class class$net$fortuna$ical4j$model$UtcOffset;

    public UtcOffset(String value) {
        boolean negative;
        if (value.length() < 5) {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Invalid UTC offset [").append(value).append((String)"org/ocpsoft/prettytime/natty/] - must be of the form: (+/-)HHMM[SS]").toString());
        }
        boolean bl = negative = value.charAt(0) == '-';
        if (!negative && value.charAt(0) != '+') {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.UTC offset value must be signed");
        }
        this.offset = 0L;
        this.offset += (long)Integer.parseInt((String)value.substring(1, 3)) * 3600000L;
        this.offset += (long)Integer.parseInt((String)value.substring(3, 5)) * 60000L;
        try {
            this.offset += (long)Integer.parseInt((String)value.substring(5, 7)) * 1000L;
        }
        catch (Exception e) {
            Log log = LogFactory.getLog(class$net$fortuna$ical4j$model$UtcOffset == null ? (class$net$fortuna$ical4j$model$UtcOffset = UtcOffset.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.UtcOffset")) : class$net$fortuna$ical4j$model$UtcOffset);
            log.trace((Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Seconds not specified: ").append(e.getMessage()).toString());
        }
        if (negative) {
            this.offset = -this.offset;
        }
    }

    public UtcOffset(long offset) {
        this.offset = (long)Math.floor((double)((double)offset / 1000.0)) * 1000L;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        long remainder = Math.abs((long)this.offset);
        if (this.offset < 0L) {
            b.append('-');
        } else {
            b.append('+');
        }
        b.append(HOUR_FORMAT.format(remainder / 3600000L));
        b.append(MINUTE_FORMAT.format((remainder %= 3600000L) / 60000L));
        if ((remainder %= 60000L) > 0L) {
            b.append(SECOND_FORMAT.format(remainder / 1000L));
        }
        return b.toString();
    }

    public final long getOffset() {
        return this.offset;
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof UtcOffset) {
            return this.getOffset() == ((UtcOffset)arg0).getOffset();
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.getOffset()).toHashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)x1);
        }
    }
}

