/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.lang.CharSequence;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.net.URL;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.java.util.Properties;
import org.ocpsoft.prettytime.natty.java.util.regex.Matcher;
import org.ocpsoft.prettytime.natty.java.util.regex.Pattern;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.CalendarBuilder;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.ParserException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Calendar;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZoneRegistry;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VTimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.TzUrl;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.CompatibilityHints;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.Configurator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.ResourceLoader;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory;

public class TimeZoneRegistryImpl
extends org.ocpsoft.prettytime.natty.java.lang.Object
implements TimeZoneRegistry {
    private static final String DEFAULT_RESOURCE_PREFIX = "org/ocpsoft/prettytime/natty/zoneinfo/";
    private static final Pattern TZ_ID_SUFFIX = Pattern.compile((String)"org/ocpsoft/prettytime/natty/(?<=/)[^/]*/[^/]*$");
    private static final String UPDATE_ENABLED = "org.ocpsoft.prettytime.natty.net.fortuna.ical4j.timezone.update.enabled";
    private static final Map DEFAULT_TIMEZONES = new ConcurrentHashMap();
    private static final Properties ALIASES = new Properties();
    private Map timezones;
    private String resourcePrefix;
    static /* synthetic */ Class class$net$fortuna$ical4j$model$TimeZoneRegistryImpl;

    public TimeZoneRegistryImpl() {
        this((String)"org/ocpsoft/prettytime/natty/zoneinfo/");
    }

    public TimeZoneRegistryImpl(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
        this.timezones = new ConcurrentHashMap();
    }

    public final void register(TimeZone timezone) {
        this.register(timezone, false);
    }

    public final void register(TimeZone timezone, boolean update) {
        if (update) {
            this.timezones.put((org.ocpsoft.prettytime.natty.java.lang.Object)timezone.getID(), (org.ocpsoft.prettytime.natty.java.lang.Object)new TimeZone(this.updateDefinition(timezone.getVTimeZone())));
        } else {
            this.timezones.put((org.ocpsoft.prettytime.natty.java.lang.Object)timezone.getID(), (org.ocpsoft.prettytime.natty.java.lang.Object)timezone);
        }
    }

    public final void clear() {
        this.timezones.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TimeZone getTimeZone(String id) {
        TimeZone timezone = (TimeZone)this.timezones.get((org.ocpsoft.prettytime.natty.java.lang.Object)id);
        if (timezone == null && (timezone = (TimeZone)DEFAULT_TIMEZONES.get((org.ocpsoft.prettytime.natty.java.lang.Object)id)) == null) {
            String alias = ALIASES.getProperty(id);
            if (alias != null) {
                return this.getTimeZone(alias);
            }
            Map map = DEFAULT_TIMEZONES;
            synchronized (map) {
                timezone = (TimeZone)DEFAULT_TIMEZONES.get((org.ocpsoft.prettytime.natty.java.lang.Object)id);
                if (timezone == null) {
                    try {
                        Matcher matcher;
                        VTimeZone vTimeZone = this.loadVTimeZone(id);
                        if (vTimeZone != null) {
                            timezone = new TimeZone(vTimeZone);
                            DEFAULT_TIMEZONES.put((org.ocpsoft.prettytime.natty.java.lang.Object)timezone.getID(), (org.ocpsoft.prettytime.natty.java.lang.Object)timezone);
                        } else if (CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.parsing.relaxed") && (matcher = TZ_ID_SUFFIX.matcher((CharSequence)id)).find()) {
                            return this.getTimeZone(matcher.group());
                        }
                    }
                    catch (Exception e) {
                        Log log = LogFactory.getLog(class$net$fortuna$ical4j$model$TimeZoneRegistryImpl == null ? (class$net$fortuna$ical4j$model$TimeZoneRegistryImpl = TimeZoneRegistryImpl.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZoneRegistryImpl")) : class$net$fortuna$ical4j$model$TimeZoneRegistryImpl);
                        log.warn((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.Error occurred loading VTimeZone", (Throwable)e);
                    }
                }
            }
        }
        return timezone;
    }

    private VTimeZone loadVTimeZone(String id) throws IOException, ParserException {
        URL resource = ResourceLoader.getResource(new StringBuffer().append(this.resourcePrefix).append(id).append((String)"org.ocpsoft.prettytime.natty..ics").toString());
        if (resource != null) {
            CalendarBuilder builder = new CalendarBuilder();
            Calendar calendar = builder.build(resource.openStream());
            VTimeZone vTimeZone = (VTimeZone)calendar.getComponent((String)"org.ocpsoft.prettytime.natty.VTIMEZONE");
            if (!"org.ocpsoft.prettytime.natty.false".equals((org.ocpsoft.prettytime.natty.java.lang.Object)Configurator.getProperty((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.timezone.update.enabled"))) {
                return this.updateDefinition(vTimeZone);
            }
            return vTimeZone;
        }
        return null;
    }

    private VTimeZone updateDefinition(VTimeZone vTimeZone) {
        TzUrl tzUrl = vTimeZone.getTimeZoneUrl();
        if (tzUrl != null) {
            try {
                CalendarBuilder builder = new CalendarBuilder();
                Calendar calendar = builder.build(tzUrl.getUri().toURL().openStream());
                VTimeZone updatedVTimeZone = (VTimeZone)calendar.getComponent((String)"org.ocpsoft.prettytime.natty.VTIMEZONE");
                if (updatedVTimeZone != null) {
                    return updatedVTimeZone;
                }
            }
            catch (Exception e) {
                Log log = LogFactory.getLog(class$net$fortuna$ical4j$model$TimeZoneRegistryImpl == null ? (class$net$fortuna$ical4j$model$TimeZoneRegistryImpl = TimeZoneRegistryImpl.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZoneRegistryImpl")) : class$net$fortuna$ical4j$model$TimeZoneRegistryImpl);
                log.warn((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unable to retrieve updates for timezone: ").append(vTimeZone.getTimeZoneId().getValue()).toString(), (Throwable)e);
            }
        }
        return vTimeZone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)x1);
        }
    }

    static {
        try {
            ALIASES.load(ResourceLoader.getResourceAsStream((String)"org/ocpsoft/prettytime/natty/net/fortuna/ical4j/model/tz.alias"));
        }
        catch (IOException ioe) {
            LogFactory.getLog(class$net$fortuna$ical4j$model$TimeZoneRegistryImpl == null ? (class$net$fortuna$ical4j$model$TimeZoneRegistryImpl = TimeZoneRegistryImpl.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZoneRegistryImpl")) : class$net$fortuna$ical4j$model$TimeZoneRegistryImpl).warn((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Error loading timezone aliases: ").append(ioe.getMessage()).toString());
        }
    }
}

