/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.text.SimpleDateFormat;
import org.ocpsoft.prettytime.natty.java.util.Date;
import org.ocpsoft.prettytime.natty.java.util.TimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Iso8601;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.TimeZones;

public class Time
extends Iso8601 {
    private static final long serialVersionUID = -8401010870773304348L;
    private boolean utc = false;
    private static final String DEFAULT_PATTERN = "org.ocpsoft.prettytime.natty.HHmmss";
    private static final String UTC_PATTERN = "org.ocpsoft.prettytime.natty.HHmmss'Z'";

    public Time(TimeZone timezone) {
        this(timezone, TimeZones.isUtc(timezone));
    }

    public Time(TimeZone timezone, boolean utc) {
        super((String)(utc ? "org.ocpsoft.prettytime.natty.HHmmss'Z'" : "org.ocpsoft.prettytime.natty.HHmmss"), 0, timezone);
        this.getFormat().setTimeZone(timezone);
        this.utc = utc;
    }

    public Time(long time, TimeZone timezone) {
        this(time, timezone, TimeZones.isUtc(timezone));
    }

    public Time(long time, TimeZone timezone, boolean utc) {
        super(time, (String)(utc ? "org.ocpsoft.prettytime.natty.HHmmss'Z'" : "org.ocpsoft.prettytime.natty.HHmmss"), 0, timezone);
        this.getFormat().setTimeZone(timezone);
        this.utc = utc;
    }

    public Time(Date time, TimeZone timezone) {
        this(time, timezone, TimeZones.isUtc(timezone));
    }

    public Time(Date time, TimeZone timezone, boolean utc) {
        super(time.getTime(), (String)(utc ? "org.ocpsoft.prettytime.natty.HHmmss'Z'" : "org.ocpsoft.prettytime.natty.HHmmss"), 0, timezone);
        this.getFormat().setTimeZone(timezone);
        this.utc = utc;
    }

    public Time(String value, TimeZone timezone) throws ParseException {
        this(value, timezone, TimeZones.isUtc(timezone));
    }

    public Time(String value, TimeZone timezone, boolean utc) throws ParseException {
        this(Time.parseDate(value, timezone), timezone, utc);
    }

    private static Date parseDate(String value, TimeZone timezone) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat((String)"org.ocpsoft.prettytime.natty.HHmmss");
        df.setTimeZone(timezone);
        try {
            return df.parse(value);
        }
        catch (ParseException e) {
            df = new SimpleDateFormat((String)"org.ocpsoft.prettytime.natty.HHmmss'Z'");
            df.setTimeZone(timezone);
            return df.parse(value);
        }
    }

    public final boolean isUtc() {
        return this.utc;
    }
}

