/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.UnsupportedOperationException;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Content;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Escapable;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Parameter;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ParameterList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PropertyFactory;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.Strings;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.EqualsBuilder;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class Property
extends Content {
    private static final long serialVersionUID = 7048785558435608687L;
    public static final String PRODID = "org.ocpsoft.prettytime.natty.PRODID";
    public static final String VERSION = "org.ocpsoft.prettytime.natty.VERSION";
    public static final String CALSCALE = "org.ocpsoft.prettytime.natty.CALSCALE";
    public static final String METHOD = "org.ocpsoft.prettytime.natty.METHOD";
    public static final String BUSYTYPE = "org.ocpsoft.prettytime.natty.BUSYTYPE";
    public static final String CLASS = "org.ocpsoft.prettytime.natty.CLASS";
    public static final String CREATED = "org.ocpsoft.prettytime.natty.CREATED";
    public static final String DESCRIPTION = "org.ocpsoft.prettytime.natty.DESCRIPTION";
    public static final String DTSTART = "org.ocpsoft.prettytime.natty.DTSTART";
    public static final String GEO = "org.ocpsoft.prettytime.natty.GEO";
    public static final String LAST_MODIFIED = "org.ocpsoft.prettytime.natty.LAST-MODIFIED";
    public static final String LOCATION = "org.ocpsoft.prettytime.natty.LOCATION";
    public static final String ORGANIZER = "org.ocpsoft.prettytime.natty.ORGANIZER";
    public static final String PERCENT_COMPLETE = "org.ocpsoft.prettytime.natty.PERCENT-COMPLETE";
    public static final String PRIORITY = "org.ocpsoft.prettytime.natty.PRIORITY";
    public static final String DTSTAMP = "org.ocpsoft.prettytime.natty.DTSTAMP";
    public static final String SEQUENCE = "org.ocpsoft.prettytime.natty.SEQUENCE";
    public static final String STATUS = "org.ocpsoft.prettytime.natty.STATUS";
    public static final String SUMMARY = "org.ocpsoft.prettytime.natty.SUMMARY";
    public static final String TRANSP = "org.ocpsoft.prettytime.natty.TRANSP";
    public static final String UID = "org.ocpsoft.prettytime.natty.UID";
    public static final String URL = "org.ocpsoft.prettytime.natty.URL";
    public static final String RECURRENCE_ID = "org.ocpsoft.prettytime.natty.RECURRENCE-ID";
    public static final String COMPLETED = "org.ocpsoft.prettytime.natty.COMPLETED";
    public static final String DUE = "org.ocpsoft.prettytime.natty.DUE";
    public static final String FREEBUSY = "org.ocpsoft.prettytime.natty.FREEBUSY";
    public static final String TZID = "org.ocpsoft.prettytime.natty.TZID";
    public static final String TZNAME = "org.ocpsoft.prettytime.natty.TZNAME";
    public static final String TZOFFSETFROM = "org.ocpsoft.prettytime.natty.TZOFFSETFROM";
    public static final String TZOFFSETTO = "org.ocpsoft.prettytime.natty.TZOFFSETTO";
    public static final String TZURL = "org.ocpsoft.prettytime.natty.TZURL";
    public static final String ACTION = "org.ocpsoft.prettytime.natty.ACTION";
    public static final String REPEAT = "org.ocpsoft.prettytime.natty.REPEAT";
    public static final String TRIGGER = "org.ocpsoft.prettytime.natty.TRIGGER";
    public static final String REQUEST_STATUS = "org.ocpsoft.prettytime.natty.REQUEST-STATUS";
    public static final String DTEND = "org.ocpsoft.prettytime.natty.DTEND";
    public static final String DURATION = "org.ocpsoft.prettytime.natty.DURATION";
    public static final String ATTACH = "org.ocpsoft.prettytime.natty.ATTACH";
    public static final String ATTENDEE = "org.ocpsoft.prettytime.natty.ATTENDEE";
    public static final String CATEGORIES = "org.ocpsoft.prettytime.natty.CATEGORIES";
    public static final String COMMENT = "org.ocpsoft.prettytime.natty.COMMENT";
    public static final String CONTACT = "org.ocpsoft.prettytime.natty.CONTACT";
    public static final String EXDATE = "org.ocpsoft.prettytime.natty.EXDATE";
    public static final String EXRULE = "org.ocpsoft.prettytime.natty.EXRULE";
    public static final String RELATED_TO = "org.ocpsoft.prettytime.natty.RELATED-TO";
    public static final String RESOURCES = "org.ocpsoft.prettytime.natty.RESOURCES";
    public static final String RDATE = "org.ocpsoft.prettytime.natty.RDATE";
    public static final String RRULE = "org.ocpsoft.prettytime.natty.RRULE";
    public static final String EXPERIMENTAL_PREFIX = "org.ocpsoft.prettytime.natty.X-";
    public static final String COUNTRY = "org.ocpsoft.prettytime.natty.COUNTRY";
    public static final String EXTENDED_ADDRESS = "org.ocpsoft.prettytime.natty.EXTENDED-ADDRESS";
    public static final String LOCALITY = "org.ocpsoft.prettytime.natty.LOCALITY";
    public static final String LOCATION_TYPE = "org.ocpsoft.prettytime.natty.LOCATION-TYPE";
    public static final String NAME = "org.ocpsoft.prettytime.natty.NAME";
    public static final String POSTALCODE = "org.ocpsoft.prettytime.natty.POSTAL-CODE";
    public static final String REGION = "org.ocpsoft.prettytime.natty.REGION";
    public static final String STREET_ADDRESS = "org.ocpsoft.prettytime.natty.STREET-ADDRESS";
    public static final String TEL = "org.ocpsoft.prettytime.natty.TEL";
    private String name;
    private ParameterList parameters;
    private final PropertyFactory factory;

    protected Property(String aName, PropertyFactory factory) {
        this(aName, new ParameterList(), factory);
    }

    protected Property(String aName, ParameterList aList, PropertyFactory factory) {
        this.name = aName;
        this.parameters = aList;
        this.factory = factory;
    }

    protected Property(Property property) throws IOException, URISyntaxException, ParseException {
        this(property.getName(), new ParameterList(property.getParameters(), false), property.factory);
        this.setValue(property.getValue());
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        if (this.getParameters() != null) {
            buffer.append((Object)this.getParameters());
        }
        buffer.append(':');
        if (this instanceof Escapable) {
            buffer.append(Strings.escape(Strings.valueOf((Object)this.getValue())));
        } else {
            buffer.append(Strings.valueOf((Object)this.getValue()));
        }
        buffer.append((String)"org.ocpsoft.prettytime.natty.\r\n");
        return buffer.toString();
    }

    public boolean isCalendarProperty() {
        return "org.ocpsoft.prettytime.natty.PRODID".equalsIgnoreCase(this.getName()) || "org.ocpsoft.prettytime.natty.VERSION".equalsIgnoreCase(this.getName()) || "org.ocpsoft.prettytime.natty.CALSCALE".equalsIgnoreCase(this.getName()) || "org.ocpsoft.prettytime.natty.METHOD".equalsIgnoreCase(this.getName());
    }

    public final String getName() {
        return this.name;
    }

    public final ParameterList getParameters() {
        return this.parameters;
    }

    public final ParameterList getParameters(String name) {
        return this.getParameters().getParameters(name);
    }

    public final Parameter getParameter(String name) {
        return this.getParameters().getParameter(name);
    }

    public abstract void setValue(String var1) throws IOException, URISyntaxException, ParseException;

    public abstract void validate() throws ValidationException;

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Property) {
            Property p = (Property)arg0;
            if (this.getName().equals((Object)p.getName())) {
                return new EqualsBuilder().append((Object)this.getValue(), (Object)p.getValue()).append(this.getParameters(), p.getParameters()).isEquals();
            }
            return false;
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName().toUpperCase()).append((Object)this.getValue()).append(this.getParameters()).toHashCode();
    }

    public Property copy() throws IOException, URISyntaxException, ParseException {
        if (this.factory == null) {
            throw new UnsupportedOperationException((String)"org.ocpsoft.prettytime.natty.No factory specified");
        }
        ParameterList params = new ParameterList(this.getParameters(), false);
        return this.factory.createProperty(this.getName(), params, this.getValue());
    }
}

