/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.Collections;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.Set;
import org.ocpsoft.prettytime.natty.java.util.StringTokenizer;
import org.ocpsoft.prettytime.natty.java.util.TreeSet;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Period;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZone;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.EqualsBuilder;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public class PeriodList
extends Object
implements Set,
Serializable {
    private static final long serialVersionUID = -2317587285790834492L;
    private final Set periods;
    private TimeZone timezone;
    private boolean utc;
    static /* synthetic */ Class class$net$fortuna$ical4j$model$Period;

    public PeriodList() {
        this(true);
    }

    public PeriodList(boolean utc) {
        this(utc, false);
    }

    public PeriodList(boolean utc, boolean unmodifiable) {
        this.utc = utc;
        this.periods = unmodifiable ? Collections.EMPTY_SET : new TreeSet();
    }

    public PeriodList(String aValue) throws ParseException {
        this();
        StringTokenizer t = new StringTokenizer(aValue, (String)"org.ocpsoft.prettytime.natty.,");
        while (t.hasMoreTokens()) {
            this.add((Object)new Period(t.nextToken()));
        }
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            b.append(i.next().toString());
            if (!i.hasNext()) continue;
            b.append(',');
        }
        return b.toString();
    }

    public final boolean add(Period period) {
        if (this.isUtc()) {
            period.setUtc(true);
        } else {
            period.setTimeZone(this.timezone);
        }
        return this.add((Object)period);
    }

    public final boolean add(Object period) {
        if (!(period instanceof Period)) {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Argument not a ").append((class$net$fortuna$ical4j$model$Period == null ? (class$net$fortuna$ical4j$model$Period = PeriodList.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Period")) : class$net$fortuna$ical4j$model$Period).getName()).toString());
        }
        return this.periods.add(period);
    }

    public final boolean remove(Period period) {
        return this.remove((Object)period);
    }

    public final PeriodList normalise() {
        Period prevPeriod = null;
        Period period = null;
        PeriodList newList = new PeriodList(this.isUtc());
        if (this.timezone != null) {
            newList.setTimeZone(this.timezone);
        }
        boolean normalised = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            period = (Period)i.next();
            if (period.isEmpty()) {
                period = prevPeriod;
                normalised = true;
            } else if (prevPeriod != null) {
                if (prevPeriod.contains(period)) {
                    period = prevPeriod;
                    normalised = true;
                } else if (prevPeriod.intersects(period)) {
                    period = prevPeriod.add(period);
                    normalised = true;
                } else if (prevPeriod.adjacent(period)) {
                    period = prevPeriod.add(period);
                    normalised = true;
                } else {
                    newList.add(prevPeriod);
                }
            }
            prevPeriod = period;
        }
        if (prevPeriod != null) {
            newList.add(prevPeriod);
        }
        if (normalised) {
            return newList;
        }
        return this;
    }

    public final PeriodList add(PeriodList periods) {
        if (periods != null) {
            PeriodList newList = new PeriodList();
            newList.addAll((Collection)this);
            Iterator i = periods.iterator();
            while (i.hasNext()) {
                newList.add((Period)i.next());
            }
            return newList.normalise();
        }
        return this;
    }

    public final PeriodList subtract(PeriodList subtractions) {
        if (subtractions == null || subtractions.isEmpty()) {
            return this;
        }
        PeriodList result = this;
        PeriodList tmpResult = new PeriodList();
        Iterator i = subtractions.iterator();
        while (i.hasNext()) {
            Period subtraction = (Period)i.next();
            Iterator j = result.iterator();
            while (j.hasNext()) {
                Period period = (Period)j.next();
                tmpResult.addAll((Collection)period.subtract(subtraction));
            }
            result = tmpResult;
            tmpResult = new PeriodList();
        }
        return result;
    }

    public final boolean isUtc() {
        return this.utc;
    }

    public final void setUtc(boolean utc) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Period period = (Period)i.next();
            period.setUtc(utc);
        }
        this.timezone = null;
        this.utc = utc;
    }

    public final void setTimeZone(TimeZone timeZone) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Period period = (Period)i.next();
            period.setTimeZone(timeZone);
        }
        this.timezone = timeZone;
        this.utc = false;
    }

    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    public boolean addAll(Collection arg0) {
        Iterator i = arg0.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
        return true;
    }

    public void clear() {
        this.periods.clear();
    }

    public boolean contains(Object o) {
        return this.periods.contains(o);
    }

    public boolean containsAll(Collection arg0) {
        return this.periods.containsAll(arg0);
    }

    public boolean isEmpty() {
        return this.periods.isEmpty();
    }

    public Iterator iterator() {
        return this.periods.iterator();
    }

    public boolean remove(Object o) {
        return this.periods.remove(o);
    }

    public boolean removeAll(Collection arg0) {
        return this.periods.removeAll(arg0);
    }

    public boolean retainAll(Collection arg0) {
        return this.periods.retainAll(arg0);
    }

    public int size() {
        return this.periods.size();
    }

    public Object[] toArray() {
        return this.periods.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.periods.toArray(arg0);
    }

    public boolean equals(Object obj) {
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        PeriodList rhs = (PeriodList)obj;
        return new EqualsBuilder().append((Object)this.periods, (Object)rhs.periods).append((Object)this.timezone, (Object)rhs.timezone).append(this.utc, this.utc).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.periods).append((Object)this.timezone).append(this.utc).toHashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)x1);
        }
    }
}

