/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.lang.CharSequence;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.UnsupportedOperationException;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Content;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ParameterFactory;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.Strings;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.EqualsBuilder;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class Parameter
extends Content {
    private static final long serialVersionUID = -2058497904769713528L;
    public static final String ABBREV = "org.ocpsoft.prettytime.natty.ABBREV";
    public static final String ALTREP = "org.ocpsoft.prettytime.natty.ALTREP";
    public static final String CN = "org.ocpsoft.prettytime.natty.CN";
    public static final String CUTYPE = "org.ocpsoft.prettytime.natty.CUTYPE";
    public static final String DELEGATED_FROM = "org.ocpsoft.prettytime.natty.DELEGATED-FROM";
    public static final String DELEGATED_TO = "org.ocpsoft.prettytime.natty.DELEGATED-TO";
    public static final String DIR = "org.ocpsoft.prettytime.natty.DIR";
    public static final String ENCODING = "org.ocpsoft.prettytime.natty.ENCODING";
    public static final String FMTTYPE = "org.ocpsoft.prettytime.natty.FMTTYPE";
    public static final String FBTYPE = "org.ocpsoft.prettytime.natty.FBTYPE";
    public static final String LANGUAGE = "org.ocpsoft.prettytime.natty.LANGUAGE";
    public static final String MEMBER = "org.ocpsoft.prettytime.natty.MEMBER";
    public static final String PARTSTAT = "org.ocpsoft.prettytime.natty.PARTSTAT";
    public static final String RANGE = "org.ocpsoft.prettytime.natty.RANGE";
    public static final String RELATED = "org.ocpsoft.prettytime.natty.RELATED";
    public static final String RELTYPE = "org.ocpsoft.prettytime.natty.RELTYPE";
    public static final String ROLE = "org.ocpsoft.prettytime.natty.ROLE";
    public static final String RSVP = "org.ocpsoft.prettytime.natty.RSVP";
    public static final String SCHEDULE_AGENT = "org.ocpsoft.prettytime.natty.SCHEDULE-AGENT";
    public static final String SCHEDULE_STATUS = "org.ocpsoft.prettytime.natty.SCHEDULE-STATUS";
    public static final String SENT_BY = "org.ocpsoft.prettytime.natty.SENT-BY";
    public static final String TYPE = "org.ocpsoft.prettytime.natty.TYPE";
    public static final String TZID = "org.ocpsoft.prettytime.natty.TZID";
    public static final String VALUE = "org.ocpsoft.prettytime.natty.VALUE";
    public static final String VVENUE = "org.ocpsoft.prettytime.natty.VVENUE";
    public static final String EXPERIMENTAL_PREFIX = "org.ocpsoft.prettytime.natty.X-";
    private String name;
    private final ParameterFactory factory;

    public Parameter(String aName, ParameterFactory factory) {
        this.name = aName;
        this.factory = factory;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getName());
        b.append('=');
        if (this.isQuotable()) {
            b.append(Strings.quote((Object)Strings.valueOf((Object)this.getValue())));
        } else {
            b.append(Strings.valueOf((Object)this.getValue()));
        }
        return b.toString();
    }

    protected boolean isQuotable() {
        return Strings.PARAM_QUOTE_PATTERN.matcher((CharSequence)Strings.valueOf((Object)this.getValue())).find();
    }

    public final String getName() {
        return this.name;
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Parameter) {
            Parameter p = (Parameter)arg0;
            return new EqualsBuilder().append((Object)this.getName(), (Object)p.getName()).append((Object)this.getValue(), (Object)p.getValue()).isEquals();
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName().toUpperCase()).append((Object)this.getValue()).toHashCode();
    }

    public final Parameter copy() throws URISyntaxException {
        if (this.factory == null) {
            throw new UnsupportedOperationException((String)"org.ocpsoft.prettytime.natty.No factory specified");
        }
        return this.factory.createParameter(this.getName(), this.getValue());
    }
}

