/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.ObjectInputStream;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Comparable;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.Math;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.util.Calendar;
import org.ocpsoft.prettytime.natty.java.util.StringTokenizer;
import org.ocpsoft.prettytime.natty.java.util.TimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.Dates;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public class Dur
extends Object
implements Comparable,
Serializable {
    private static final long serialVersionUID = 5013232281547134583L;
    private static final int DAYS_PER_WEEK = 7;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int DAYS_PER_YEAR = 365;
    private boolean negative;
    private int weeks;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;

    public Dur(String value) {
        this.negative = false;
        this.weeks = 0;
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        String token = null;
        String prevToken = null;
        StringTokenizer t = new StringTokenizer(value, (String)"org.ocpsoft.prettytime.natty.+-PWDTHMS", true);
        while (t.hasMoreTokens()) {
            prevToken = token;
            token = t.nextToken();
            if ("org.ocpsoft.prettytime.natty.+".equals((Object)token)) {
                this.negative = false;
                continue;
            }
            if ("org.ocpsoft.prettytime.natty.-".equals((Object)token)) {
                this.negative = true;
                continue;
            }
            if ("org.ocpsoft.prettytime.natty.P".equals((Object)token)) continue;
            if ("org.ocpsoft.prettytime.natty.W".equals((Object)token)) {
                this.weeks = Integer.parseInt((String)prevToken);
                continue;
            }
            if ("org.ocpsoft.prettytime.natty.D".equals((Object)token)) {
                this.days = Integer.parseInt((String)prevToken);
                continue;
            }
            if ("org.ocpsoft.prettytime.natty.T".equals((Object)token)) continue;
            if ("org.ocpsoft.prettytime.natty.H".equals((Object)token)) {
                this.hours = Integer.parseInt((String)prevToken);
                continue;
            }
            if ("org.ocpsoft.prettytime.natty.M".equals((Object)token)) {
                this.minutes = Integer.parseInt((String)prevToken);
                continue;
            }
            if (!"org.ocpsoft.prettytime.natty.S".equals((Object)token)) continue;
            this.seconds = Integer.parseInt((String)prevToken);
        }
    }

    public Dur(int weeks) {
        this.weeks = Math.abs((int)weeks);
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        this.negative = weeks < 0;
    }

    public Dur(int days, int hours, int minutes, int seconds) {
        if (!(days >= 0 && hours >= 0 && minutes >= 0 && seconds >= 0 || days <= 0 && hours <= 0 && minutes <= 0 && seconds <= 0)) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.Invalid duration representation");
        }
        this.weeks = 0;
        this.days = Math.abs((int)days);
        this.hours = Math.abs((int)hours);
        this.minutes = Math.abs((int)minutes);
        this.seconds = Math.abs((int)seconds);
        this.negative = days < 0 || hours < 0 || minutes < 0 || seconds < 0;
    }

    public Dur(org.ocpsoft.prettytime.natty.java.util.Date date1, org.ocpsoft.prettytime.natty.java.util.Date date2) {
        org.ocpsoft.prettytime.natty.java.util.Date start = null;
        org.ocpsoft.prettytime.natty.java.util.Date end = null;
        boolean bl = this.negative = date1.compareTo(date2) > 0;
        if (this.negative) {
            start = date2;
            end = date1;
        } else {
            start = date1;
            end = date2;
        }
        Calendar startCal = start instanceof Date ? Dates.getCalendarInstance((Date)start) : Calendar.getInstance();
        startCal.setTime(start);
        Calendar endCal = Calendar.getInstance((TimeZone)startCal.getTimeZone());
        endCal.setTime(end);
        int dur = 0;
        int nYears = endCal.get(1) - startCal.get(1);
        while (nYears > 0) {
            startCal.add(5, 365 * nYears);
            dur += 365 * nYears;
            nYears = endCal.get(1) - startCal.get(1);
        }
        dur += endCal.get(6) - startCal.get(6);
        dur *= 24;
        dur += endCal.get(11) - startCal.get(11);
        dur *= 60;
        dur += endCal.get(12) - startCal.get(12);
        dur *= 60;
        this.seconds = (dur += endCal.get(13) - startCal.get(13)) % 60;
        this.minutes = (dur /= 60) % 60;
        this.hours = (dur /= 60) % 24;
        this.days = dur /= 24;
        this.weeks = 0;
        if (this.seconds == 0 && this.minutes == 0 && this.hours == 0 && this.days % 7 == 0) {
            this.weeks = this.days / 7;
            this.days = 0;
        }
    }

    public final org.ocpsoft.prettytime.natty.java.util.Date getTime(org.ocpsoft.prettytime.natty.java.util.Date start) {
        Calendar cal = start instanceof Date ? Dates.getCalendarInstance((Date)start) : Calendar.getInstance();
        cal.setTime(start);
        if (this.isNegative()) {
            cal.add(3, -this.weeks);
            cal.add(7, -this.days);
            cal.add(11, -this.hours);
            cal.add(12, -this.minutes);
            cal.add(13, -this.seconds);
        } else {
            cal.add(3, this.weeks);
            cal.add(7, this.days);
            cal.add(11, this.hours);
            cal.add(12, this.minutes);
            cal.add(13, this.seconds);
        }
        return cal.getTime();
    }

    public final Dur negate() {
        Dur negated = new Dur(this.days, this.hours, this.minutes, this.seconds);
        negated.weeks = this.weeks;
        negated.negative = !this.negative;
        return negated;
    }

    public final Dur add(Dur duration) {
        if (!this.isNegative() && duration.isNegative() || this.isNegative() && !duration.isNegative()) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.Cannot add a negative and a positive duration");
        }
        Dur sum = null;
        if (this.weeks > 0 && duration.weeks > 0) {
            sum = new Dur(this.weeks + duration.weeks);
        } else {
            int daySum = this.weeks > 0 ? this.weeks * 7 + this.days : this.days;
            int hourSum = this.hours;
            int minuteSum = this.minutes;
            int secondSum = this.seconds;
            if ((secondSum + duration.seconds) / 60 > 0) {
                minuteSum += (secondSum + duration.seconds) / 60;
                secondSum = (secondSum + duration.seconds) % 60;
            } else {
                secondSum += duration.seconds;
            }
            if ((minuteSum + duration.minutes) / 60 > 0) {
                hourSum += (minuteSum + duration.minutes) / 60;
                minuteSum = (minuteSum + duration.minutes) % 60;
            } else {
                minuteSum += duration.minutes;
            }
            if ((hourSum + duration.hours) / 24 > 0) {
                daySum += (hourSum + duration.hours) / 24;
                hourSum = (hourSum + duration.hours) % 24;
            } else {
                hourSum += duration.hours;
            }
            sum = new Dur(daySum += duration.weeks > 0 ? duration.weeks * 7 + duration.days : duration.days, hourSum, minuteSum, secondSum);
        }
        sum.negative = this.negative;
        return sum;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        if (this.negative) {
            b.append('-');
        }
        b.append('P');
        if (this.weeks > 0) {
            b.append(this.weeks);
            b.append('W');
        } else {
            if (this.days > 0) {
                b.append(this.days);
                b.append('D');
            }
            if (this.hours > 0 || this.minutes > 0 || this.seconds > 0) {
                b.append('T');
                if (this.hours > 0) {
                    b.append(this.hours);
                    b.append('H');
                }
                if (this.minutes > 0) {
                    b.append(this.minutes);
                    b.append('M');
                }
                if (this.seconds > 0) {
                    b.append(this.seconds);
                    b.append('S');
                }
            }
            if (this.hours + this.minutes + this.seconds + this.days + this.weeks == 0) {
                b.append((String)"org.ocpsoft.prettytime.natty.T0S");
            }
        }
        return b.toString();
    }

    public final int compareTo(Object arg0) {
        return this.compareTo((Dur)arg0);
    }

    public final int compareTo(Dur arg0) {
        if (this.isNegative() != arg0.isNegative()) {
            if (this.isNegative()) {
                return java.lang.Integer.MIN_VALUE;
            }
            return java.lang.Integer.MAX_VALUE;
        }
        int result = this.getWeeks() != arg0.getWeeks() ? this.getWeeks() - arg0.getWeeks() : (this.getDays() != arg0.getDays() ? this.getDays() - arg0.getDays() : (this.getHours() != arg0.getHours() ? this.getHours() - arg0.getHours() : (this.getMinutes() != arg0.getMinutes() ? this.getMinutes() - arg0.getMinutes() : this.getSeconds() - arg0.getSeconds())));
        if (this.isNegative()) {
            return -result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Dur) {
            return ((Dur)obj).compareTo(this) == 0;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.weeks).append(this.days).append(this.hours).append(this.minutes).append(this.seconds).append(this.negative).toHashCode();
    }

    public final int getDays() {
        return this.days;
    }

    public final int getHours() {
        return this.hours;
    }

    public final int getMinutes() {
        return this.minutes;
    }

    public final boolean isNegative() {
        return this.negative;
    }

    public final int getSeconds() {
        return this.seconds;
    }

    public final int getWeeks() {
        return this.weeks;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

