/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Thread;
import org.ocpsoft.prettytime.natty.java.text.DateFormat;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.text.SimpleDateFormat;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.java.util.WeakHashMap;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.CalendarDateFormatFactory;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Time;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.CompatibilityHints;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.TimeZones;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.EqualsBuilder;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public class DateTime
extends Date {
    private static final long serialVersionUID = -6407231357919440387L;
    private static final String DEFAULT_PATTERN = "org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss";
    private static final String UTC_PATTERN = "org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss'Z'";
    private static final String RELAXED_PATTERN = "org.ocpsoft.prettytime.natty.yyyyMMdd";
    private static final DateFormatCache UTC_FORMAT;
    private static final DateFormatCache DEFAULT_FORMAT;
    private static final DateFormatCache LENIENT_DEFAULT_FORMAT;
    private static final DateFormatCache RELAXED_FORMAT;
    private Time time;
    private TimeZone timezone;

    public DateTime() {
        super(0, org.ocpsoft.prettytime.natty.java.util.TimeZone.getDefault());
        this.time = new Time(this.getTime(), this.getFormat().getTimeZone());
    }

    public DateTime(boolean utc) {
        this();
        this.setUtc(utc);
    }

    public DateTime(long time) {
        super(time, 0, org.ocpsoft.prettytime.natty.java.util.TimeZone.getDefault());
        this.time = new Time(time, this.getFormat().getTimeZone());
    }

    public DateTime(org.ocpsoft.prettytime.natty.java.util.Date date) {
        super(date.getTime(), 0, org.ocpsoft.prettytime.natty.java.util.TimeZone.getDefault());
        this.time = new Time(date.getTime(), this.getFormat().getTimeZone());
        if (date instanceof DateTime) {
            DateTime dateTime = (DateTime)date;
            if (dateTime.isUtc()) {
                this.setUtc(true);
            } else {
                this.setTimeZone(dateTime.getTimeZone());
            }
        }
    }

    public DateTime(String value) throws ParseException {
        this(value, (TimeZone)null);
    }

    public DateTime(String value, TimeZone timezone) throws ParseException {
        super(0L, 0, (org.ocpsoft.prettytime.natty.java.util.TimeZone)(timezone != null ? timezone : org.ocpsoft.prettytime.natty.java.util.TimeZone.getDefault()));
        this.time = new Time(this.getTime(), this.getFormat().getTimeZone());
        try {
            this.setTime(value, UTC_FORMAT.get(), null);
            this.setUtc(true);
        }
        catch (ParseException pe) {
            block7: {
                try {
                    if (timezone != null) {
                        this.setTime(value, DEFAULT_FORMAT.get(), timezone);
                    } else {
                        this.setTime(value, LENIENT_DEFAULT_FORMAT.get(), this.getFormat().getTimeZone());
                    }
                }
                catch (ParseException pe2) {
                    if (CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.parsing.relaxed")) {
                        this.setTime(value, RELAXED_FORMAT.get(), timezone);
                        break block7;
                    }
                    throw pe2;
                }
            }
            this.setTimeZone(timezone);
        }
    }

    public DateTime(String value, String pattern, TimeZone timezone) throws ParseException {
        super(0L, 0, (org.ocpsoft.prettytime.natty.java.util.TimeZone)(timezone != null ? timezone : org.ocpsoft.prettytime.natty.java.util.TimeZone.getDefault()));
        this.time = new Time(this.getTime(), this.getFormat().getTimeZone());
        DateFormat format = CalendarDateFormatFactory.getInstance(pattern);
        this.setTime(value, format, timezone);
    }

    public DateTime(String value, String pattern, boolean utc) throws ParseException {
        this(0L);
        DateFormat format = CalendarDateFormatFactory.getInstance(pattern);
        if (utc) {
            this.setTime(value, format, UTC_FORMAT.get().getTimeZone());
        } else {
            this.setTime(value, format, null);
        }
        this.setUtc(utc);
    }

    private void setTime(String value, DateFormat format, org.ocpsoft.prettytime.natty.java.util.TimeZone tz) throws ParseException {
        if (tz != null) {
            format.setTimeZone(tz);
        }
        this.setTime(format.parse(value).getTime());
    }

    public final void setTime(long time) {
        super.setTime(time);
        if (this.time != null) {
            this.time.setTime(time);
        }
    }

    public final boolean isUtc() {
        return this.time.isUtc();
    }

    public final void setUtc(boolean utc) {
        this.timezone = null;
        if (utc) {
            this.getFormat().setTimeZone(TimeZones.getUtcTimeZone());
        } else {
            this.resetTimeZone();
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone(), utc);
    }

    public final void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        if (timezone != null) {
            this.getFormat().setTimeZone((org.ocpsoft.prettytime.natty.java.util.TimeZone)timezone);
        } else {
            this.resetTimeZone();
        }
        this.time = new Time(this.time, this.getFormat().getTimeZone(), false);
    }

    private void resetTimeZone() {
        this.getFormat().setTimeZone(TimeZone.getDefault());
    }

    public final TimeZone getTimeZone() {
        return this.timezone;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer(super.toString());
        b.append('T');
        b.append(this.time.toString());
        return b.toString();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof DateTime) {
            return new EqualsBuilder().append((Object)this.time, (Object)((DateTime)arg0).time).isEquals();
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.time).append((Object)this.timezone).toHashCode();
    }

    static {
        SimpleDateFormat format = new SimpleDateFormat((String)"org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss'Z'");
        format.setTimeZone(TimeZones.getUtcTimeZone());
        format.setLenient(false);
        UTC_FORMAT = new DateFormatCache((DateFormat)format);
        format = new SimpleDateFormat((String)"org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss");
        format.setLenient(false);
        DEFAULT_FORMAT = new DateFormatCache((DateFormat)format);
        format = new SimpleDateFormat((String)"org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss");
        LENIENT_DEFAULT_FORMAT = new DateFormatCache((DateFormat)format);
        format = new SimpleDateFormat((String)"org.ocpsoft.prettytime.natty.yyyyMMdd");
        RELAXED_FORMAT = new DateFormatCache((DateFormat)format);
    }

    private static class DateFormatCache
    extends Object {
        private final Map threadMap = new WeakHashMap();
        private final DateFormat templateFormat;

        private DateFormatCache(DateFormat dateFormat) {
            this.templateFormat = dateFormat;
        }

        public DateFormat get() {
            DateFormat dateFormat = (DateFormat)this.threadMap.get((Object)Thread.currentThread());
            if (dateFormat == null) {
                dateFormat = (DateFormat)this.templateFormat.clone();
                this.threadMap.put((Object)Thread.currentThread(), (Object)dateFormat);
            }
            return dateFormat;
        }
    }
}

