/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.util.Date;

public class DateRange
extends Object
implements Serializable {
    private static final long serialVersionUID = -7303846680559287286L;
    public static final int INCLUSIVE_START = 1;
    public static final int INCLUSIVE_END = 2;
    private final Date rangeStart;
    private final Date rangeEnd;

    public DateRange(Date start, Date end) {
        if (start == null) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.Range start is null");
        }
        if (end == null) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.Range end is null");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.Range start must be before range end");
        }
        this.rangeStart = start;
        this.rangeEnd = end;
    }

    public Date getRangeStart() {
        return this.rangeStart;
    }

    public Date getRangeEnd() {
        return this.rangeEnd;
    }

    public final boolean includes(Date date) {
        return this.includes(date, 3);
    }

    public final boolean includes(Date date, int inclusiveMask) {
        boolean includes = true;
        if ((inclusiveMask & 1) > 0) {
            includes = includes && !this.rangeStart.after(date);
        } else {
            boolean bl = includes = includes && this.rangeStart.before(date);
        }
        includes = (inclusiveMask & 2) > 0 ? includes && !this.rangeEnd.before(date) : includes && this.rangeEnd.after(date);
        return includes;
    }

    public final boolean before(DateRange range) {
        return this.rangeEnd.before(range.getRangeStart());
    }

    public final boolean after(DateRange range) {
        return this.rangeStart.after(range.getRangeEnd());
    }

    public final boolean intersects(DateRange range) {
        boolean intersects = false;
        if (range.includes(this.rangeStart) && !range.getRangeEnd().equals((Object)this.rangeStart)) {
            intersects = true;
        } else if (this.includes(range.getRangeStart()) && !this.rangeEnd.equals((Object)range.getRangeStart())) {
            intersects = true;
        }
        return intersects;
    }

    public final boolean adjacent(DateRange range) {
        boolean adjacent = false;
        if (this.rangeStart.equals((Object)range.getRangeEnd())) {
            adjacent = true;
        } else if (this.rangeEnd.equals((Object)range.getRangeStart())) {
            adjacent = true;
        }
        return adjacent;
    }

    public final boolean contains(DateRange range) {
        return this.includes(range.getRangeStart()) && this.includes(range.getRangeEnd());
    }
}

