/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.Collections;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.java.util.ListIterator;
import org.ocpsoft.prettytime.natty.java.util.StringTokenizer;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.TimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.parameter.Value;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.EqualsBuilder;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public class DateList
extends org.ocpsoft.prettytime.natty.java.lang.Object
implements List,
Serializable {
    private static final long serialVersionUID = -3700862452550012357L;
    private final Value type;
    private final List dates;
    private TimeZone timeZone;
    private boolean utc;
    static /* synthetic */ Class class$net$fortuna$ical4j$model$Date;

    public DateList() {
        this(false);
    }

    public DateList(boolean unmodifiable) {
        this.type = Value.DATE_TIME;
        this.dates = unmodifiable ? Collections.EMPTY_LIST : new ArrayList();
    }

    public DateList(int initialCapacity) {
        this();
    }

    public DateList(Value aType) {
        this(aType, null);
    }

    public DateList(Value aType, TimeZone timezone) {
        this.type = aType != null ? aType : Value.DATE_TIME;
        this.timeZone = timezone;
        this.dates = new ArrayList();
    }

    public DateList(String aValue, Value aType) throws ParseException {
        this(aValue, aType, null);
    }

    public DateList(String aValue, Value aType, TimeZone timezone) throws ParseException {
        this(aType, timezone);
        StringTokenizer t = new StringTokenizer(aValue, (String)"org.ocpsoft.prettytime.natty.,");
        while (t.hasMoreTokens()) {
            if (Value.DATE.equals(this.type)) {
                this.add((org.ocpsoft.prettytime.natty.java.lang.Object)new Date(t.nextToken()));
                continue;
            }
            this.add((org.ocpsoft.prettytime.natty.java.lang.Object)new DateTime(t.nextToken(), timezone));
        }
    }

    public DateList(DateList list, Value type) {
        if (!Value.DATE.equals(type) && !Value.DATE_TIME.equals(type)) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.Type must be either DATE or DATE-TIME");
        }
        this.type = type;
        this.dates = new ArrayList();
        if (Value.DATE.equals(type)) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.add(new Date((Date)i.next()));
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.add(new DateTime((Date)i.next()));
            }
        }
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            b.append(i.next());
            if (!i.hasNext()) continue;
            b.append(',');
        }
        return b.toString();
    }

    public final boolean add(Date date) {
        if (date instanceof DateTime) {
            if (this.isUtc()) {
                ((DateTime)date).setUtc(true);
            } else {
                ((DateTime)date).setTimeZone(this.getTimeZone());
            }
        } else if (!Value.DATE.equals(this.getType())) {
            DateTime dateTime = new DateTime(date);
            dateTime.setTimeZone(this.getTimeZone());
            return this.add((org.ocpsoft.prettytime.natty.java.lang.Object)dateTime);
        }
        return this.add((org.ocpsoft.prettytime.natty.java.lang.Object)date);
    }

    public final boolean add(org.ocpsoft.prettytime.natty.java.lang.Object date) {
        if (!(date instanceof Date)) {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Argument not a ").append((class$net$fortuna$ical4j$model$Date == null ? (class$net$fortuna$ical4j$model$Date = DateList.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date")) : class$net$fortuna$ical4j$model$Date).getName()).toString());
        }
        return this.dates.add(date);
    }

    public final boolean remove(Date date) {
        return this.remove((org.ocpsoft.prettytime.natty.java.lang.Object)date);
    }

    public final Value getType() {
        return this.type;
    }

    public final boolean isUtc() {
        return this.utc;
    }

    public final void setUtc(boolean utc) {
        if (!Value.DATE.equals(this.type)) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((DateTime)i.next()).setUtc(utc);
            }
        }
        this.timeZone = null;
        this.utc = utc;
    }

    public final void setTimeZone(TimeZone timeZone) {
        if (!Value.DATE.equals(this.type)) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((DateTime)i.next()).setTimeZone(timeZone);
            }
        }
        this.timeZone = timeZone;
        this.utc = false;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void add(int arg0, org.ocpsoft.prettytime.natty.java.lang.Object arg1) {
        this.dates.add(arg0, arg1);
    }

    public boolean addAll(Collection arg0) {
        return this.dates.addAll(arg0);
    }

    public boolean addAll(int arg0, Collection arg1) {
        return this.dates.addAll(arg0, arg1);
    }

    public void clear() {
        this.dates.clear();
    }

    public boolean contains(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        return this.dates.contains(o);
    }

    public boolean containsAll(Collection arg0) {
        return this.dates.containsAll(arg0);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object get(int index) {
        return this.dates.get(index);
    }

    public int indexOf(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        return this.dates.indexOf(o);
    }

    public boolean isEmpty() {
        return this.dates.isEmpty();
    }

    public Iterator iterator() {
        return this.dates.iterator();
    }

    public int lastIndexOf(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        return this.dates.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.dates.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.dates.listIterator(index);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object remove(int index) {
        return this.dates.remove(index);
    }

    public boolean remove(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        return this.dates.remove(o);
    }

    public boolean removeAll(Collection arg0) {
        return this.dates.removeAll(arg0);
    }

    public boolean retainAll(Collection arg0) {
        return this.dates.retainAll(arg0);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object set(int arg0, org.ocpsoft.prettytime.natty.java.lang.Object arg1) {
        return this.dates.set(arg0, arg1);
    }

    public int size() {
        return this.dates.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.dates.subList(fromIndex, toIndex);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray() {
        return this.dates.toArray();
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray(org.ocpsoft.prettytime.natty.java.lang.Object[] arg0) {
        return this.dates.toArray(arg0);
    }

    public boolean equals(org.ocpsoft.prettytime.natty.java.lang.Object obj) {
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        DateList rhs = (DateList)obj;
        return new EqualsBuilder().append((org.ocpsoft.prettytime.natty.java.lang.Object)this.dates, (org.ocpsoft.prettytime.natty.java.lang.Object)rhs.dates).append(this.type, rhs.type).append((org.ocpsoft.prettytime.natty.java.lang.Object)this.timeZone, (org.ocpsoft.prettytime.natty.java.lang.Object)rhs.timeZone).append(this.utc, this.utc).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((org.ocpsoft.prettytime.natty.java.lang.Object)this.dates).append(this.type).append((org.ocpsoft.prettytime.natty.java.lang.Object)this.timeZone).append(this.utc).toHashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)x1);
        }
    }
}

