/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ComponentList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.Available;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.CalendarComponent;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.Daylight;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.Standard;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VAlarm;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VAvailability;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VEvent;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VFreeBusy;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VJournal;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VTimeZone;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VToDo;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.VVenue;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.XComponent;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.CompatibilityHints;

public final class ComponentFactory
extends Object {
    private static ComponentFactory instance = new ComponentFactory();

    private ComponentFactory() {
    }

    public static ComponentFactory getInstance() {
        return instance;
    }

    public Component createComponent(String name) {
        return this.createComponent(name, new PropertyList());
    }

    public Component createComponent(String name, PropertyList properties) {
        Component component = null;
        if ("org.ocpsoft.prettytime.natty.VALARM".equals((Object)name)) {
            component = new VAlarm(properties);
        } else if ("org.ocpsoft.prettytime.natty.VEVENT".equals((Object)name)) {
            component = new VEvent(properties);
        } else if ("org.ocpsoft.prettytime.natty.VFREEBUSY".equals((Object)name)) {
            component = new VFreeBusy(properties);
        } else if ("org.ocpsoft.prettytime.natty.VJOURNAL".equals((Object)name)) {
            component = new VJournal(properties);
        } else if ("org.ocpsoft.prettytime.natty.VTODO".equals((Object)name)) {
            component = new VToDo(properties);
        } else if ("org.ocpsoft.prettytime.natty.STANDARD".equals((Object)name)) {
            component = new Standard(properties);
        } else if ("org.ocpsoft.prettytime.natty.DAYLIGHT".equals((Object)name)) {
            component = new Daylight(properties);
        } else if ("org.ocpsoft.prettytime.natty.VTIMEZONE".equals((Object)name)) {
            component = new VTimeZone(properties);
        } else if ("org.ocpsoft.prettytime.natty.VVENUE".equals((Object)name)) {
            component = new VVenue(properties);
        } else if ("org.ocpsoft.prettytime.natty.VAVAILABILITY".equals((Object)name)) {
            component = new VAvailability(properties);
        } else if ("org.ocpsoft.prettytime.natty.AVAILABLE".equals((Object)name)) {
            component = new Available(properties);
        } else if (this.isExperimentalName(name)) {
            component = new XComponent(name, properties);
        } else if (this.allowIllegalNames()) {
            component = new XComponent(name, properties);
        } else {
            throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Illegal component [").append(name).append((String)"org.ocpsoft.prettytime.natty.]").toString());
        }
        return component;
    }

    public Component createComponent(String name, PropertyList properties, ComponentList components) {
        if (components != null) {
            CalendarComponent component = null;
            if ("org.ocpsoft.prettytime.natty.VTIMEZONE".equals((Object)name)) {
                component = new VTimeZone(properties, components);
            } else if ("org.ocpsoft.prettytime.natty.VEVENT".equals((Object)name)) {
                component = new VEvent(properties, components);
            } else {
                throw new IllegalArgumentException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Illegal component [").append(name).append((String)"org.ocpsoft.prettytime.natty.]").toString());
            }
            return component;
        }
        return this.createComponent(name, properties);
    }

    private boolean isExperimentalName(String name) {
        return name.startsWith((String)"org.ocpsoft.prettytime.natty.X-") && name.length() > "org.ocpsoft.prettytime.natty.X-".length();
    }

    protected boolean allowIllegalNames() {
        return CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.parsing.relaxed");
    }
}

