/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.UnsupportedOperationException;
import org.ocpsoft.prettytime.natty.java.text.FieldPosition;
import org.ocpsoft.prettytime.natty.java.text.NumberFormat;
import org.ocpsoft.prettytime.natty.java.text.ParsePosition;
import org.ocpsoft.prettytime.natty.java.text.SimpleDateFormat;
import org.ocpsoft.prettytime.natty.java.util.Calendar;
import org.ocpsoft.prettytime.natty.java.util.Date;
import org.ocpsoft.prettytime.natty.java.util.GregorianCalendar;
import org.ocpsoft.prettytime.natty.java.util.TimeZone;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory;

public final class CalendarDateFormatFactory
extends org.ocpsoft.prettytime.natty.java.lang.Object {
    private static final Log LOG = LogFactory.getLog(class$net$fortuna$ical4j$model$CalendarDateFormatFactory == null ? (class$net$fortuna$ical4j$model$CalendarDateFormatFactory = CalendarDateFormatFactory.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.CalendarDateFormatFactory")) : class$net$fortuna$ical4j$model$CalendarDateFormatFactory);
    private static final String DATETIME_PATTERN = "org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss";
    private static final String DATETIME_UTC_PATTERN = "org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss'Z'";
    private static final String DATE_PATTERN = "org.ocpsoft.prettytime.natty.yyyyMMdd";
    private static final String TIME_PATTERN = "org.ocpsoft.prettytime.natty.HHmmss";
    private static final String TIME_UTC_PATTERN = "org.ocpsoft.prettytime.natty.HHmmss'Z'";
    static /* synthetic */ Class class$net$fortuna$ical4j$model$CalendarDateFormatFactory;

    private CalendarDateFormatFactory() {
    }

    public static org.ocpsoft.prettytime.natty.java.text.DateFormat getInstance(String pattern) {
        CalendarDateFormat instance = null;
        if (pattern.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss") || pattern.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss'Z'")) {
            instance = new DateTimeFormat(pattern);
        } else if (pattern.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.yyyyMMdd")) {
            instance = new DateFormat(pattern);
        } else if (pattern.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.HHmmss") || pattern.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.HHmmss'Z'")) {
            instance = new TimeFormat(pattern);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.unexpected date format pattern: ").append(pattern).toString());
            }
            instance = new SimpleDateFormat(pattern);
        }
        return instance;
    }

    private static Calendar makeCalendar(boolean lenient, TimeZone timeZone, int year, int zeroBasedMonth, int day, int hour, int minutes, int seconds) {
        GregorianCalendar cal = new GregorianCalendar(timeZone);
        cal.setLenient(lenient);
        cal.set(year, zeroBasedMonth, day, hour, minutes, seconds);
        cal.set(14, 0);
        return cal;
    }

    private static Calendar makeCalendar(boolean lenient, TimeZone timeZone, int year, int month, int day) {
        return CalendarDateFormatFactory.makeCalendar(lenient, timeZone, year, month, day, 0, 0, 0);
    }

    private static void appendPadded(StringBuffer toAppendTo, int value, int fieldWidth) {
        String s = Integer.toString((int)value);
        int max = fieldWidth - s.length();
        for (int i = 0; i < max; ++i) {
            toAppendTo.append((String)"org.ocpsoft.prettytime.natty.0");
        }
        toAppendTo.append(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)x1);
        }
    }

    private static class TimeFormat
    extends CalendarDateFormat {
        private static final long serialVersionUID = -1367114409994225425L;
        final boolean patternEndsWithZ;

        public TimeFormat(String pattern) {
            super(pattern);
            this.patternEndsWithZ = pattern.endsWith((String)"org.ocpsoft.prettytime.natty.'Z'");
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTimeInMillis(date.getTime());
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(11), 2);
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(12), 2);
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(13), 2);
            if (this.patternEndsWithZ) {
                toAppendTo.append((String)"org.ocpsoft.prettytime.natty.Z");
            }
            return toAppendTo;
        }

        public Date parse(String source, ParsePosition pos) {
            if (this.patternEndsWithZ) {
                if (source.length() > "org.ocpsoft.prettytime.natty.HHmmss'Z'".length() && !this.isLenient()) {
                    pos.setErrorIndex("org.ocpsoft.prettytime.natty.HHmmss'Z'".length());
                    return null;
                }
            } else if (source.length() > "org.ocpsoft.prettytime.natty.HHmmss".length() && !this.isLenient()) {
                pos.setErrorIndex("org.ocpsoft.prettytime.natty.HHmmss".length());
                return null;
            }
            try {
                if (this.patternEndsWithZ && source.charAt(6) != 'Z') {
                    pos.setErrorIndex(6);
                    return null;
                }
                int hour = Integer.parseInt((String)source.substring(0, 2));
                int minute = Integer.parseInt((String)source.substring(2, 4));
                int second = Integer.parseInt((String)source.substring(4, 6));
                Date d = CalendarDateFormatFactory.makeCalendar(this.isLenient(), this.getTimeZone(), 1970, 0, 1, hour, minute, second).getTime();
                pos.setIndex(6);
                return d;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class DateFormat
    extends CalendarDateFormat {
        private static final long serialVersionUID = -7626077667268431779L;

        public DateFormat(String pattern) {
            super(pattern);
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            Calendar cal = Calendar.getInstance((TimeZone)this.getTimeZone());
            cal.setTimeInMillis(date.getTime());
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(1), 4);
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(2) + 1, 2);
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(5), 2);
            return toAppendTo;
        }

        public Date parse(String source, ParsePosition pos) {
            if (source.length() > "org.ocpsoft.prettytime.natty.yyyyMMdd".length() && !this.isLenient()) {
                pos.setErrorIndex("org.ocpsoft.prettytime.natty.yyyyMMdd".length());
                return null;
            }
            try {
                int year = Integer.parseInt((String)source.substring(0, 4));
                int month = Integer.parseInt((String)source.substring(4, 6)) - 1;
                int day = Integer.parseInt((String)source.substring(6, 8));
                Date d = CalendarDateFormatFactory.makeCalendar(this.isLenient(), this.getTimeZone(), year, month, day).getTime();
                pos.setIndex(8);
                return d;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class DateTimeFormat
    extends CalendarDateFormat {
        private static final long serialVersionUID = 3005824302269636122L;
        final boolean patternEndsWithZ;

        public DateTimeFormat(String pattern) {
            super(pattern);
            this.patternEndsWithZ = pattern.endsWith((String)"org.ocpsoft.prettytime.natty.'Z'");
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            GregorianCalendar cal = new GregorianCalendar(this.getTimeZone());
            cal.setTimeInMillis(date.getTime());
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(1), 4);
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(2) + 1, 2);
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(5), 2);
            toAppendTo.append((String)"org.ocpsoft.prettytime.natty.T");
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(11), 2);
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(12), 2);
            CalendarDateFormatFactory.appendPadded(toAppendTo, cal.get(13), 2);
            if (this.patternEndsWithZ) {
                toAppendTo.append((String)"org.ocpsoft.prettytime.natty.Z");
            }
            return toAppendTo;
        }

        public Date parse(String source, ParsePosition pos) {
            if (this.patternEndsWithZ) {
                if (source.length() > "org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss'Z'".length() && !this.isLenient()) {
                    pos.setErrorIndex("org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss'Z'".length());
                    return null;
                }
            } else if (source.length() > "org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss".length() && !this.isLenient()) {
                pos.setErrorIndex("org.ocpsoft.prettytime.natty.yyyyMMdd'T'HHmmss".length());
                return null;
            }
            try {
                if (source.charAt(8) != 'T') {
                    pos.setErrorIndex(8);
                    return null;
                }
                if (this.patternEndsWithZ && source.charAt(15) != 'Z') {
                    pos.setErrorIndex(15);
                    return null;
                }
                int year = Integer.parseInt((String)source.substring(0, 4));
                int month = Integer.parseInt((String)source.substring(4, 6)) - 1;
                int day = Integer.parseInt((String)source.substring(6, 8));
                int hour = Integer.parseInt((String)source.substring(9, 11));
                int minute = Integer.parseInt((String)source.substring(11, 13));
                int second = Integer.parseInt((String)source.substring(13, 15));
                Date d = CalendarDateFormatFactory.makeCalendar(this.isLenient(), this.getTimeZone(), year, month, day, hour, minute, second).getTime();
                pos.setIndex(15);
                return d;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static abstract class CalendarDateFormat
    extends org.ocpsoft.prettytime.natty.java.text.DateFormat {
        private static final long serialVersionUID = -4191402739860280205L;
        private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
        private final String pattern;
        private boolean lenient = true;
        private TimeZone timeZone = DEFAULT_TIME_ZONE;

        public CalendarDateFormat(String pattern) {
            this.pattern = pattern;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone tz) {
            this.timeZone = tz;
        }

        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }

        public boolean isLenient() {
            return this.lenient;
        }

        public Calendar getCalendar() {
            throw new UnsupportedOperationException();
        }

        public void setCalendar(Calendar c) {
            throw new UnsupportedOperationException();
        }

        public NumberFormat getNumberFormat() {
            throw new UnsupportedOperationException();
        }

        public void setNumberFormat(NumberFormat n) {
            throw new UnsupportedOperationException();
        }

        public org.ocpsoft.prettytime.natty.java.lang.Object clone() {
            CalendarDateFormat f = (CalendarDateFormat)CalendarDateFormatFactory.getInstance(this.pattern);
            f.setTimeZone(this.getTimeZone());
            f.setLenient(this.isLenient());
            return f;
        }

        public boolean equals(org.ocpsoft.prettytime.natty.java.lang.Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CalendarDateFormat that = (CalendarDateFormat)o;
            if (this.lenient != that.lenient) {
                return false;
            }
            if (!this.pattern.equals((org.ocpsoft.prettytime.natty.java.lang.Object)that.pattern)) {
                return false;
            }
            return this.timeZone.equals((org.ocpsoft.prettytime.natty.java.lang.Object)that.timeZone);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.pattern.hashCode();
            result = 31 * result + (this.lenient ? 1 : 0);
            result = 31 * result + this.timeZone.hashCode();
            return result;
        }
    }
}

