/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ComponentList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Property;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.component.CalendarComponent;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.CalScale;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Method;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.ProdId;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Version;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.XProperty;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.CompatibilityHints;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.ComponentValidator;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.PropertyValidator;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.EqualsBuilder;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.builder.HashCodeBuilder;

public class Calendar
extends org.ocpsoft.prettytime.natty.java.lang.Object
implements Serializable {
    private static final long serialVersionUID = -1654118204678581940L;
    public static final String BEGIN = "org.ocpsoft.prettytime.natty.BEGIN";
    public static final String VCALENDAR = "org.ocpsoft.prettytime.natty.VCALENDAR";
    public static final String END = "org.ocpsoft.prettytime.natty.END";
    private PropertyList properties;
    private ComponentList components;

    public Calendar() {
        this(new PropertyList(), new ComponentList());
    }

    public Calendar(ComponentList components) {
        this(new PropertyList(), components);
    }

    public Calendar(PropertyList p, ComponentList c) {
        this.properties = p;
        this.components = c;
    }

    public Calendar(Calendar c) throws ParseException, IOException, URISyntaxException {
        this(new PropertyList(c.getProperties()), new ComponentList(c.getComponents()));
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append((String)"org.ocpsoft.prettytime.natty.BEGIN");
        buffer.append(':');
        buffer.append((String)"org.ocpsoft.prettytime.natty.VCALENDAR");
        buffer.append((String)"org.ocpsoft.prettytime.natty.\r\n");
        buffer.append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getProperties());
        buffer.append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getComponents());
        buffer.append((String)"org.ocpsoft.prettytime.natty.END");
        buffer.append(':');
        buffer.append((String)"org.ocpsoft.prettytime.natty.VCALENDAR");
        buffer.append((String)"org.ocpsoft.prettytime.natty.\r\n");
        return buffer.toString();
    }

    public final ComponentList getComponents() {
        return this.components;
    }

    public final ComponentList getComponents(String name) {
        return this.getComponents().getComponents(name);
    }

    public final Component getComponent(String name) {
        return this.getComponents().getComponent(name);
    }

    public final PropertyList getProperties() {
        return this.properties;
    }

    public final PropertyList getProperties(String name) {
        return this.getProperties().getProperties(name);
    }

    public final Property getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public final void validate() throws ValidationException {
        this.validate(true);
    }

    public void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.PRODID", this.properties);
        PropertyValidator.getInstance().assertOne((String)"org.ocpsoft.prettytime.natty.VERSION", this.properties);
        if (!CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.validation.relaxed") && !Version.VERSION_2_0.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.VERSION"))) {
            throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unsupported Version: ").append(this.getProperty((String)"org.ocpsoft.prettytime.natty.VERSION").getValue()).toString());
        }
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.CALSCALE", this.properties);
        PropertyValidator.getInstance().assertOneOrLess((String)"org.ocpsoft.prettytime.natty.METHOD", this.properties);
        if (this.getComponents().isEmpty()) {
            throw new ValidationException((String)"org.ocpsoft.prettytime.natty.Calendar must contain at least one component");
        }
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            if (property instanceof XProperty || property.isCalendarProperty()) continue;
            throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Invalid property: ").append(property.getName()).toString());
        }
        i = this.getComponents().iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            if (component instanceof CalendarComponent) continue;
            throw new ValidationException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Not a valid calendar component: ").append(component.getName()).toString());
        }
        Method method = (Method)this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD");
        if (Method.PUBLISH.equals(method)) {
            if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VEVENT") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                if (!CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.validation.relaxed")) {
                    ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
                }
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VFREEBUSY") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VTODO") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VJOURNAL") != null) {
                // empty if block
            }
        } else if (Method.REQUEST.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD"))) {
            if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VEVENT") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VFREEBUSY") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VTODO") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
            }
        } else if (Method.REPLY.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD"))) {
            if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VEVENT") != null) {
                ComponentValidator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VFREEBUSY") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VTODO") != null) {
                ComponentValidator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
            }
        } else if (Method.ADD.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD"))) {
            if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VEVENT") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VTODO") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VJOURNAL") != null) {
                ComponentValidator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
            }
        } else if (Method.CANCEL.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD"))) {
            if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VEVENT") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VTODO") != null) {
                ComponentValidator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VJOURNAL") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
            }
        } else if (Method.REFRESH.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD"))) {
            if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VEVENT") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VTODO") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
            }
        } else if (Method.COUNTER.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD"))) {
            if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VEVENT") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VTODO") != null) {
                ComponentValidator.assertOneOrLess((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
            }
        } else if (Method.DECLINE_COUNTER.equals(this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD"))) {
            if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VEVENT") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTODO", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
            } else if (this.getComponent((String)"org.ocpsoft.prettytime.natty.VTODO") != null) {
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VALARM", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone((String)"org.ocpsoft.prettytime.natty.VJOURNAL", this.getComponents());
            }
        }
        if (method != null) {
            Iterator i2 = this.getComponents().iterator();
            while (i2.hasNext()) {
                CalendarComponent component = (CalendarComponent)i2.next();
                component.validate(method);
            }
        }
        if (recurse) {
            this.validateProperties();
            this.validateComponents();
        }
    }

    private void validateProperties() throws ValidationException {
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            property.validate();
        }
    }

    private void validateComponents() throws ValidationException {
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            component.validate();
        }
    }

    public final ProdId getProductId() {
        return (ProdId)this.getProperty((String)"org.ocpsoft.prettytime.natty.PRODID");
    }

    public final Version getVersion() {
        return (Version)this.getProperty((String)"org.ocpsoft.prettytime.natty.VERSION");
    }

    public final CalScale getCalendarScale() {
        return (CalScale)this.getProperty((String)"org.ocpsoft.prettytime.natty.CALSCALE");
    }

    public final Method getMethod() {
        return (Method)this.getProperty((String)"org.ocpsoft.prettytime.natty.METHOD");
    }

    public final boolean equals(org.ocpsoft.prettytime.natty.java.lang.Object arg0) {
        if (arg0 instanceof Calendar) {
            Calendar calendar = (Calendar)arg0;
            return new EqualsBuilder().append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getProperties(), (org.ocpsoft.prettytime.natty.java.lang.Object)calendar.getProperties()).append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getComponents(), (org.ocpsoft.prettytime.natty.java.lang.Object)calendar.getComponents()).isEquals();
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getProperties()).append((org.ocpsoft.prettytime.natty.java.lang.Object)this.getComponents()).toHashCode();
    }
}

