/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.net.URI;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.java.util.StringTokenizer;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.CompatibilityHints;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.Strings;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.util.Uris;

public class AddressList
extends Object
implements Serializable {
    private static final long serialVersionUID = 81383256078213569L;
    private List addresses = new CopyOnWriteArrayList();

    public AddressList() {
    }

    public AddressList(String aValue) throws URISyntaxException {
        StringTokenizer t = new StringTokenizer(aValue, (String)"org.ocpsoft.prettytime.natty.,");
        while (t.hasMoreTokens()) {
            try {
                this.addresses.add((Object)new URI(Uris.encode(Strings.unquote(t.nextToken()))));
            }
            catch (URISyntaxException use) {
                if (CompatibilityHints.isHintEnabled((String)"org.ocpsoft.prettytime.natty.ical4j.parsing.relaxed")) continue;
                throw use;
            }
        }
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.addresses.iterator();
        while (i.hasNext()) {
            b.append(Strings.quote((Object)Uris.decode(Strings.valueOf(i.next()))));
            if (!i.hasNext()) continue;
            b.append(',');
        }
        return b.toString();
    }

    public final boolean add(URI address) {
        return this.addresses.add((Object)address);
    }

    public final boolean isEmpty() {
        return this.addresses.isEmpty();
    }

    public final Iterator iterator() {
        return this.addresses.iterator();
    }

    public final boolean remove(URI address) {
        return this.addresses.remove((Object)address);
    }

    public final int size() {
        return this.addresses.size();
    }
}

