/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.io.Reader;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.text.SimpleDateFormat;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.javax.xml.parsers.DocumentBuilderFactory;
import org.ocpsoft.prettytime.natty.javax.xml.parsers.ParserConfigurationException;
import org.ocpsoft.prettytime.natty.javax.xml.xpath.XPath;
import org.ocpsoft.prettytime.natty.javax.xml.xpath.XPathConstants;
import org.ocpsoft.prettytime.natty.javax.xml.xpath.XPathException;
import org.ocpsoft.prettytime.natty.javax.xml.xpath.XPathExpression;
import org.ocpsoft.prettytime.natty.javax.xml.xpath.XPathFactory;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.CalendarParser;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.ContentHandler;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.ParserException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.CalendarException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Date;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.parameter.Value;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.property.Version;
import org.ocpsoft.prettytime.natty.org.apache.commons.lang.StringUtils;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory;
import org.ocpsoft.prettytime.natty.org.w3c.dom.DOMException;
import org.ocpsoft.prettytime.natty.org.w3c.dom.Document;
import org.ocpsoft.prettytime.natty.org.w3c.dom.Element;
import org.ocpsoft.prettytime.natty.org.w3c.dom.Node;
import org.ocpsoft.prettytime.natty.org.w3c.dom.NodeList;
import org.ocpsoft.prettytime.natty.org.xml.sax.InputSource;
import org.ocpsoft.prettytime.natty.org.xml.sax.SAXException;
import org.ocpsoft.prettytime.natty.org.xml.sax.SAXParseException;

public class HCalendarParser
extends org.ocpsoft.prettytime.natty.java.lang.Object
implements CalendarParser {
    private static final Log LOG = LogFactory.getLog(class$net$fortuna$ical4j$data$HCalendarParser == null ? (class$net$fortuna$ical4j$data$HCalendarParser = HCalendarParser.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.HCalendarParser")) : class$net$fortuna$ical4j$data$HCalendarParser);
    private static final DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final XPathExpression XPATH_METHOD;
    private static final XPathExpression XPATH_VEVENTS;
    private static final XPathExpression XPATH_DTSTART;
    private static final XPathExpression XPATH_DTEND;
    private static final XPathExpression XPATH_DURATION;
    private static final XPathExpression XPATH_SUMMARY;
    private static final XPathExpression XPATH_UID;
    private static final XPathExpression XPATH_DTSTAMP;
    private static final XPathExpression XPATH_CATEGORY;
    private static final XPathExpression XPATH_LOCATION;
    private static final XPathExpression XPATH_URL;
    private static final XPathExpression XPATH_DESCRIPTION;
    private static final XPathExpression XPATH_LAST_MODIFIED;
    private static final XPathExpression XPATH_STATUS;
    private static final XPathExpression XPATH_CLASS;
    private static final XPathExpression XPATH_ATTENDEE;
    private static final XPathExpression XPATH_CONTACT;
    private static final XPathExpression XPATH_ORGANIZER;
    private static final XPathExpression XPATH_SEQUENCE;
    private static final XPathExpression XPATH_ATTACH;
    private static final String HCAL_DATE_PATTERN = "org.ocpsoft.prettytime.natty.yyyy-MM-dd";
    private static final SimpleDateFormat HCAL_DATE_FORMAT;
    private static final String HCAL_DATE_TIME_PATTERN = "org.ocpsoft.prettytime.natty.yyyy-MM-dd'T'HH:mm:ssz";
    private static final SimpleDateFormat HCAL_DATE_TIME_FORMAT;
    static /* synthetic */ Class class$net$fortuna$ical4j$data$HCalendarParser;

    private static XPathExpression compileExpression(String expr) {
        try {
            return XPATH.compile(expr);
        }
        catch (XPathException e) {
            throw new CalendarException((Throwable)e);
        }
    }

    public void parse(InputStream in, ContentHandler handler) throws IOException, ParserException {
        this.parse(new InputSource(in), handler);
    }

    public void parse(Reader in, ContentHandler handler) throws IOException, ParserException {
        this.parse(new InputSource(in), handler);
    }

    private void parse(InputSource in, ContentHandler handler) throws IOException, ParserException {
        try {
            Document d = BUILDER_FACTORY.newDocumentBuilder().parse(in);
            this.buildCalendar(d, handler);
        }
        catch (ParserConfigurationException e) {
            throw new CalendarException((Throwable)e);
        }
        catch (SAXException e) {
            if (e instanceof SAXParseException) {
                SAXParseException pe = (SAXParseException)e;
                throw new ParserException((String)"org.ocpsoft.prettytime.natty.Could not parse XML", pe.getLineNumber(), (Throwable)e);
            }
            throw new ParserException(e.getMessage(), -1, (Throwable)e);
        }
    }

    private static NodeList findNodes(XPathExpression expr, org.ocpsoft.prettytime.natty.java.lang.Object context) throws ParserException {
        try {
            return (NodeList)expr.evaluate(context, XPathConstants.NODESET);
        }
        catch (XPathException e) {
            throw new ParserException((String)"org.ocpsoft.prettytime.natty.Unable to find nodes", -1, (Throwable)e);
        }
    }

    private static Node findNode(XPathExpression expr, org.ocpsoft.prettytime.natty.java.lang.Object context) throws ParserException {
        try {
            return (Node)expr.evaluate(context, XPathConstants.NODE);
        }
        catch (XPathException e) {
            throw new ParserException((String)"org.ocpsoft.prettytime.natty.Unable to find node", -1, (Throwable)e);
        }
    }

    private static List findElements(XPathExpression expr, org.ocpsoft.prettytime.natty.java.lang.Object context) throws ParserException {
        NodeList nodes = HCalendarParser.findNodes(expr, context);
        ArrayList elements = new ArrayList();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!(n instanceof Element)) continue;
            elements.add((org.ocpsoft.prettytime.natty.java.lang.Object)((Element)n));
        }
        return elements;
    }

    private static Element findElement(XPathExpression expr, org.ocpsoft.prettytime.natty.java.lang.Object context) throws ParserException {
        Node n = HCalendarParser.findNode(expr, context);
        if (n == null || !(n instanceof Element)) {
            return null;
        }
        return (Element)n;
    }

    private static String getTextContent(Element element) throws ParserException {
        try {
            String content = element.getFirstChild().getNodeValue();
            if (content != null) {
                return content.trim().replaceAll((String)"org.ocpsoft.prettytime.natty.\\s+", (String)"org.ocpsoft.prettytime.natty. ");
            }
            return content;
        }
        catch (DOMException e) {
            throw new ParserException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Unable to get text content for element ").append(element.getNodeName()).toString(), -1, (Throwable)e);
        }
    }

    private void buildCalendar(Document d, ContentHandler handler) throws ParserException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.Building calendar");
        }
        handler.startCalendar();
        handler.startProperty((String)"org.ocpsoft.prettytime.natty.VERSION");
        try {
            handler.propertyValue(Version.VERSION_2_0.getValue());
        }
        catch (Exception e) {
            // empty catch block
        }
        handler.endProperty((String)"org.ocpsoft.prettytime.natty.VERSION");
        Element method = HCalendarParser.findElement(XPATH_METHOD, (org.ocpsoft.prettytime.natty.java.lang.Object)d);
        if (method != null) {
            this.buildProperty(method, (String)"org.ocpsoft.prettytime.natty.METHOD", handler);
        }
        List vevents = HCalendarParser.findElements(XPATH_VEVENTS, (org.ocpsoft.prettytime.natty.java.lang.Object)d);
        Iterator i = vevents.iterator();
        while (i.hasNext()) {
            Element vevent = (Element)i.next();
            this.buildEvent(vevent, handler);
        }
        handler.endCalendar();
    }

    private void buildEvent(Element element, ContentHandler handler) throws ParserException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.Building event");
        }
        handler.startComponent((String)"org.ocpsoft.prettytime.natty.VEVENT");
        this.buildProperty(HCalendarParser.findElement(XPATH_DTSTART, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.DTSTART", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_DTEND, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.DTEND", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_DURATION, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.DURATION", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_SUMMARY, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.SUMMARY", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_UID, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.UID", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_DTSTAMP, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.DTSTAMP", handler);
        List categories = HCalendarParser.findElements(XPATH_CATEGORY, (org.ocpsoft.prettytime.natty.java.lang.Object)element);
        Iterator i = categories.iterator();
        while (i.hasNext()) {
            Element category = (Element)i.next();
            this.buildProperty(category, (String)"org.ocpsoft.prettytime.natty.CATEGORIES", handler);
        }
        this.buildProperty(HCalendarParser.findElement(XPATH_LOCATION, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.LOCATION", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_URL, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.URL", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_DESCRIPTION, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.DESCRIPTION", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_LAST_MODIFIED, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.LAST-MODIFIED", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_STATUS, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.STATUS", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_CLASS, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.CLASS", handler);
        List attendees = HCalendarParser.findElements(XPATH_ATTENDEE, (org.ocpsoft.prettytime.natty.java.lang.Object)element);
        Iterator i2 = attendees.iterator();
        while (i2.hasNext()) {
            Element attendee = (Element)i2.next();
            this.buildProperty(attendee, (String)"org.ocpsoft.prettytime.natty.ATTENDEE", handler);
        }
        this.buildProperty(HCalendarParser.findElement(XPATH_CONTACT, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.CONTACT", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_ORGANIZER, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.ORGANIZER", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_SEQUENCE, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.SEQUENCE", handler);
        this.buildProperty(HCalendarParser.findElement(XPATH_ATTACH, (org.ocpsoft.prettytime.natty.java.lang.Object)element), (String)"org.ocpsoft.prettytime.natty.ATTACH", handler);
        handler.endComponent((String)"org.ocpsoft.prettytime.natty.VEVENT");
    }

    private void buildProperty(Element element, String propName, ContentHandler handler) throws ParserException {
        String lang;
        if (element == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Building property ").append(propName).toString());
        }
        String className = HCalendarParser.className(propName);
        String elementName = element.getLocalName().toLowerCase();
        String value = null;
        if (elementName.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.abbr")) {
            value = element.getAttribute((String)"org.ocpsoft.prettytime.natty.title");
            if (StringUtils.isBlank(value)) {
                throw new ParserException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Abbr element '").append(className).append((String)"org.ocpsoft.prettytime.natty.' requires a non-empty title").toString(), -1);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Setting value '").append(value).append((String)"org.ocpsoft.prettytime.natty.' from title attribute").toString());
            }
        } else if (HCalendarParser.isHeaderElement(elementName)) {
            value = element.getAttribute((String)"org.ocpsoft.prettytime.natty.title");
            if (!StringUtils.isBlank(value)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Setting value '").append(value).append((String)"org.ocpsoft.prettytime.natty.' from title attribute").toString());
                }
            } else {
                value = HCalendarParser.getTextContent(element);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Setting value '").append(value).append((String)"org.ocpsoft.prettytime.natty.' from text content").toString());
                }
            }
        } else if (elementName.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.a") && HCalendarParser.isUrlProperty(propName)) {
            value = element.getAttribute((String)"org.ocpsoft.prettytime.natty.href");
            if (StringUtils.isBlank(value)) {
                throw new ParserException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.A element '").append(className).append((String)"org.ocpsoft.prettytime.natty.' requires a non-empty href").toString(), -1);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Setting value '").append(value).append((String)"org.ocpsoft.prettytime.natty.' from href attribute").toString());
            }
        } else if (elementName.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.img")) {
            if (HCalendarParser.isUrlProperty(propName)) {
                value = element.getAttribute((String)"org.ocpsoft.prettytime.natty.src");
                if (StringUtils.isBlank(value)) {
                    throw new ParserException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Img element '").append(className).append((String)"org.ocpsoft.prettytime.natty.' requires a non-empty src").toString(), -1);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Setting value '").append(value).append((String)"org.ocpsoft.prettytime.natty.' from src attribute").toString());
                }
            } else {
                value = element.getAttribute((String)"org.ocpsoft.prettytime.natty.alt");
                if (StringUtils.isBlank(value)) {
                    throw new ParserException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Img element '").append(className).append((String)"org.ocpsoft.prettytime.natty.' requires a non-empty alt").toString(), -1);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Setting value '").append(value).append((String)"org.ocpsoft.prettytime.natty.' from alt attribute").toString());
                }
            }
        } else {
            value = HCalendarParser.getTextContent(element);
            if (!StringUtils.isBlank(value) && LOG.isDebugEnabled()) {
                LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Setting value '").append(value).append((String)"org.ocpsoft.prettytime.natty.' from text content").toString());
            }
        }
        if (StringUtils.isBlank(value)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.Skipping property with empty value");
            }
            return;
        }
        handler.startProperty(propName);
        if (HCalendarParser.isDateProperty(propName)) {
            try {
                Date date = HCalendarParser.icalDate(value);
                value = date.toString();
                if (!(date instanceof DateTime)) {
                    try {
                        handler.parameter((String)"org.ocpsoft.prettytime.natty.VALUE", Value.DATE.getValue());
                    }
                    catch (Exception e) {}
                }
            }
            catch (ParseException e) {
                throw new ParserException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Malformed date value for element '").append(className).append((String)"org.ocpsoft.prettytime.natty.'").toString(), -1, (Throwable)e);
            }
        }
        if (HCalendarParser.isTextProperty(propName) && !StringUtils.isBlank(lang = element.getAttributeNS((String)"org/ocpsoft/prettytime/natty/http://www.w3.org/XML/1998/namespace", (String)"org.ocpsoft.prettytime.natty.lang"))) {
            try {
                handler.parameter((String)"org.ocpsoft.prettytime.natty.LANGUAGE", lang);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            handler.propertyValue(value);
        }
        catch (URISyntaxException e) {
            throw new ParserException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Malformed URI value for element '").append(className).append((String)"org.ocpsoft.prettytime.natty.'").toString(), -1, (Throwable)e);
        }
        catch (ParseException e) {
            throw new ParserException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Malformed value for element '").append(className).append((String)"org.ocpsoft.prettytime.natty.'").toString(), -1, (Throwable)e);
        }
        catch (IOException e) {
            throw new CalendarException((Throwable)e);
        }
        handler.endProperty(propName);
    }

    private static String className(String propName) {
        return propName.toLowerCase();
    }

    private static boolean isHeaderElement(String name) {
        return name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.h1") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.h2") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.h3") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.h4") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.h5") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.h6");
    }

    private static boolean isDateProperty(String name) {
        return name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.DTSTART") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.DTEND") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.DTSTAMP") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.LAST-MODIFIED");
    }

    private static boolean isUrlProperty(String name) {
        return name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.URL");
    }

    private static boolean isTextProperty(String name) {
        return name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.SUMMARY") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.LOCATION") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.CATEGORIES") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.DESCRIPTION") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.ATTENDEE") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.CONTACT") || name.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.ORGANIZER");
    }

    private static Date icalDate(String original) throws ParseException {
        if (original.indexOf(84) == -1) {
            try {
                if (original.indexOf(45) == -1) {
                    return new Date(original);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return new Date(HCAL_DATE_FORMAT.parse(original));
        }
        try {
            return new DateTime(original);
        }
        catch (Exception e) {
            String normalized = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.normalizing date-time ").append(original).toString());
            }
            if (original.charAt(original.length() - 1) == 'Z') {
                normalized = original.replaceAll((String)"org.ocpsoft.prettytime.natty.Z", (String)"org.ocpsoft.prettytime.natty.GMT-00:00");
            } else if (original.indexOf((String)"org.ocpsoft.prettytime.natty.GMT") == -1 && (original.charAt(original.length() - 6) == '+' || original.charAt(original.length() - 6) == '-')) {
                String tzId = new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.GMT").append(original.substring(original.length() - 6)).toString();
                normalized = new StringBuffer().append(original.substring(0, original.length() - 6)).append(tzId).toString();
            } else {
                normalized = original;
            }
            DateTime dt = new DateTime(HCAL_DATE_TIME_FORMAT.parse(normalized));
            dt.setUtc(true);
            return dt;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)x1);
        }
    }

    static {
        HCAL_DATE_FORMAT = new SimpleDateFormat((String)"org.ocpsoft.prettytime.natty.yyyy-MM-dd");
        HCAL_DATE_TIME_FORMAT = new SimpleDateFormat((String)"org.ocpsoft.prettytime.natty.yyyy-MM-dd'T'HH:mm:ssz");
        BUILDER_FACTORY.setNamespaceAware(true);
        BUILDER_FACTORY.setIgnoringComments(true);
        XPATH_METHOD = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty///*[contains(@class, 'method')]");
        XPATH_VEVENTS = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty///*[contains(@class, 'vevent')]");
        XPATH_DTSTART = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'dtstart')]");
        XPATH_DTEND = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'dtend')]");
        XPATH_DURATION = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'duration')]");
        XPATH_SUMMARY = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'summary')]");
        XPATH_UID = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'uid')]");
        XPATH_DTSTAMP = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'dtstamp')]");
        XPATH_CATEGORY = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'category')]");
        XPATH_LOCATION = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'location')]");
        XPATH_URL = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'url')]");
        XPATH_DESCRIPTION = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'description')]");
        XPATH_LAST_MODIFIED = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'last-modified')]");
        XPATH_STATUS = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'status')]");
        XPATH_CLASS = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'class')]");
        XPATH_ATTENDEE = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'attendee')]");
        XPATH_CONTACT = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'contact')]");
        XPATH_ORGANIZER = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'organizer')]");
        XPATH_SEQUENCE = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'sequence')]");
        XPATH_ATTACH = HCalendarParser.compileExpression((String)"org/ocpsoft/prettytime/natty/.//*[contains(@class, 'attach')]");
    }
}

