/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data;

import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.io.InputStreamReader;
import org.ocpsoft.prettytime.natty.java.io.Reader;
import org.ocpsoft.prettytime.natty.java.io.StreamTokenizer;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassCastException;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.net.URISyntaxException;
import org.ocpsoft.prettytime.natty.java.text.MessageFormat;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.CalendarParser;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.ContentHandler;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.ParserException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.UnfoldingReader;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.natty.org.apache.commons.logging.LogFactory;

public class CalendarParserImpl
extends org.ocpsoft.prettytime.natty.java.lang.Object
implements CalendarParser {
    private static final int WORD_CHAR_START = 32;
    private static final int WORD_CHAR_END = 255;
    private static final int WHITESPACE_CHAR_START = 0;
    private static final int WHITESPACE_CHAR_END = 20;
    private static final String UNEXPECTED_TOKEN_MESSAGE = "org.ocpsoft.prettytime.natty.Expected [{0}], read [{1}]";
    private Log log = LogFactory.getLog(class$net$fortuna$ical4j$data$CalendarParserImpl == null ? (class$net$fortuna$ical4j$data$CalendarParserImpl = CalendarParserImpl.class$((String)"org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.CalendarParserImpl")) : class$net$fortuna$ical4j$data$CalendarParserImpl);
    private final ComponentListParser componentListParser = new ComponentListParser();
    private final ComponentParser componentParser = new ComponentParser();
    private final PropertyListParser propertyListParser = new PropertyListParser();
    private final PropertyParser propertyParser = new PropertyParser();
    private final ParameterListParser paramListParser = new ParameterListParser();
    private final ParameterParser paramParser = new ParameterParser();
    static /* synthetic */ Class class$net$fortuna$ical4j$data$CalendarParserImpl;

    public final void parse(InputStream in, ContentHandler handler) throws IOException, ParserException {
        this.parse((Reader)new InputStreamReader(in), handler);
    }

    public final void parse(Reader in, ContentHandler handler) throws IOException, ParserException {
        StreamTokenizer tokeniser = new StreamTokenizer(in);
        try {
            tokeniser.resetSyntax();
            tokeniser.wordChars(32, 255);
            tokeniser.whitespaceChars(0, 20);
            tokeniser.ordinaryChar(58);
            tokeniser.ordinaryChar(59);
            tokeniser.ordinaryChar(61);
            tokeniser.ordinaryChar(9);
            tokeniser.eolIsSignificant(true);
            tokeniser.whitespaceChars(0, 0);
            tokeniser.quoteChar(34);
            this.assertToken(tokeniser, in, (String)"org.ocpsoft.prettytime.natty.BEGIN");
            this.assertToken(tokeniser, in, 58);
            this.assertToken(tokeniser, in, (String)"org.ocpsoft.prettytime.natty.VCALENDAR", true);
            this.assertToken(tokeniser, in, 10);
            handler.startCalendar();
            this.propertyListParser.parse(tokeniser, in, handler);
            this.componentListParser.parse(tokeniser, in, handler);
            this.assertToken(tokeniser, in, 58);
            this.assertToken(tokeniser, in, (String)"org.ocpsoft.prettytime.natty.VCALENDAR", true);
            handler.endCalendar();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)((Object)e);
            }
            if (e instanceof ParserException) {
                throw (ParserException)e;
            }
            throw new ParserException(e.getMessage(), this.getLineNumber(tokeniser, in), (Throwable)e);
        }
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, int token) throws IOException, ParserException {
        if (tokeniser.nextToken() != token) {
            throw new ParserException(MessageFormat.format((String)"org.ocpsoft.prettytime.natty.Expected [{0}], read [{1}]", (org.ocpsoft.prettytime.natty.java.lang.Object[])new org.ocpsoft.prettytime.natty.java.lang.Object[]{new Integer(token), new Integer(tokeniser.ttype)}), this.getLineNumber(tokeniser, in));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[").append(token).append((String)"org.ocpsoft.prettytime.natty.]").toString());
        }
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, String token) throws IOException, ParserException {
        this.assertToken(tokeniser, in, token, false);
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, String token, boolean ignoreCase) throws IOException, ParserException {
        this.assertToken(tokeniser, in, -3);
        if (ignoreCase ? !token.equalsIgnoreCase(tokeniser.sval) : !token.equals((org.ocpsoft.prettytime.natty.java.lang.Object)tokeniser.sval)) {
            throw new ParserException(MessageFormat.format((String)"org.ocpsoft.prettytime.natty.Expected [{0}], read [{1}]", (org.ocpsoft.prettytime.natty.java.lang.Object[])new org.ocpsoft.prettytime.natty.java.lang.Object[]{token, tokeniser.sval}), this.getLineNumber(tokeniser, in));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[").append(token).append((String)"org.ocpsoft.prettytime.natty.]").toString());
        }
    }

    private void absorbWhitespace(StreamTokenizer tokeniser) throws IOException {
        while (tokeniser.nextToken() == 10) {
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.Absorbing extra whitespace..");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.Aborting: absorbing extra whitespace complete");
        }
    }

    private int getLineNumber(StreamTokenizer tokeniser, Reader in) {
        int line = tokeniser.lineno();
        if (tokeniser.ttype == 10) {
            --line;
        }
        if (in instanceof UnfoldingReader) {
            int unfolded = ((UnfoldingReader)in).getLinesUnfolded();
            line += unfolded;
        }
        return line;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)x1);
        }
    }

    private class ComponentParser
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        private ComponentParser() {
        }

        private void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
            CalendarParserImpl.this.assertToken(tokeniser, in, 58);
            CalendarParserImpl.this.assertToken(tokeniser, in, -3);
            String name = tokeniser.sval;
            handler.startComponent(name);
            CalendarParserImpl.this.assertToken(tokeniser, in, 10);
            CalendarParserImpl.this.propertyListParser.parse(tokeniser, in, handler);
            CalendarParserImpl.this.assertToken(tokeniser, in, 58);
            CalendarParserImpl.this.assertToken(tokeniser, in, name);
            CalendarParserImpl.this.assertToken(tokeniser, in, 10);
            handler.endComponent(name);
        }
    }

    private class ComponentListParser
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        private ComponentListParser() {
        }

        private void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
            while ("org.ocpsoft.prettytime.natty.BEGIN".equals((org.ocpsoft.prettytime.natty.java.lang.Object)tokeniser.sval)) {
                CalendarParserImpl.this.componentParser.parse(tokeniser, in, handler);
                CalendarParserImpl.this.absorbWhitespace(tokeniser);
            }
        }
    }

    private class ParameterParser
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        private ParameterParser() {
        }

        private void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException {
            CalendarParserImpl.this.assertToken(tokeniser, in, -3);
            String paramName = tokeniser.sval;
            if (CalendarParserImpl.this.log.isDebugEnabled()) {
                CalendarParserImpl.this.log.debug((org.ocpsoft.prettytime.natty.java.lang.Object)new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.Parameter [").append(paramName).append((String)"org.ocpsoft.prettytime.natty.]").toString());
            }
            CalendarParserImpl.this.assertToken(tokeniser, in, 61);
            StringBuffer paramValue = new StringBuffer();
            if (tokeniser.nextToken() == 34) {
                paramValue.append('\"');
                paramValue.append(tokeniser.sval);
                paramValue.append('\"');
            } else if (tokeniser.sval != null) {
                paramValue.append(tokeniser.sval);
                int nextToken = tokeniser.nextToken();
                while (nextToken != 59 && nextToken != 58 && nextToken != 44) {
                    if (tokeniser.ttype == -3) {
                        paramValue.append(tokeniser.sval);
                    } else {
                        paramValue.append((char)tokeniser.ttype);
                    }
                    nextToken = tokeniser.nextToken();
                }
                tokeniser.pushBack();
            } else if (tokeniser.sval == null) {
                tokeniser.pushBack();
            }
            try {
                handler.parameter(paramName, paramValue.toString());
            }
            catch (ClassCastException cce) {
                throw new ParserException((String)"org.ocpsoft.prettytime.natty.Error parsing parameter", CalendarParserImpl.this.getLineNumber(tokeniser, in), (Throwable)cce);
            }
        }
    }

    private class ParameterListParser
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        private ParameterListParser() {
        }

        public void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException {
            while (tokeniser.nextToken() == 59) {
                CalendarParserImpl.this.paramParser.parse(tokeniser, in, handler);
            }
        }
    }

    private class PropertyParser
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        private static final String PARSE_DEBUG_MESSAGE = "org.ocpsoft.prettytime.natty.Property [{0}]";
        private static final String PARSE_EXCEPTION_MESSAGE = "org.ocpsoft.prettytime.natty.Property [{0}]";

        private PropertyParser() {
        }

        private void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException, ParseException {
            String name = tokeniser.sval;
            if (CalendarParserImpl.this.log.isDebugEnabled()) {
                CalendarParserImpl.this.log.debug((org.ocpsoft.prettytime.natty.java.lang.Object)MessageFormat.format((String)"org.ocpsoft.prettytime.natty.Property [{0}]", (org.ocpsoft.prettytime.natty.java.lang.Object[])new org.ocpsoft.prettytime.natty.java.lang.Object[]{name}));
            }
            handler.startProperty(name);
            CalendarParserImpl.this.paramListParser.parse(tokeniser, in, handler);
            StringBuffer value = new StringBuffer();
            tokeniser.ordinaryChar(34);
            int nextToken = tokeniser.nextToken();
            while (nextToken != 10 && nextToken != -1) {
                if (tokeniser.ttype == -3) {
                    value.append(tokeniser.sval);
                } else {
                    value.append((char)tokeniser.ttype);
                }
                nextToken = tokeniser.nextToken();
            }
            tokeniser.quoteChar(34);
            if (nextToken == -1) {
                throw new ParserException((String)"org.ocpsoft.prettytime.natty.Unexpected end of file", CalendarParserImpl.this.getLineNumber(tokeniser, in));
            }
            try {
                handler.propertyValue(value.toString());
            }
            catch (ParseException e) {
                ParseException eNew = new ParseException(new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[").append(name).append((String)"org.ocpsoft.prettytime.natty.] ").append(e.getMessage()).toString(), e.getErrorOffset());
                eNew.initCause((Throwable)e);
                throw eNew;
            }
            handler.endProperty(name);
        }
    }

    private class PropertyListParser
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        private PropertyListParser() {
        }

        public void parse(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
            CalendarParserImpl.this.assertToken(tokeniser, in, -3);
            while (!"org.ocpsoft.prettytime.natty.END".equals((org.ocpsoft.prettytime.natty.java.lang.Object)tokeniser.sval)) {
                if ("org.ocpsoft.prettytime.natty.BEGIN".equals((org.ocpsoft.prettytime.natty.java.lang.Object)tokeniser.sval)) {
                    CalendarParserImpl.this.componentParser.parse(tokeniser, in, handler);
                } else {
                    CalendarParserImpl.this.propertyParser.parse(tokeniser, in, handler);
                }
                CalendarParserImpl.this.absorbWhitespace(tokeniser);
            }
        }
    }
}

