/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.locks;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.locks.CondVar;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.locks.ReadWriteLock;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.ObjectInputStream;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalMonitorStateException;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.InterruptedException;
import org.ocpsoft.prettytime.natty.java.lang.NullPointerException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Thread;
import org.ocpsoft.prettytime.natty.java.lang.UnsupportedOperationException;
import org.ocpsoft.prettytime.natty.java.util.HashMap;

public class ReentrantReadWriteLock
extends org.ocpsoft.prettytime.natty.java.lang.Object
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -3463448656717690166L;
    final ReadLock readerLock_ = new ReadLock(this);
    final WriteLock writerLock_ = new WriteLock(this);
    final Sync sync = new NonfairSync();

    public Lock writeLock() {
        return this.writerLock_;
    }

    public Lock readLock() {
        return this.readerLock_;
    }

    public final boolean isFair() {
        return false;
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public int getReadLockCount() {
        return this.sync.getReadLockCount();
    }

    public boolean isWriteLocked() {
        return this.sync.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.sync.isWriteLockedByCurrentThread();
    }

    public int getWriteHoldCount() {
        return this.sync.getWriteHoldCount();
    }

    public int getReadHoldCount() {
        return this.sync.getReadHoldCount();
    }

    public final boolean hasQueuedThreads() {
        return this.sync.hasQueuedThreads();
    }

    public final int getQueueLength() {
        return this.sync.getQueueLength();
    }

    public String toString() {
        return new StringBuffer().append(super.toString()).append((String)"org.ocpsoft.prettytime.natty.[Write locks = ").append(this.getWriteHoldCount()).append((String)"org.ocpsoft.prettytime.natty., Read locks = ").append(this.getReadLockCount()).append((String)"org.ocpsoft.prettytime.natty.]").toString();
    }

    public static class WriteLock
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Lock,
    CondVar.ExclusiveLock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        final ReentrantReadWriteLock lock;

        protected WriteLock(ReentrantReadWriteLock lock) {
            if (lock == null) {
                throw new NullPointerException();
            }
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            WriteLock writeLock = this;
            synchronized (writeLock) {
                if (this.lock.sync.startWriteFromNewWriter()) {
                    return;
                }
                boolean wasInterrupted = Thread.interrupted();
                try {
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            wasInterrupted = true;
                        }
                    } while (!this.lock.sync.startWriteFromWaitingWriter());
                    return;
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            WriteLock writeLock = this;
            synchronized (writeLock) {
                if (!this.lock.sync.startWriteFromNewWriter()) {
                    try {
                        do {
                            this.wait();
                        } while (!this.lock.sync.startWriteFromWaitingWriter());
                        return;
                    }
                    catch (InterruptedException ex) {
                        this.lock.sync.cancelledWaitingWriter();
                        this.notify();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                this.lock.readerLock_.signalWaiters();
                throw ie;
            }
        }

        public boolean tryLock() {
            return this.lock.sync.startWrite();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            long nanos = unit.toNanos(timeout);
            WriteLock writeLock = this;
            synchronized (writeLock) {
                block10: {
                    if (nanos <= 0L) {
                        return this.lock.sync.startWrite();
                    }
                    if (this.lock.sync.startWriteFromNewWriter()) {
                        return true;
                    }
                    long deadline = Utils.nanoTime() + nanos;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        }
                        catch (InterruptedException ex) {
                            this.lock.sync.cancelledWaitingWriter();
                            this.notify();
                            ie = ex;
                            break block10;
                        }
                        if (!this.lock.sync.startWriteFromWaitingWriter()) continue;
                        return true;
                    } while ((nanos = deadline - Utils.nanoTime()) > 0L);
                    this.lock.sync.cancelledWaitingWriter();
                    this.notify();
                }
            }
            this.lock.readerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }

        public void unlock() {
            switch (this.lock.sync.endWrite()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.lock.readerLock_.signalWaiters();
                    return;
                }
                case 2: {
                    this.lock.writerLock_.signalWaiters();
                    return;
                }
            }
        }

        public Condition newCondition() {
            return new CondVar(this);
        }

        synchronized void signalWaiters() {
            this.notify();
        }

        public String toString() {
            Thread o = this.lock.getOwner();
            return new StringBuffer().append(super.toString()).append((String)(o == null ? "org.ocpsoft.prettytime.natty.[Unlocked]" : new StringBuffer().append((String)"org.ocpsoft.prettytime.natty.[Locked by thread ").append(o.getName()).append((String)"org.ocpsoft.prettytime.natty.]").toString())).toString();
        }

        public boolean isHeldByCurrentThread() {
            return this.lock.sync.isWriteLockedByCurrentThread();
        }

        public int getHoldCount() {
            return this.lock.sync.getWriteHoldCount();
        }
    }

    public static class ReadLock
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        final ReentrantReadWriteLock lock;

        protected ReadLock(ReentrantReadWriteLock lock) {
            if (lock == null) {
                throw new NullPointerException();
            }
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            ReadLock readLock = this;
            synchronized (readLock) {
                if (this.lock.sync.startReadFromNewReader()) {
                    return;
                }
                boolean wasInterrupted = Thread.interrupted();
                try {
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            wasInterrupted = true;
                        }
                    } while (!this.lock.sync.startReadFromWaitingReader());
                    return;
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReadLock readLock = this;
            synchronized (readLock) {
                if (!this.lock.sync.startReadFromNewReader()) {
                    try {
                        do {
                            this.wait();
                        } while (!this.lock.sync.startReadFromWaitingReader());
                        return;
                    }
                    catch (InterruptedException ex) {
                        this.lock.sync.cancelledWaitingReader();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                this.lock.writerLock_.signalWaiters();
                throw ie;
            }
        }

        public boolean tryLock() {
            return this.lock.sync.startRead();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            long nanos = unit.toNanos(timeout);
            ReadLock readLock = this;
            synchronized (readLock) {
                block10: {
                    if (nanos <= 0L) {
                        return this.lock.sync.startRead();
                    }
                    if (this.lock.sync.startReadFromNewReader()) {
                        return true;
                    }
                    long deadline = Utils.nanoTime() + nanos;
                    do {
                        try {
                            TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        }
                        catch (InterruptedException ex) {
                            this.lock.sync.cancelledWaitingReader();
                            ie = ex;
                            break block10;
                        }
                        if (!this.lock.sync.startReadFromWaitingReader()) continue;
                        return true;
                    } while ((nanos = deadline - Utils.nanoTime()) > 0L);
                    this.lock.sync.cancelledWaitingReader();
                }
            }
            this.lock.writerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }

        public void unlock() {
            switch (this.lock.sync.endRead()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.lock.readerLock_.signalWaiters();
                    return;
                }
                case 2: {
                    this.lock.writerLock_.signalWaiters();
                    return;
                }
            }
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        synchronized void signalWaiters() {
            this.notifyAll();
        }

        public String toString() {
            int r = this.lock.getReadLockCount();
            return new StringBuffer().append(super.toString()).append((String)"org.ocpsoft.prettytime.natty.[Read locks = ").append(r).append((String)"org.ocpsoft.prettytime.natty.]").toString();
        }
    }

    private static class NonfairSync
    extends Sync {
        NonfairSync() {
        }
    }

    private static abstract class Sync
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Serializable {
        private static final int NONE = 0;
        private static final int READER = 1;
        private static final int WRITER = 2;
        transient int activeReaders_ = 0;
        transient Thread activeWriter_ = null;
        transient int waitingReaders_ = 0;
        transient int waitingWriters_ = 0;
        transient int writeHolds_ = 0;
        transient HashMap readers_ = new HashMap();
        static final Integer IONE = new Integer(1);

        Sync() {
        }

        synchronized boolean startReadFromNewReader() {
            boolean pass = this.startRead();
            if (!pass) {
                ++this.waitingReaders_;
            }
            return pass;
        }

        synchronized boolean startWriteFromNewWriter() {
            boolean pass = this.startWrite();
            if (!pass) {
                ++this.waitingWriters_;
            }
            return pass;
        }

        synchronized boolean startReadFromWaitingReader() {
            boolean pass = this.startRead();
            if (pass) {
                --this.waitingReaders_;
            }
            return pass;
        }

        synchronized boolean startWriteFromWaitingWriter() {
            boolean pass = this.startWrite();
            if (pass) {
                --this.waitingWriters_;
            }
            return pass;
        }

        synchronized void cancelledWaitingReader() {
            --this.waitingReaders_;
        }

        synchronized void cancelledWaitingWriter() {
            --this.waitingWriters_;
        }

        boolean allowReader() {
            return this.activeWriter_ == null && this.waitingWriters_ == 0 || this.activeWriter_ == Thread.currentThread();
        }

        synchronized boolean startRead() {
            Thread t = Thread.currentThread();
            org.ocpsoft.prettytime.natty.java.lang.Object c = this.readers_.get((org.ocpsoft.prettytime.natty.java.lang.Object)t);
            if (c != null) {
                this.readers_.put((org.ocpsoft.prettytime.natty.java.lang.Object)t, (org.ocpsoft.prettytime.natty.java.lang.Object)new Integer(((Integer)c).intValue() + 1));
                ++this.activeReaders_;
                return true;
            }
            if (this.allowReader()) {
                this.readers_.put((org.ocpsoft.prettytime.natty.java.lang.Object)t, (org.ocpsoft.prettytime.natty.java.lang.Object)IONE);
                ++this.activeReaders_;
                return true;
            }
            return false;
        }

        synchronized boolean startWrite() {
            if (this.activeWriter_ == Thread.currentThread()) {
                ++this.writeHolds_;
                return true;
            }
            if (this.writeHolds_ == 0) {
                if (this.activeReaders_ == 0 || this.readers_.size() == 1 && this.readers_.get((org.ocpsoft.prettytime.natty.java.lang.Object)Thread.currentThread()) != null) {
                    this.activeWriter_ = Thread.currentThread();
                    this.writeHolds_ = 1;
                    return true;
                }
                return false;
            }
            return false;
        }

        synchronized int endRead() {
            Thread t = Thread.currentThread();
            org.ocpsoft.prettytime.natty.java.lang.Object c = this.readers_.get((org.ocpsoft.prettytime.natty.java.lang.Object)t);
            if (c == null) {
                throw new IllegalMonitorStateException();
            }
            --this.activeReaders_;
            if (c != IONE) {
                int h = ((Integer)c).intValue() - 1;
                Integer ih = h == 1 ? IONE : new Integer(h);
                this.readers_.put((org.ocpsoft.prettytime.natty.java.lang.Object)t, (org.ocpsoft.prettytime.natty.java.lang.Object)ih);
                return 0;
            }
            this.readers_.remove((org.ocpsoft.prettytime.natty.java.lang.Object)t);
            if (this.writeHolds_ > 0) {
                return 0;
            }
            if (this.activeReaders_ == 0 && this.waitingWriters_ > 0) {
                return 2;
            }
            return 0;
        }

        synchronized int endWrite() {
            if (this.activeWriter_ != Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            --this.writeHolds_;
            if (this.writeHolds_ > 0) {
                return 0;
            }
            this.activeWriter_ = null;
            if (this.waitingReaders_ > 0 && this.allowReader()) {
                return 1;
            }
            if (this.waitingWriters_ > 0) {
                return 2;
            }
            return 0;
        }

        synchronized Thread getOwner() {
            return this.activeWriter_;
        }

        synchronized int getReadLockCount() {
            return this.activeReaders_;
        }

        synchronized boolean isWriteLocked() {
            return this.activeWriter_ != null;
        }

        synchronized boolean isWriteLockedByCurrentThread() {
            return this.activeWriter_ == Thread.currentThread();
        }

        synchronized int getWriteHoldCount() {
            return this.isWriteLockedByCurrentThread() ? this.writeHolds_ : 0;
        }

        synchronized int getReadHoldCount() {
            if (this.activeReaders_ == 0) {
                return 0;
            }
            Thread t = Thread.currentThread();
            Integer i = (Integer)this.readers_.get((org.ocpsoft.prettytime.natty.java.lang.Object)t);
            return i == null ? 0 : i.intValue();
        }

        final synchronized boolean hasQueuedThreads() {
            return this.waitingWriters_ > 0 || this.waitingReaders_ > 0;
        }

        final synchronized int getQueueLength() {
            return this.waitingWriters_ + this.waitingReaders_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Sync sync = this;
            synchronized (sync) {
                this.readers_ = new HashMap();
            }
        }
    }
}

