/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.helpers;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.Arrays;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.helpers.NanoTimer;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.InterruptedException;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.OutOfMemoryError;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Array;
import org.ocpsoft.prettytime.natty.java.security.AccessController;
import org.ocpsoft.prettytime.natty.java.security.PrivilegedAction;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.sun.misc.Perf;

public final class Utils
extends org.ocpsoft.prettytime.natty.java.lang.Object {
    private static final NanoTimer nanoTimer;
    private static final String providerProp = "org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider";
    static /* synthetic */ Class array$Ljava$lang$Object;

    private Utils() {
    }

    public static long nanoTime() {
        return nanoTimer.nanoTime();
    }

    public static long awaitNanos(Condition cond, long nanosTimeout) throws InterruptedException {
        if (nanosTimeout <= 0L) {
            return nanosTimeout;
        }
        long now = Utils.nanoTime();
        cond.await(nanosTimeout, TimeUnit.NANOSECONDS);
        return nanosTimeout - (Utils.nanoTime() - now);
    }

    private static long gcd(long a, long b) {
        while (b > 0L) {
            long r = a % b;
            a = b;
            b = r;
        }
        return a;
    }

    public static org.ocpsoft.prettytime.natty.java.lang.Object[] collectionToArray(Collection c) {
        int len = c.size();
        org.ocpsoft.prettytime.natty.java.lang.Object[] arr = new org.ocpsoft.prettytime.natty.java.lang.Object[len];
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                return Arrays.copyOf(arr, idx, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = Utils.class$((String)"[Lorg.ocpsoft.prettytime.natty.java.lang.Object;")) : array$Ljava$lang$Object);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError((String)"org.ocpsoft.prettytime.natty.required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, array$Ljava$lang$Object == null ? Utils.class$((String)"[Lorg.ocpsoft.prettytime.natty.java.lang.Object;") : array$Ljava$lang$Object);
            len = newcap;
        }
    }

    public static org.ocpsoft.prettytime.natty.java.lang.Object[] collectionToArray(Collection c, org.ocpsoft.prettytime.natty.java.lang.Object[] a) {
        Class aType = a.getClass();
        int len = c.size();
        org.ocpsoft.prettytime.natty.java.lang.Object[] arr = a.length >= len ? a : (org.ocpsoft.prettytime.natty.java.lang.Object[])Array.newInstance((Class)aType.getComponentType(), (int)len);
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
                continue;
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                if (arr == a) {
                    a[idx] = null;
                    return a;
                }
                return Arrays.copyOf(arr, idx, aType);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError((String)"org.ocpsoft.prettytime.natty.required array size too large");
                }
            }
            arr = Arrays.copyOf(arr, newcap, aType);
            len = newcap;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)((Object)x1));
        }
    }

    static {
        NanoTimer timer = null;
        try {
            String nanoTimerClassName = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                    return System.getProperty((String)"org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider");
                }
            });
            if (nanoTimerClassName != null) {
                Class cls = Class.forName((String)nanoTimerClassName);
                timer = (NanoTimer)cls.newInstance();
            }
        }
        catch (Exception e) {
            System.err.println((String)"org.ocpsoft.prettytime.natty.WARNING: unable to load the system-property-defined nanotime provider; switching to the default");
            e.printStackTrace();
        }
        if (timer == null) {
            try {
                timer = new SunPerfProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (timer == null) {
            timer = new MillisProvider();
        }
        nanoTimer = timer;
    }

    private static final class MillisProvider
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements NanoTimer {
        MillisProvider() {
        }

        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements NanoTimer {
        final Perf perf = (Perf)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(this){
            private final /* synthetic */ SunPerfProvider this$0;
            {
                this.this$0 = this$0;
            }

            public org.ocpsoft.prettytime.natty.java.lang.Object run() {
                return Perf.getPerf();
            }
        });
        final long multiplier;
        final long divisor;

        SunPerfProvider() {
            long numerator = 1000000000L;
            long denominator = this.perf.highResFrequency();
            long gcd = Utils.gcd(numerator, denominator);
            this.multiplier = numerator / gcd;
            this.divisor = denominator / gcd;
        }

        public long nanoTime() {
            long ctr = this.perf.highResCounter();
            return ctr / this.divisor * this.multiplier + ctr % this.divisor * this.multiplier / this.divisor;
        }
    }
}

