/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.atomic;

import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.NullPointerException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.System;

public class AtomicLongArray
extends Object
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private final long[] array;

    public AtomicLongArray(int length) {
        this.array = new long[length];
    }

    public AtomicLongArray(long[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = array.length;
        this.array = new long[length];
        System.arraycopy((Object)array, (int)0, (Object)this.array, (int)0, (int)array.length);
    }

    public final int length() {
        return this.array.length;
    }

    public final synchronized long get(int i) {
        return this.array[i];
    }

    public final synchronized void set(int i, long newValue) {
        this.array[i] = newValue;
    }

    public final synchronized void lazySet(int i, long newValue) {
        this.array[i] = newValue;
    }

    public final synchronized long getAndSet(int i, long newValue) {
        long old = this.array[i];
        this.array[i] = newValue;
        return old;
    }

    public final synchronized boolean compareAndSet(int i, long expect, long update) {
        if (this.array[i] == expect) {
            this.array[i] = update;
            return true;
        }
        return false;
    }

    public final synchronized boolean weakCompareAndSet(int i, long expect, long update) {
        if (this.array[i] == expect) {
            this.array[i] = update;
            return true;
        }
        return false;
    }

    public final synchronized long getAndIncrement(int i) {
        int n = i;
        long l = this.array[n];
        this.array[n] = l + 1L;
        return l;
    }

    public final synchronized long getAndDecrement(int i) {
        int n = i;
        long l = this.array[n];
        this.array[n] = l - 1L;
        return l;
    }

    public final synchronized long getAndAdd(int i, long delta) {
        long old = this.array[i];
        int n = i;
        this.array[n] = this.array[n] + delta;
        return old;
    }

    public final synchronized long incrementAndGet(int i) {
        int n = i;
        long l = this.array[n] + 1L;
        this.array[n] = l;
        return l;
    }

    public final synchronized long decrementAndGet(int i) {
        int n = i;
        long l = this.array[n] - 1L;
        this.array[n] = l;
        return l;
    }

    public synchronized long addAndGet(int i, long delta) {
        int n = i;
        long l = this.array[n] + delta;
        this.array[n] = l;
        return l;
    }

    public synchronized String toString() {
        if (this.array.length == 0) {
            return "org.ocpsoft.prettytime.natty.[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(this.array[0]);
        for (int i = 1; i < this.array.length; ++i) {
            buf.append((String)"org.ocpsoft.prettytime.natty., ");
            buf.append(this.array[i]);
        }
        buf.append((String)"org.ocpsoft.prettytime.natty.]");
        return buf.toString();
    }
}

