/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.AbstractQueue;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.ObjectInputStream;
import org.ocpsoft.prettytime.natty.java.io.ObjectOutputStream;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.AssertionError;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalStateException;
import org.ocpsoft.prettytime.natty.java.lang.InterruptedException;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.NullPointerException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Array;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.NoSuchElementException;

public class LinkedBlockingQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private volatile int count = 0;
    private transient Node head;
    private transient Node last;
    private final org.ocpsoft.prettytime.natty.java.lang.Object takeLock = new SerializableLock();
    private final org.ocpsoft.prettytime.natty.java.lang.Object putLock = new SerializableLock();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$LinkedBlockingQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.takeLock;
        synchronized (object) {
            this.takeLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            this.putLock.notify();
        }
    }

    private void insert(org.ocpsoft.prettytime.natty.java.lang.Object x) {
        this.last = this.last.next = new Node(x);
    }

    private org.ocpsoft.prettytime.natty.java.lang.Object extract() {
        Node first;
        this.head = first = this.head.next;
        org.ocpsoft.prettytime.natty.java.lang.Object x = first.item;
        first.item = null;
        return x;
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.last = this.head = new Node(null);
    }

    public LinkedBlockingQueue(Collection c) {
        this(Integer.MAX_VALUE);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            org.ocpsoft.prettytime.natty.java.lang.Object e = itr.next();
            this.add(e);
        }
    }

    public int size() {
        return this.count;
    }

    public int remainingCapacity() {
        return this.capacity - this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(org.ocpsoft.prettytime.natty.java.lang.Object e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int c = -1;
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            try {
                while (this.count == this.capacity) {
                    this.putLock.wait();
                }
            }
            catch (InterruptedException ie) {
                this.putLock.notify();
                throw ie;
            }
            this.insert(e);
            LinkedBlockingQueue linkedBlockingQueue = this;
            synchronized (linkedBlockingQueue) {
                c = this.count++;
            }
            if (c + 1 < this.capacity) {
                this.putLock.notify();
            }
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(org.ocpsoft.prettytime.natty.java.lang.Object e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        int c = -1;
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.count < this.capacity) {
                    this.insert(e);
                    LinkedBlockingQueue linkedBlockingQueue = this;
                    synchronized (linkedBlockingQueue) {
                        c = this.count++;
                    }
                    if (c + 1 >= this.capacity) break;
                    this.putLock.notify();
                    break;
                }
                if (nanos <= 0L) {
                    return false;
                }
                try {
                    TimeUnit.NANOSECONDS.timedWait(this.putLock, nanos);
                    nanos = deadline - Utils.nanoTime();
                }
                catch (InterruptedException ie) {
                    this.putLock.notify();
                    throw ie;
                }
            }
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.count == this.capacity) {
            return false;
        }
        int c = -1;
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            if (this.count < this.capacity) {
                this.insert(e);
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    c = this.count++;
                }
                if (c + 1 < this.capacity) {
                    this.putLock.notify();
                }
            }
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return c >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object take() throws InterruptedException {
        org.ocpsoft.prettytime.natty.java.lang.Object x;
        int c = -1;
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.takeLock;
        synchronized (object) {
            try {
                while (this.count == 0) {
                    this.takeLock.wait();
                }
            }
            catch (InterruptedException ie) {
                this.takeLock.notify();
                throw ie;
            }
            x = this.extract();
            LinkedBlockingQueue linkedBlockingQueue = this;
            synchronized (linkedBlockingQueue) {
                c = this.count--;
            }
            if (c > 1) {
                this.takeLock.notify();
            }
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        org.ocpsoft.prettytime.natty.java.lang.Object x = null;
        int c = -1;
        long nanos = unit.toNanos(timeout);
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.takeLock;
        synchronized (object) {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.count > 0) {
                    x = this.extract();
                    LinkedBlockingQueue linkedBlockingQueue = this;
                    synchronized (linkedBlockingQueue) {
                        c = this.count--;
                    }
                    if (c <= 1) break;
                    this.takeLock.notify();
                    break;
                }
                if (nanos <= 0L) {
                    return null;
                }
                try {
                    TimeUnit.NANOSECONDS.timedWait(this.takeLock, nanos);
                    nanos = deadline - Utils.nanoTime();
                }
                catch (InterruptedException ie) {
                    this.takeLock.notify();
                    throw ie;
                }
            }
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object poll() {
        if (this.count == 0) {
            return null;
        }
        org.ocpsoft.prettytime.natty.java.lang.Object x = null;
        int c = -1;
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.takeLock;
        synchronized (object) {
            if (this.count > 0) {
                x = this.extract();
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    c = this.count--;
                }
                if (c > 1) {
                    this.takeLock.notify();
                }
            }
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object peek() {
        if (this.count == 0) {
            return null;
        }
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.takeLock;
        synchronized (object) {
            Node first = this.head.next;
            if (first == null) {
                return null;
            }
            return first.item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        if (o == null) {
            return false;
        }
        boolean removed = false;
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            org.ocpsoft.prettytime.natty.java.lang.Object object2 = this.takeLock;
            synchronized (object2) {
                Node trail = this.head;
                Node p = this.head.next;
                while (p != null) {
                    if (o.equals(p.item)) {
                        removed = true;
                        break;
                    }
                    trail = p;
                    p = p.next;
                }
                if (removed) {
                    p.item = null;
                    trail.next = p.next;
                    if (this.last == p) {
                        this.last = trail;
                    }
                    LinkedBlockingQueue linkedBlockingQueue = this;
                    synchronized (linkedBlockingQueue) {
                        if (this.count-- == this.capacity) {
                            this.putLock.notifyAll();
                        }
                    }
                }
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray() {
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            org.ocpsoft.prettytime.natty.java.lang.Object object2 = this.takeLock;
            synchronized (object2) {
                int size = this.count;
                org.ocpsoft.prettytime.natty.java.lang.Object[] a = new org.ocpsoft.prettytime.natty.java.lang.Object[size];
                int k = 0;
                Node p = this.head.next;
                while (p != null) {
                    a[k++] = p.item;
                    p = p.next;
                }
                return a;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray(org.ocpsoft.prettytime.natty.java.lang.Object[] a) {
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            org.ocpsoft.prettytime.natty.java.lang.Object object2 = this.takeLock;
            synchronized (object2) {
                int size = this.count;
                if (a.length < size) {
                    a = (org.ocpsoft.prettytime.natty.java.lang.Object[])Array.newInstance((Class)a.getClass().getComponentType(), (int)size);
                }
                int k = 0;
                Node p = this.head.next;
                while (p != null) {
                    a[k++] = p.item;
                    p = p.next;
                }
                if (a.length > k) {
                    a[k] = null;
                }
                return a;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            org.ocpsoft.prettytime.natty.java.lang.Object object2 = this.takeLock;
            synchronized (object2) {
                return super.toString();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            org.ocpsoft.prettytime.natty.java.lang.Object object2 = this.takeLock;
            synchronized (object2) {
                int c;
                this.head.next = null;
                if (!$assertionsDisabled && this.head.item != null) {
                    throw new AssertionError();
                }
                this.last = this.head;
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    c = this.count;
                    this.count = 0;
                }
                if (c == this.capacity) {
                    this.putLock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        Node first;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            org.ocpsoft.prettytime.natty.java.lang.Object object2 = this.takeLock;
            synchronized (object2) {
                int cold;
                first = this.head.next;
                this.head.next = null;
                if (!$assertionsDisabled && this.head.item != null) {
                    throw new AssertionError();
                }
                this.last = this.head;
                LinkedBlockingQueue linkedBlockingQueue = this;
                synchronized (linkedBlockingQueue) {
                    cold = this.count;
                    this.count = 0;
                }
                if (cold == this.capacity) {
                    this.putLock.notifyAll();
                }
            }
        }
        int n = 0;
        Node p = first;
        while (p != null) {
            c.add(p.item);
            p.item = null;
            ++n;
            p = p.next;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            org.ocpsoft.prettytime.natty.java.lang.Object object2 = this.takeLock;
            synchronized (object2) {
                int n;
                Node p = this.head.next;
                for (n = 0; p != null && n < maxElements; ++n) {
                    c.add(p.item);
                    p.item = null;
                    p = p.next;
                }
                if (n != 0) {
                    int cold;
                    this.head.next = p;
                    if (!$assertionsDisabled && this.head.item != null) {
                        throw new AssertionError();
                    }
                    if (p == null) {
                        this.last = this.head;
                    }
                    LinkedBlockingQueue linkedBlockingQueue = this;
                    synchronized (linkedBlockingQueue) {
                        cold = this.count;
                        this.count -= n;
                    }
                    if (cold == this.capacity) {
                        this.putLock.notifyAll();
                    }
                }
                return n;
            }
        }
    }

    public Iterator iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        org.ocpsoft.prettytime.natty.java.lang.Object object = this.putLock;
        synchronized (object) {
            org.ocpsoft.prettytime.natty.java.lang.Object object2 = this.takeLock;
            synchronized (object2) {
                s.defaultWriteObject();
                Node p = this.head.next;
                while (p != null) {
                    s.writeObject(p.item);
                    p = p.next;
                }
                s.writeObject(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        org.ocpsoft.prettytime.natty.java.lang.Object item;
        s.defaultReadObject();
        LinkedBlockingQueue linkedBlockingQueue = this;
        synchronized (linkedBlockingQueue) {
            this.count = 0;
        }
        this.last = this.head = new Node(null);
        while ((item = s.readObject()) != null) {
            this.add(item);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)((Object)x1));
        }
    }

    static {
        $assertionsDisabled = !(class$edu$emory$mathcs$backport$java$util$concurrent$LinkedBlockingQueue == null ? (class$edu$emory$mathcs$backport$java$util$concurrent$LinkedBlockingQueue = LinkedBlockingQueue.class$((String)"org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue")) : class$edu$emory$mathcs$backport$java$util$concurrent$LinkedBlockingQueue).desiredAssertionStatus();
    }

    private static class SerializableLock
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Serializable {
        private static final long serialVersionUID = -8856990691138858668L;

        private SerializableLock() {
        }
    }

    private class Itr
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Iterator {
        private Node current;
        private Node lastRet;
        private org.ocpsoft.prettytime.natty.java.lang.Object currentElement;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            org.ocpsoft.prettytime.natty.java.lang.Object object = LinkedBlockingQueue.this.putLock;
            synchronized (object) {
                org.ocpsoft.prettytime.natty.java.lang.Object object2 = LinkedBlockingQueue.this.takeLock;
                synchronized (object2) {
                    this.current = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                    if (this.current != null) {
                        this.currentElement = this.current.item;
                    }
                }
            }
        }

        public boolean hasNext() {
            return this.current != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public org.ocpsoft.prettytime.natty.java.lang.Object next() {
            org.ocpsoft.prettytime.natty.java.lang.Object object = LinkedBlockingQueue.this.putLock;
            synchronized (object) {
                org.ocpsoft.prettytime.natty.java.lang.Object object2 = LinkedBlockingQueue.this.takeLock;
                synchronized (object2) {
                    if (this.current == null) {
                        throw new NoSuchElementException();
                    }
                    org.ocpsoft.prettytime.natty.java.lang.Object x = this.currentElement;
                    this.lastRet = this.current;
                    this.current = this.current.next;
                    if (this.current != null) {
                        this.currentElement = this.current.item;
                    }
                    return x;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            org.ocpsoft.prettytime.natty.java.lang.Object object = LinkedBlockingQueue.this.putLock;
            synchronized (object) {
                org.ocpsoft.prettytime.natty.java.lang.Object object2 = LinkedBlockingQueue.this.takeLock;
                synchronized (object2) {
                    Node node = this.lastRet;
                    this.lastRet = null;
                    Node trail = LinkedBlockingQueue.this.head;
                    Node p = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                    while (p != null && p != node) {
                        trail = p;
                        p = p.next;
                    }
                    if (p == node) {
                        int c;
                        p.item = null;
                        trail.next = p.next;
                        if (LinkedBlockingQueue.this.last == p) {
                            LinkedBlockingQueue.this.last = trail;
                        }
                        Itr itr = this;
                        synchronized (itr) {
                            c = LinkedBlockingQueue.this.count--;
                        }
                        if (c == LinkedBlockingQueue.this.capacity) {
                            LinkedBlockingQueue.this.putLock.notifyAll();
                        }
                    }
                }
            }
        }
    }

    static class Node
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        volatile org.ocpsoft.prettytime.natty.java.lang.Object item;
        Node next;

        Node(org.ocpsoft.prettytime.natty.java.lang.Object x) {
            this.item = x;
        }
    }
}

