/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.AbstractQueue;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.BlockingDeque;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.ObjectInputStream;
import org.ocpsoft.prettytime.natty.java.io.ObjectOutputStream;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalStateException;
import org.ocpsoft.prettytime.natty.java.lang.InterruptedException;
import org.ocpsoft.prettytime.natty.java.lang.NullPointerException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Array;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.NoSuchElementException;

public class LinkedBlockingDeque
extends AbstractQueue
implements BlockingDeque,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    private transient Node first;
    private transient Node last;
    private transient int count;
    private final int capacity;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }

    public LinkedBlockingDeque(Collection c) {
        this(Integer.MAX_VALUE);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            org.ocpsoft.prettytime.natty.java.lang.Object e = itr.next();
            this.add(e);
        }
    }

    private boolean linkFirst(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        Node x;
        if (this.count >= this.capacity) {
            return false;
        }
        ++this.count;
        Node f = this.first;
        this.first = x = new Node(e, null, f);
        if (this.last == null) {
            this.last = x;
        } else {
            f.prev = x;
        }
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        Node x;
        if (this.count >= this.capacity) {
            return false;
        }
        ++this.count;
        Node l = this.last;
        this.last = x = new Node(e, l, null);
        if (this.first == null) {
            this.first = x;
        } else {
            l.next = x;
        }
        this.notEmpty.signal();
        return true;
    }

    private org.ocpsoft.prettytime.natty.java.lang.Object unlinkFirst() {
        Node n;
        Node f = this.first;
        if (f == null) {
            return null;
        }
        this.first = n = f.next;
        if (n == null) {
            this.last = null;
        } else {
            n.prev = null;
        }
        --this.count;
        this.notFull.signal();
        return f.item;
    }

    private org.ocpsoft.prettytime.natty.java.lang.Object unlinkLast() {
        Node p;
        Node l = this.last;
        if (l == null) {
            return null;
        }
        this.last = p = l.prev;
        if (p == null) {
            this.first = null;
        } else {
            p.next = null;
        }
        --this.count;
        this.notFull.signal();
        return l.item;
    }

    private void unlink(Node x) {
        Node p = x.prev;
        Node n = x.next;
        if (p == null) {
            if (n == null) {
                this.last = null;
                this.first = null;
            } else {
                n.prev = null;
                this.first = n;
            }
        } else if (n == null) {
            p.next = null;
            this.last = p;
        } else {
            p.next = n;
            n.prev = p;
        }
        --this.count;
        this.notFull.signalAll();
    }

    public void addFirst(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        if (!this.offerFirst(e)) {
            throw new IllegalStateException((String)"org.ocpsoft.prettytime.natty.Deque full");
        }
    }

    public void addLast(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        if (!this.offerLast(e)) {
            throw new IllegalStateException((String)"org.ocpsoft.prettytime.natty.Deque full");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerFirst(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkFirst(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerLast(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean bl = this.linkLast(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFirst(org.ocpsoft.prettytime.natty.java.lang.Object e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkFirst(e)) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLast(org.ocpsoft.prettytime.natty.java.lang.Object e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            while (!this.linkLast(e)) {
                this.notFull.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean offerFirst(org.ocpsoft.prettytime.natty.java.lang.Object e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        long deadline = Utils.nanoTime() + nanos;
        this.lock.lockInterruptibly();
        try {
            while (true) {
                if (this.linkFirst(e)) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                this.notFull.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean offerLast(org.ocpsoft.prettytime.natty.java.lang.Object e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        long deadline = Utils.nanoTime() + nanos;
        this.lock.lockInterruptibly();
        try {
            while (true) {
                if (this.linkLast(e)) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                this.notFull.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object removeFirst() {
        org.ocpsoft.prettytime.natty.java.lang.Object x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object removeLast() {
        org.ocpsoft.prettytime.natty.java.lang.Object x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object pollFirst() {
        this.lock.lock();
        try {
            org.ocpsoft.prettytime.natty.java.lang.Object object = this.unlinkFirst();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object pollLast() {
        this.lock.lock();
        try {
            org.ocpsoft.prettytime.natty.java.lang.Object object = this.unlinkLast();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object takeFirst() throws InterruptedException {
        this.lock.lock();
        try {
            org.ocpsoft.prettytime.natty.java.lang.Object x;
            while ((x = this.unlinkFirst()) == null) {
                this.notEmpty.await();
            }
            org.ocpsoft.prettytime.natty.java.lang.Object object = x;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object takeLast() throws InterruptedException {
        this.lock.lock();
        try {
            org.ocpsoft.prettytime.natty.java.lang.Object x;
            while ((x = this.unlinkLast()) == null) {
                this.notEmpty.await();
            }
            org.ocpsoft.prettytime.natty.java.lang.Object object = x;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        long deadline = Utils.nanoTime() + nanos;
        this.lock.lockInterruptibly();
        try {
            while (true) {
                org.ocpsoft.prettytime.natty.java.lang.Object x;
                if ((x = this.unlinkFirst()) != null) {
                    org.ocpsoft.prettytime.natty.java.lang.Object object = x;
                    return object;
                }
                if (nanos <= 0L) {
                    org.ocpsoft.prettytime.natty.java.lang.Object object = null;
                    return object;
                }
                this.notEmpty.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        long deadline = Utils.nanoTime() + nanos;
        this.lock.lockInterruptibly();
        try {
            while (true) {
                org.ocpsoft.prettytime.natty.java.lang.Object x;
                if ((x = this.unlinkLast()) != null) {
                    org.ocpsoft.prettytime.natty.java.lang.Object object = x;
                    return object;
                }
                if (nanos <= 0L) {
                    org.ocpsoft.prettytime.natty.java.lang.Object object = null;
                    return object;
                }
                this.notEmpty.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object getFirst() {
        org.ocpsoft.prettytime.natty.java.lang.Object x = this.peekFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object getLast() {
        org.ocpsoft.prettytime.natty.java.lang.Object x = this.peekLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object peekFirst() {
        this.lock.lock();
        try {
            org.ocpsoft.prettytime.natty.java.lang.Object object = this.first == null ? null : this.first.item;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object peekLast() {
        this.lock.lock();
        try {
            org.ocpsoft.prettytime.natty.java.lang.Object object = this.last == null ? null : this.last.item;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFirstOccurrence(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node p = this.first;
            while (p != null) {
                if (o.equals(p.item)) {
                    this.unlink(p);
                    boolean bl = true;
                    return bl;
                }
                p = p.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLastOccurrence(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node p = this.last;
            while (p != null) {
                if (o.equals(p.item)) {
                    this.unlink(p);
                    boolean bl = true;
                    return bl;
                }
                p = p.prev;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean add(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        this.addLast(e);
        return true;
    }

    public boolean offer(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        return this.offerLast(e);
    }

    public void put(org.ocpsoft.prettytime.natty.java.lang.Object e) throws InterruptedException {
        this.putLast(e);
    }

    public boolean offer(org.ocpsoft.prettytime.natty.java.lang.Object e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e, timeout, unit);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object remove() {
        return this.removeFirst();
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object poll() {
        return this.pollFirst();
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object take() throws InterruptedException {
        return this.takeFirst();
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object element() {
        return this.getFirst();
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object peek() {
        return this.peekFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remainingCapacity() {
        this.lock.lock();
        try {
            int n = this.capacity - this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            Node p = this.first;
            while (p != null) {
                c.add(p.item);
                p = p.next;
            }
            int n = this.count;
            this.count = 0;
            this.last = null;
            this.first = null;
            this.notFull.signalAll();
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            int n;
            for (n = 0; n < maxElements && this.first != null; ++n) {
                c.add(this.first.item);
                this.first.prev = null;
                this.first = this.first.next;
                --this.count;
            }
            if (this.first == null) {
                this.last = null;
            }
            this.notFull.signalAll();
            int n2 = n;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void push(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        this.addFirst(e);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object pop() {
        return this.removeFirst();
    }

    public boolean remove(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        return this.removeFirstOccurrence(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            Node p = this.first;
            while (p != null) {
                if (o.equals(p.item)) {
                    boolean bl = true;
                    return bl;
                }
                p = p.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeNode(Node e) {
        this.lock.lock();
        try {
            Node p = this.first;
            while (p != null) {
                if (p == e) {
                    this.unlink(p);
                    boolean bl = true;
                    return bl;
                }
                p = p.next;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray() {
        this.lock.lock();
        try {
            org.ocpsoft.prettytime.natty.java.lang.Object[] a = new org.ocpsoft.prettytime.natty.java.lang.Object[this.count];
            int k = 0;
            Node p = this.first;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            org.ocpsoft.prettytime.natty.java.lang.Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray(org.ocpsoft.prettytime.natty.java.lang.Object[] a) {
        this.lock.lock();
        try {
            if (a.length < this.count) {
                a = (org.ocpsoft.prettytime.natty.java.lang.Object[])Array.newInstance((Class)a.getClass().getComponentType(), (int)this.count);
            }
            int k = 0;
            Node p = this.first;
            while (p != null) {
                a[k++] = p.item;
                p = p.next;
            }
            if (a.length > k) {
                a[k] = null;
            }
            org.ocpsoft.prettytime.natty.java.lang.Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.last = null;
            this.first = null;
            this.count = 0;
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Iterator iterator() {
        return new Itr();
    }

    public Iterator descendingIterator() {
        return new DescendingItr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lock.lock();
        try {
            s.defaultWriteObject();
            Node p = this.first;
            while (p != null) {
                s.writeObject(p.item);
                p = p.next;
            }
            s.writeObject(null);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        org.ocpsoft.prettytime.natty.java.lang.Object item;
        s.defaultReadObject();
        this.count = 0;
        this.first = null;
        this.last = null;
        while ((item = s.readObject()) != null) {
            this.add(item);
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void advance() {
            ReentrantLock lock = LinkedBlockingDeque.this.lock;
            lock.lock();
            try {
                this.next = this.next == null ? LinkedBlockingDeque.this.last : this.next.prev;
                this.nextItem = this.next == null ? null : this.next.item;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void advance() {
            ReentrantLock lock = LinkedBlockingDeque.this.lock;
            lock.lock();
            try {
                this.next = this.next == null ? LinkedBlockingDeque.this.first : this.next.next;
                this.nextItem = this.next == null ? null : this.next.item;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private abstract class AbstractItr
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Iterator {
        Node next;
        org.ocpsoft.prettytime.natty.java.lang.Object nextItem;
        private Node lastRet;

        AbstractItr() {
            this.advance();
        }

        abstract void advance();

        public boolean hasNext() {
            return this.next != null;
        }

        public org.ocpsoft.prettytime.natty.java.lang.Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.next;
            org.ocpsoft.prettytime.natty.java.lang.Object x = this.nextItem;
            this.advance();
            return x;
        }

        public void remove() {
            Node n = this.lastRet;
            if (n == null) {
                throw new IllegalStateException();
            }
            this.lastRet = null;
            LinkedBlockingDeque.this.removeNode(n);
        }
    }

    static final class Node
    extends org.ocpsoft.prettytime.natty.java.lang.Object {
        org.ocpsoft.prettytime.natty.java.lang.Object item;
        Node prev;
        Node next;

        Node(org.ocpsoft.prettytime.natty.java.lang.Object x, Node p, Node n) {
            this.item = x;
            this.prev = p;
            this.next = n;
        }
    }
}

