/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.InterruptedException;
import org.ocpsoft.prettytime.natty.java.lang.Object;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuffer;
import org.ocpsoft.prettytime.natty.java.lang.Thread;

public class CountDownLatch
extends Object {
    private int count_;

    public CountDownLatch(int count) {
        if (count < 0) {
            throw new IllegalArgumentException((String)"org.ocpsoft.prettytime.natty.count < 0");
        }
        this.count_ = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDownLatch countDownLatch = this;
        synchronized (countDownLatch) {
            while (this.count_ > 0) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        CountDownLatch countDownLatch = this;
        synchronized (countDownLatch) {
            if (this.count_ <= 0) {
                return true;
            }
            if (nanos <= 0L) {
                return false;
            }
            long deadline = Utils.nanoTime() + nanos;
            do {
                TimeUnit.NANOSECONDS.timedWait(this, nanos);
                if (this.count_ > 0) continue;
                return true;
            } while ((nanos = deadline - Utils.nanoTime()) > 0L);
            return false;
        }
    }

    public synchronized void countDown() {
        if (this.count_ == 0) {
            return;
        }
        if (--this.count_ == 0) {
            this.notifyAll();
        }
    }

    public long getCount() {
        return this.count_;
    }

    public String toString() {
        return new StringBuffer().append(super.toString()).append((String)"org.ocpsoft.prettytime.natty.[Count = ").append(this.getCount()).append((String)"org.ocpsoft.prettytime.natty.]").toString();
    }
}

