/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.AbstractQueue;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.Arrays;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.ObjectInputStream;
import org.ocpsoft.prettytime.natty.java.io.ObjectOutputStream;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.AssertionError;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.Comparable;
import org.ocpsoft.prettytime.natty.java.lang.IllegalArgumentException;
import org.ocpsoft.prettytime.natty.java.lang.IllegalStateException;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.NullPointerException;
import org.ocpsoft.prettytime.natty.java.lang.OutOfMemoryError;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.Comparator;
import org.ocpsoft.prettytime.natty.java.util.ConcurrentModificationException;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.java.util.NoSuchElementException;
import org.ocpsoft.prettytime.natty.java.util.SortedSet;

public class PriorityQueue
extends AbstractQueue
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INIT_CAPACITY = 11;
    private transient org.ocpsoft.prettytime.natty.java.lang.Object[] buffer;
    private int size;
    private final Comparator comparator;
    private transient int modCount;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$PriorityQueue;

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityQueue(Comparator comparator) {
        this(11, comparator);
    }

    public PriorityQueue(int initialCapacity, Comparator comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = new org.ocpsoft.prettytime.natty.java.lang.Object[initialCapacity];
        this.comparator = comparator;
    }

    public PriorityQueue(PriorityQueue q) {
        this((Collection)q);
    }

    public PriorityQueue(SortedSet s) {
        this((Collection)s);
    }

    public PriorityQueue(Collection c) {
        int capacity = c.size();
        if ((capacity += this.size / 10) < 0) {
            capacity = Integer.MAX_VALUE;
        } else if (capacity == 0) {
            capacity = 1;
        }
        this.buffer = new org.ocpsoft.prettytime.natty.java.lang.Object[capacity];
        if (c instanceof PriorityQueue) {
            PriorityQueue that = (PriorityQueue)c;
            this.comparator = that.comparator;
            this.size = that.size;
            System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)that.buffer, (int)0, (org.ocpsoft.prettytime.natty.java.lang.Object)this.buffer, (int)0, (int)this.size);
        } else if (c instanceof SortedSet) {
            SortedSet s = (SortedSet)c;
            this.comparator = s.comparator();
            Iterator itr = s.iterator();
            while (itr.hasNext()) {
                this.buffer[this.size++] = itr.next();
            }
        } else {
            this.comparator = null;
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                this.buffer[this.size++] = itr.next();
            }
            for (int i = this.size / 2; i >= 0; --i) {
                this.percolateDown(i, this.buffer[i]);
            }
        }
    }

    public Iterator iterator() {
        return new Itr();
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean offer(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.size == this.buffer.length) {
            int newlen = this.buffer.length * 2;
            if (newlen < this.buffer.length) {
                if (this.buffer.length == Integer.MAX_VALUE) {
                    throw new OutOfMemoryError();
                }
                newlen = Integer.MAX_VALUE;
            }
            org.ocpsoft.prettytime.natty.java.lang.Object[] newbuffer = new org.ocpsoft.prettytime.natty.java.lang.Object[newlen];
            System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)this.buffer, (int)0, (org.ocpsoft.prettytime.natty.java.lang.Object)newbuffer, (int)0, (int)this.size);
            this.buffer = newbuffer;
        }
        ++this.modCount;
        this.percolateUp(this.size++, o);
        return true;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object peek() {
        return this.size == 0 ? null : this.buffer[0];
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object poll() {
        if (this.size == 0) {
            return null;
        }
        ++this.modCount;
        org.ocpsoft.prettytime.natty.java.lang.Object head = this.buffer[0];
        --this.size;
        this.percolateDown(0, this.buffer[this.size]);
        this.buffer[this.size] = null;
        return head;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int percolateDown(int idx, org.ocpsoft.prettytime.natty.java.lang.Object e) {
        try {
            if (this.comparator != null) {
                int c;
                while ((c = (idx << 1) + 1) < this.size) {
                    if (c + 1 < this.size && this.comparator.compare(this.buffer[c], this.buffer[c + 1]) > 0) {
                        ++c;
                    }
                    if (this.comparator.compare(e, this.buffer[c]) > 0) {
                        this.buffer[idx] = this.buffer[c];
                        idx = c;
                        continue;
                    }
                    break;
                }
            } else {
                int c;
                Comparable ec = (Comparable)e;
                while ((c = (idx << 1) + 1) < this.size) {
                    if (c + 1 < this.size && ((Comparable)this.buffer[c]).compareTo(this.buffer[c + 1]) > 0) {
                        ++c;
                    }
                    if (ec.compareTo(this.buffer[c]) > 0) {
                        this.buffer[idx] = this.buffer[c];
                        idx = c;
                        continue;
                    }
                    break;
                }
            }
            int n = idx;
            return n;
        }
        finally {
            this.buffer[idx] = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int percolateUp(int idx, org.ocpsoft.prettytime.natty.java.lang.Object e) {
        try {
            int c;
            if (this.comparator != null) {
                int c2;
                while (idx > 0 && this.comparator.compare(e, this.buffer[c2 = idx - 1 >>> 1]) < 0) {
                    this.buffer[idx] = this.buffer[c2];
                    idx = c2;
                }
                c2 = idx;
                return c2;
            }
            Comparable ce = (Comparable)e;
            while (idx > 0 && ce.compareTo(this.buffer[c = idx - 1 >>> 1]) < 0) {
                this.buffer[idx] = this.buffer[c];
                idx = c;
            }
            int n = idx;
            return n;
        }
        finally {
            this.buffer[idx] = e;
        }
    }

    public boolean add(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        return this.offer(o);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        org.ocpsoft.prettytime.natty.java.lang.Object head = this.buffer[0];
        ++this.modCount;
        --this.size;
        this.percolateDown(0, this.buffer[this.size]);
        this.buffer[this.size] = null;
        return head;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object element() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.buffer[0];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.buffer[i])) continue;
            return true;
        }
        return false;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray() {
        return Arrays.copyOf(this.buffer, this.size, array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = PriorityQueue.class$((String)"[Lorg.ocpsoft.prettytime.natty.java.lang.Object;")) : array$Ljava$lang$Object);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray(org.ocpsoft.prettytime.natty.java.lang.Object[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.buffer, this.size, a.getClass());
        }
        System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)this.buffer, (int)0, (org.ocpsoft.prettytime.natty.java.lang.Object)a, (int)0, (int)this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public boolean remove(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        if (o == null) {
            return false;
        }
        if (this.comparator != null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.comparator.compare(this.buffer[i], o) != 0) continue;
                this.removeAt(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (((Comparable)this.buffer[i]).compareTo(o) != 0) continue;
                this.removeAt(i);
                return true;
            }
        }
        return false;
    }

    private org.ocpsoft.prettytime.natty.java.lang.Object removeAt(int i) {
        if (!$assertionsDisabled && i >= this.size) {
            throw new AssertionError();
        }
        ++this.modCount;
        --this.size;
        org.ocpsoft.prettytime.natty.java.lang.Object e = this.buffer[this.size];
        this.buffer[this.size] = null;
        int newpos = this.percolateDown(i, e);
        if (newpos != i) {
            return null;
        }
        newpos = this.percolateUp(i, e);
        return newpos < i ? e : null;
    }

    public void clear() {
        ++this.modCount;
        Arrays.fill(this.buffer, 0, this.size, null);
        this.size = 0;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        os.writeInt(this.buffer.length);
        for (int i = 0; i < this.size; ++i) {
            os.writeObject(this.buffer[i]);
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.buffer = new org.ocpsoft.prettytime.natty.java.lang.Object[is.readInt()];
        for (int i = 0; i < this.size; ++i) {
            this.buffer[i] = is.readObject();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)((Object)x1));
        }
    }

    static {
        $assertionsDisabled = !(class$edu$emory$mathcs$backport$java$util$PriorityQueue == null ? (class$edu$emory$mathcs$backport$java$util$PriorityQueue = PriorityQueue.class$((String)"org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.PriorityQueue")) : class$edu$emory$mathcs$backport$java$util$PriorityQueue).desiredAssertionStatus();
    }

    private class Itr
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Iterator {
        int cursor = 0;
        List percolatedElems;
        int cursorPercolated = 0;
        int expectedModCount = PriorityQueue.access$000(PriorityQueue.this);
        int lastRet;
        org.ocpsoft.prettytime.natty.java.lang.Object lastRetPercolated;

        Itr() {
        }

        public boolean hasNext() {
            return this.cursor < PriorityQueue.this.size || this.percolatedElems != null;
        }

        public org.ocpsoft.prettytime.natty.java.lang.Object next() {
            this.checkForComodification();
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.buffer[this.lastRet];
            }
            if (this.percolatedElems != null) {
                this.lastRet = -1;
                this.lastRetPercolated = this.percolatedElems.remove(this.percolatedElems.size() - 1);
                if (this.percolatedElems.isEmpty()) {
                    this.percolatedElems = null;
                }
                return this.lastRetPercolated;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastRet >= 0) {
                org.ocpsoft.prettytime.natty.java.lang.Object percolatedElem = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (percolatedElem == null) {
                    --this.cursor;
                } else {
                    if (this.percolatedElems == null) {
                        this.percolatedElems = new ArrayList();
                    }
                    this.percolatedElems.add(percolatedElem);
                }
            } else if (this.lastRetPercolated != null) {
                PriorityQueue.this.remove(this.lastRetPercolated);
                this.lastRetPercolated = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        private void checkForComodification() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

