/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util;

import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.AbstractCollection;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.Arrays;
import org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.Deque;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.ObjectInputStream;
import org.ocpsoft.prettytime.natty.java.io.ObjectOutputStream;
import org.ocpsoft.prettytime.natty.java.io.Serializable;
import org.ocpsoft.prettytime.natty.java.lang.AssertionError;
import org.ocpsoft.prettytime.natty.java.lang.Class;
import org.ocpsoft.prettytime.natty.java.lang.ClassNotFoundException;
import org.ocpsoft.prettytime.natty.java.lang.CloneNotSupportedException;
import org.ocpsoft.prettytime.natty.java.lang.Cloneable;
import org.ocpsoft.prettytime.natty.java.lang.IllegalStateException;
import org.ocpsoft.prettytime.natty.java.lang.NoClassDefFoundError;
import org.ocpsoft.prettytime.natty.java.lang.NullPointerException;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.System;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.lang.reflect.Array;
import org.ocpsoft.prettytime.natty.java.util.Collection;
import org.ocpsoft.prettytime.natty.java.util.ConcurrentModificationException;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.NoSuchElementException;

public class ArrayDeque
extends AbstractCollection
implements Deque,
Cloneable,
Serializable {
    private transient org.ocpsoft.prettytime.natty.java.lang.Object[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$ArrayDeque;

    private void allocateElements(int numElements) {
        int initialCapacity = 8;
        if (numElements >= initialCapacity) {
            initialCapacity = numElements;
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        this.elements = new org.ocpsoft.prettytime.natty.java.lang.Object[initialCapacity];
    }

    private void doubleCapacity() {
        if (!$assertionsDisabled && this.head != this.tail) {
            throw new AssertionError();
        }
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException((String)"org.ocpsoft.prettytime.natty.Sorry, deque too big");
        }
        org.ocpsoft.prettytime.natty.java.lang.Object[] a = new org.ocpsoft.prettytime.natty.java.lang.Object[newCapacity];
        System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)this.elements, (int)p, (org.ocpsoft.prettytime.natty.java.lang.Object)a, (int)0, (int)r);
        System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)this.elements, (int)0, (org.ocpsoft.prettytime.natty.java.lang.Object)a, (int)r, (int)p);
        this.elements = a;
        this.head = 0;
        this.tail = n;
    }

    private org.ocpsoft.prettytime.natty.java.lang.Object[] copyElements(org.ocpsoft.prettytime.natty.java.lang.Object[] a) {
        if (this.head < this.tail) {
            System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)this.elements, (int)this.head, (org.ocpsoft.prettytime.natty.java.lang.Object)a, (int)0, (int)this.size());
        } else if (this.head > this.tail) {
            int headPortionLen = this.elements.length - this.head;
            System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)this.elements, (int)this.head, (org.ocpsoft.prettytime.natty.java.lang.Object)a, (int)0, (int)headPortionLen);
            System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)this.elements, (int)0, (org.ocpsoft.prettytime.natty.java.lang.Object)a, (int)headPortionLen, (int)this.tail);
        }
        return a;
    }

    public ArrayDeque() {
        this.elements = new org.ocpsoft.prettytime.natty.java.lang.Object[16];
    }

    public ArrayDeque(int numElements) {
        this.allocateElements(numElements);
    }

    public ArrayDeque(Collection c) {
        this.allocateElements(c.size());
        this.addAll(c);
    }

    public void addFirst(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void addLast(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    public boolean offerFirst(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        this.addFirst(e);
        return true;
    }

    public boolean offerLast(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        this.addLast(e);
        return true;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object removeFirst() {
        org.ocpsoft.prettytime.natty.java.lang.Object x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object removeLast() {
        org.ocpsoft.prettytime.natty.java.lang.Object x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object pollFirst() {
        int h = this.head;
        org.ocpsoft.prettytime.natty.java.lang.Object result = this.elements[h];
        if (result == null) {
            return null;
        }
        this.elements[h] = null;
        this.head = h + 1 & this.elements.length - 1;
        return result;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object pollLast() {
        int t = this.tail - 1 & this.elements.length - 1;
        org.ocpsoft.prettytime.natty.java.lang.Object result = this.elements[t];
        if (result == null) {
            return null;
        }
        this.elements[t] = null;
        this.tail = t;
        return result;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object getFirst() {
        org.ocpsoft.prettytime.natty.java.lang.Object x = this.elements[this.head];
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object getLast() {
        org.ocpsoft.prettytime.natty.java.lang.Object x = this.elements[this.tail - 1 & this.elements.length - 1];
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object peekFirst() {
        return this.elements[this.head];
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object peekLast() {
        return this.elements[this.tail - 1 & this.elements.length - 1];
    }

    public boolean removeFirstOccurrence(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        org.ocpsoft.prettytime.natty.java.lang.Object x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                this.delete(i);
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    public boolean removeLastOccurrence(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        org.ocpsoft.prettytime.natty.java.lang.Object x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.tail - 1 & mask;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                this.delete(i);
                return true;
            }
            i = i - 1 & mask;
        }
        return false;
    }

    public boolean add(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        this.addLast(e);
        return true;
    }

    public boolean offer(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        return this.offerLast(e);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object remove() {
        return this.removeFirst();
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object poll() {
        return this.pollFirst();
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object element() {
        return this.getFirst();
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object peek() {
        return this.peekFirst();
    }

    public void push(org.ocpsoft.prettytime.natty.java.lang.Object e) {
        this.addFirst(e);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object pop() {
        return this.removeFirst();
    }

    private void checkInvariants() {
        if (!$assertionsDisabled && this.elements[this.tail] != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(this.head != this.tail ? this.elements[this.head] != null && this.elements[this.tail - 1 & this.elements.length - 1] != null : this.elements[this.head] == null)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.elements[this.head - 1 & this.elements.length - 1] != null) {
            throw new AssertionError();
        }
    }

    private boolean delete(int i) {
        this.checkInvariants();
        org.ocpsoft.prettytime.natty.java.lang.Object[] elements = this.elements;
        int mask = elements.length - 1;
        int h = this.head;
        int t = this.tail;
        int front = i - h & mask;
        int back = t - i & mask;
        if (front >= (t - h & mask)) {
            throw new ConcurrentModificationException();
        }
        if (front < back) {
            if (h <= i) {
                System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)h, (org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)(h + 1), (int)front);
            } else {
                System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)0, (org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)1, (int)i);
                elements[0] = elements[mask];
                System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)h, (org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)(h + 1), (int)(mask - h));
            }
            elements[h] = null;
            this.head = h + 1 & mask;
            return false;
        }
        if (i < t) {
            System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)(i + 1), (org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)i, (int)back);
            this.tail = t - 1;
        } else {
            System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)(i + 1), (org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)i, (int)(mask - i));
            elements[mask] = elements[0];
            System.arraycopy((org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)1, (org.ocpsoft.prettytime.natty.java.lang.Object)elements, (int)0, (int)t);
            this.tail = t - 1 & mask;
        }
        return true;
    }

    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public Iterator iterator() {
        return new DeqIterator();
    }

    public Iterator descendingIterator() {
        return new DescendingIterator();
    }

    public boolean contains(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        org.ocpsoft.prettytime.natty.java.lang.Object x;
        if (o == null) {
            return false;
        }
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    public boolean remove(org.ocpsoft.prettytime.natty.java.lang.Object o) {
        return this.removeFirstOccurrence(o);
    }

    public void clear() {
        int h = this.head;
        int t = this.tail;
        if (h != t) {
            this.tail = 0;
            this.head = 0;
            int i = h;
            int mask = this.elements.length - 1;
            do {
                this.elements[i] = null;
            } while ((i = i + 1 & mask) != t);
        }
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray() {
        return this.copyElements(new org.ocpsoft.prettytime.natty.java.lang.Object[this.size()]);
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object[] toArray(org.ocpsoft.prettytime.natty.java.lang.Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (org.ocpsoft.prettytime.natty.java.lang.Object[])Array.newInstance((Class)a.getClass().getComponentType(), (int)size);
        }
        this.copyElements(a);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public org.ocpsoft.prettytime.natty.java.lang.Object clone() {
        try {
            ArrayDeque result = (ArrayDeque)super.clone();
            result.elements = Arrays.copyOf(this.elements, this.elements.length);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size());
        int mask = this.elements.length - 1;
        int i = this.head;
        while (i != this.tail) {
            s.writeObject(this.elements[i]);
            i = i + 1 & mask;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.allocateElements(size);
        this.head = 0;
        this.tail = size;
        for (int i = 0; i < size; ++i) {
            this.elements[i] = s.readObject();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName((String)x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause((Throwable)((Object)x1));
        }
    }

    static {
        $assertionsDisabled = !(class$edu$emory$mathcs$backport$java$util$ArrayDeque == null ? (class$edu$emory$mathcs$backport$java$util$ArrayDeque = ArrayDeque.class$((String)"org.ocpsoft.prettytime.natty.edu.emory.mathcs.backport.java.util.ArrayDeque")) : class$edu$emory$mathcs$backport$java$util$ArrayDeque).desiredAssertionStatus();
    }

    private class DescendingIterator
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Iterator {
        private int cursor;
        private int fence;
        private int lastRet;

        private DescendingIterator() {
            this.cursor = ArrayDeque.this.tail;
            this.fence = ArrayDeque.this.head;
            this.lastRet = -1;
        }

        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        public org.ocpsoft.prettytime.natty.java.lang.Object next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            this.cursor = this.cursor - 1 & ArrayDeque.this.elements.length - 1;
            org.ocpsoft.prettytime.natty.java.lang.Object result = ArrayDeque.this.elements[this.cursor];
            if (ArrayDeque.this.head != this.fence || result == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            return result;
        }

        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (!ArrayDeque.this.delete(this.lastRet)) {
                this.cursor = this.cursor + 1 & ArrayDeque.this.elements.length - 1;
                this.fence = ArrayDeque.this.head;
            }
            this.lastRet = -1;
        }
    }

    private class DeqIterator
    extends org.ocpsoft.prettytime.natty.java.lang.Object
    implements Iterator {
        private int cursor;
        private int fence;
        private int lastRet;

        private DeqIterator() {
            this.cursor = ArrayDeque.this.head;
            this.fence = ArrayDeque.this.tail;
            this.lastRet = -1;
        }

        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        public org.ocpsoft.prettytime.natty.java.lang.Object next() {
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            org.ocpsoft.prettytime.natty.java.lang.Object result = ArrayDeque.this.elements[this.cursor];
            if (ArrayDeque.this.tail != this.fence || result == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & ArrayDeque.this.elements.length - 1;
            return result;
        }

        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (ArrayDeque.this.delete(this.lastRet)) {
                this.cursor = this.cursor - 1 & ArrayDeque.this.elements.length - 1;
                this.fence = ArrayDeque.this.tail;
            }
            this.lastRet = -1;
        }
    }
}

