/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.com.joestelmach.natty;

import org.ocpsoft.prettytime.natty.com.joestelmach.natty.CalendarSource;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.DateGroup;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.Holiday;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.lang.AssertionError;
import org.ocpsoft.prettytime.natty.java.lang.Integer;
import org.ocpsoft.prettytime.natty.java.lang.Math;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuilder;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.text.ParseException;
import org.ocpsoft.prettytime.natty.java.util.Date;
import org.ocpsoft.prettytime.natty.java.util.GregorianCalendar;
import org.ocpsoft.prettytime.natty.java.util.HashMap;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.Map;
import org.ocpsoft.prettytime.natty.java.util.TimeZone;
import org.ocpsoft.prettytime.natty.java.util.logging.Level;
import org.ocpsoft.prettytime.natty.java.util.logging.Logger;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.CalendarBuilder;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.data.ParserException;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Calendar;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.Period;
import org.ocpsoft.prettytime.natty.net.fortuna.ical4j.model.PeriodList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WalkerState
extends org.ocpsoft.prettytime.natty.java.lang.Object {
    private static final int TWO_DIGIT_YEAR_CENTURY_THRESHOLD = 20;
    private static final String MONTH = "org.ocpsoft.prettytime.natty.month";
    private static final String DAY = "org.ocpsoft.prettytime.natty.day";
    private static final String YEAR = "org.ocpsoft.prettytime.natty.year";
    private static final String WEEK = "org.ocpsoft.prettytime.natty.week";
    private static final String HOUR = "org.ocpsoft.prettytime.natty.hour";
    private static final String MINUTE = "org.ocpsoft.prettytime.natty.minute";
    private static final String SECOND = "org.ocpsoft.prettytime.natty.second";
    private static final String AM = "org.ocpsoft.prettytime.natty.am";
    private static final String PM = "org.ocpsoft.prettytime.natty.pm";
    private static final String DIR_LEFT = "org.ocpsoft.prettytime.natty.<";
    private static final String DIR_RIGHT = "org.ocpsoft.prettytime.natty.>";
    private static final String SEEK_PREFIX = "org.ocpsoft.prettytime.natty.by_";
    private static final String SEEK_BY_DAY = "org.ocpsoft.prettytime.natty.by_day";
    private static final String SEEK_BY_WEEK = "org.ocpsoft.prettytime.natty.by_week";
    private static final String PLUS = "org.ocpsoft.prettytime.natty.+";
    private static final String MINUS = "org.ocpsoft.prettytime.natty.-";
    private static final String GMT = "org.ocpsoft.prettytime.natty.GMT";
    private static final String VEVENT = "org.ocpsoft.prettytime.natty.VEVENT";
    private static final String SUMMARY = "org.ocpsoft.prettytime.natty.SUMMARY";
    private static final String HOLIDAY_ICS_FILE = "org/ocpsoft/prettytime/natty//holidays.ics";
    private static final Logger _logger = Logger.getLogger((String)"org.ocpsoft.prettytime.natty.com.joestelmach.natty");
    private GregorianCalendar _calendar;
    private TimeZone _defaultTimeZone;
    private int _currentYear;
    private boolean _firstDateInvocationInGroup = true;
    private boolean _timeGivenInGroup = false;
    private Calendar _holidayCalendar;
    private DateGroup _dateGroup;

    public WalkerState() {
        this.resetCalendar();
        this._dateGroup = new DateGroup();
    }

    public void setDefaultTimeZone(TimeZone zone) {
        this._defaultTimeZone = zone;
        this.resetCalendar();
    }

    public void seekToDayOfWeek(String direction, String seekType, String seekAmount, String dayOfWeek) {
        int sign;
        int dayOfWeekInt = Integer.parseInt((String)dayOfWeek);
        int seekAmountInt = Integer.parseInt((String)seekAmount);
        if (!($assertionsDisabled || direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.<") || direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.>"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || seekType.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.by_day") || seekType.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.by_week"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || dayOfWeekInt >= 1 && dayOfWeekInt <= 7)) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        int n = sign = direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.>") ? 1 : -1;
        if (seekType.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.by_week")) {
            this._calendar.set(7, dayOfWeekInt);
            this._calendar.add(6, seekAmountInt * 7 * sign);
        } else if (seekType.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.by_day")) {
            do {
                this._calendar.roll(6, sign);
            } while (this._calendar.get(7) != dayOfWeekInt);
            if (seekAmountInt > 0) {
                this._calendar.add(3, (seekAmountInt - 1) * sign);
            }
        }
    }

    public void seekToDayOfMonth(String dayOfMonth) {
        int dayOfMonthInt = Integer.parseInt((String)dayOfMonth);
        if (!($assertionsDisabled || dayOfMonthInt >= 1 && dayOfMonthInt <= 31)) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        dayOfMonthInt = Math.min((int)dayOfMonthInt, (int)this._calendar.getActualMaximum(5));
        this._calendar.set(5, dayOfMonthInt);
    }

    public void seekToDayOfYear(String dayOfYear) {
        int dayOfYearInt = Integer.parseInt((String)dayOfYear);
        if (!($assertionsDisabled || dayOfYearInt >= 1 && dayOfYearInt <= 366)) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        dayOfYearInt = Math.min((int)dayOfYearInt, (int)this._calendar.getActualMaximum(6));
        this._calendar.set(6, dayOfYearInt);
    }

    public void seekToYear(String year) {
        int yearInt = Integer.parseInt((String)year);
        if (!($assertionsDisabled || yearInt > 0 && yearInt < 9999)) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        this._calendar.set(1, this.getFullYear(Integer.valueOf((int)yearInt)));
    }

    public void seekToMonth(String direction, String seekAmount, String month) {
        int seekAmountInt = Integer.parseInt((String)seekAmount);
        int monthInt = Integer.parseInt((String)month);
        if (!($assertionsDisabled || direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.<") || direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.>"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || monthInt >= 1 && monthInt <= 12)) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        this._calendar.set(5, 1);
        if (seekAmountInt > 0) {
            int sign;
            int currentMonth = this._calendar.get(2) + 1;
            int n = sign = direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.>") ? 1 : -1;
            int numYearsToShift = seekAmountInt + (currentMonth <= monthInt ? (sign > 0 ? -1 : 0) : (sign > 0 ? 0 : -1));
            this._calendar.add(1, numYearsToShift * sign);
        }
        this._calendar.set(2, monthInt - 1);
    }

    public void seekBySpan(String direction, String seekAmount, String span) {
        int field;
        int sign;
        boolean isDateSeek;
        if (span.startsWith((String)"org.ocpsoft.prettytime.natty.by_")) {
            span = span.substring(3);
        }
        int seekAmountInt = Integer.parseInt((String)seekAmount);
        if (!($assertionsDisabled || direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.<") || direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.>"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.day") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.week") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.month") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.year") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.hour") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.minute") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.second"))) {
            throw new AssertionError();
        }
        boolean bl = isDateSeek = span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.day") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.week") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.month") || span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.year");
        if (isDateSeek) {
            this.markDateInvocation();
        } else {
            this.markTimeInvocation();
        }
        int n = sign = direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.>") ? 1 : -1;
        int n2 = span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.day") ? 6 : (span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.week") ? 3 : (span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.month") ? 2 : (span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.year") ? 1 : (span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.hour") ? 10 : (span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.minute") ? 12 : (field = (span.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.second") ? Integer.valueOf((int)13) : null).intValue()))))));
        if (field > 0) {
            this._calendar.add(field, seekAmountInt * sign);
        }
    }

    public void setDayOfWeekIndex(String index, String dayOfWeek) {
        int indexInt = Integer.parseInt((String)index);
        if (!($assertionsDisabled || indexInt > 0 && indexInt < 6)) {
            throw new AssertionError();
        }
        int dayOfWeekInt = Integer.parseInt((String)dayOfWeek);
        if (!($assertionsDisabled || dayOfWeekInt >= 1 && dayOfWeekInt <= 7)) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        this._calendar.set(5, 1);
        if (this._calendar.get(7) > dayOfWeekInt) {
            this._calendar.add(4, 1);
        }
        this._calendar.set(7, dayOfWeekInt);
        int currentMonth = this._calendar.get(2);
        this._calendar.add(4, indexInt - 1);
        if (currentMonth != this._calendar.get(2)) {
            this._calendar.add(4, -1);
        }
    }

    public void setExplicitDate(String month, String dayOfMonth, String dayOfWeek, String year) {
        int monthInt = Integer.parseInt((String)month);
        if (!($assertionsDisabled || monthInt > 0 && monthInt <= 12)) {
            throw new AssertionError();
        }
        int dayOfMonthInt = Integer.parseInt((String)dayOfMonth);
        if (!($assertionsDisabled || dayOfMonthInt > 0 && dayOfMonthInt <= 31)) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        this._calendar.set(2, monthInt - 1);
        this._calendar.set(5, dayOfMonthInt);
        if (year != null) {
            this.seekToYear(year);
        } else if (dayOfWeek != null) {
            int dayOfWeekInt = Integer.parseInt((String)dayOfWeek);
            if (!($assertionsDisabled || dayOfWeekInt >= 1 && dayOfWeekInt <= 7)) {
                throw new AssertionError();
            }
            while (this._calendar.get(7) != dayOfWeekInt) {
                this._calendar.roll(1, false);
            }
        }
    }

    public void setExplicitTime(String hours, String minutes, String seconds, String amPm, String zoneString) {
        int hoursInt = Integer.parseInt((String)hours);
        int minutesInt = Integer.parseInt((String)minutes);
        if (!($assertionsDisabled || amPm == null || amPm.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.am") || amPm.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.pm"))) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || hoursInt >= 0 && hoursInt <= 23)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || minutesInt >= 0 && minutesInt < 60)) {
            throw new AssertionError();
        }
        this.markTimeInvocation();
        this._calendar.set(14, 0);
        TimeZone zone = null;
        if (zoneString != null) {
            if (zoneString.startsWith((String)"org.ocpsoft.prettytime.natty.+") || zoneString.startsWith((String)"org.ocpsoft.prettytime.natty.-")) {
                zoneString = new StringBuilder().append((String)"org.ocpsoft.prettytime.natty.GMT").append(zoneString).toString();
            }
            zone = TimeZone.getTimeZone((String)zoneString);
        }
        this._calendar.setTimeZone(zone != null ? zone : this._defaultTimeZone);
        this._calendar.set(11, hoursInt);
        if (hoursInt <= 12) {
            int amPmInt = amPm == null ? (hoursInt >= 12 ? 1 : 0) : (amPm.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.pm") ? 1 : 0);
            this._calendar.set(9, amPmInt);
            if (hoursInt == 12) {
                hoursInt = 0;
            }
            this._calendar.set(10, hoursInt);
        }
        if (seconds != null) {
            int secondsInt = Integer.parseInt((String)seconds);
            if (!($assertionsDisabled || secondsInt >= 0 && secondsInt < 60)) {
                throw new AssertionError();
            }
            this._calendar.set(13, secondsInt);
        } else {
            this._calendar.set(13, 0);
        }
        this._calendar.set(12, minutesInt);
    }

    public void seekToHoliday(String holidayString, String direction, String seekAmount) {
        Holiday holiday = Holiday.valueOf(holidayString);
        int seekAmountInt = Integer.parseInt((String)seekAmount);
        if (!($assertionsDisabled || direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.<") || direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.>"))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && seekAmountInt < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && holiday == null) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        GregorianCalendar cal = this.getCalendar();
        cal.setTimeZone(this._defaultTimeZone);
        int currentYear = cal.get(1);
        boolean forwards = direction.equals((org.ocpsoft.prettytime.natty.java.lang.Object)"org.ocpsoft.prettytime.natty.>");
        int startYear = forwards ? currentYear : currentYear - seekAmountInt - 1;
        int endYear = forwards ? currentYear + seekAmountInt + 1 : currentYear;
        Map<Integer, Date> dates = this.getDatesForHoliday(startYear, endYear, holiday);
        boolean hasPassed = cal.getTime().after((Date)dates.get((org.ocpsoft.prettytime.natty.java.lang.Object)Integer.valueOf((int)currentYear)));
        int targetYear = currentYear + (forwards ? seekAmountInt + (hasPassed ? 0 : -1) : (seekAmountInt - (hasPassed ? 1 : 0)) * -1);
        cal.setTimeZone(this._calendar.getTimeZone());
        cal.setTime((Date)dates.get((org.ocpsoft.prettytime.natty.java.lang.Object)Integer.valueOf((int)targetYear)));
        this._calendar.set(1, cal.get(1));
        this._calendar.set(2, cal.get(2));
        this._calendar.set(5, cal.get(5));
    }

    public void seekToHolidayYear(String holidayString, String yearString) {
        Holiday holiday = Holiday.valueOf(holidayString);
        int yearInt = Integer.parseInt((String)yearString);
        if (!$assertionsDisabled && holiday == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && yearInt < 0) {
            throw new AssertionError();
        }
        this.markDateInvocation();
        int year = this.getFullYear(Integer.valueOf((int)yearInt));
        Map<Integer, Date> dates = this.getDatesForHoliday(year, year, holiday);
        Date date = (Date)dates.get((org.ocpsoft.prettytime.natty.java.lang.Object)Integer.valueOf((int)(year - (holiday.equals((org.ocpsoft.prettytime.natty.java.lang.Object)Holiday.NEW_YEARS_EVE) ? 1 : 0))));
        if (date != null) {
            GregorianCalendar cal = this.getCalendar();
            cal.setTimeZone(this._calendar.getTimeZone());
            cal.setTime(date);
            this._calendar.set(1, cal.get(1));
            this._calendar.set(2, cal.get(2));
            this._calendar.set(5, cal.get(5));
        }
    }

    public void setRecurring() {
        this._dateGroup.setRecurring(true);
    }

    public void captureDateTime() {
        Date date = this._calendar.getTime();
        if (this._dateGroup.isRecurring()) {
            this._dateGroup.setRecurringUntil(date);
        } else {
            this._dateGroup.addDate(date);
        }
        this._firstDateInvocationInGroup = true;
    }

    public DateGroup getDateGroup() {
        return this._dateGroup;
    }

    public void clearDateGroup() {
        this._dateGroup = new DateGroup();
    }

    private void resetCalendar() {
        this._calendar = this.getCalendar();
        if (this._defaultTimeZone != null) {
            this._calendar.setTimeZone(this._defaultTimeZone);
        }
        this._currentYear = this._calendar.get(1);
    }

    private void markDateInvocation() {
        if (this._firstDateInvocationInGroup) {
            if (this._timeGivenInGroup) {
                int hours = this._calendar.get(11);
                int minutes = this._calendar.get(12);
                int seconds = this._calendar.get(13);
                this.resetCalendar();
                this._calendar.set(11, hours);
                this._calendar.set(12, minutes);
                this._calendar.set(13, seconds);
            } else {
                this.resetCalendar();
            }
            this._firstDateInvocationInGroup = false;
        }
    }

    private void markTimeInvocation() {
        this._timeGivenInGroup = true;
    }

    private Map<Integer, Date> getDatesForHoliday(int startYear, int endYear, Holiday holiday) {
        HashMap holidays = new HashMap();
        if (this._holidayCalendar == null) {
            InputStream fin = WalkerState.class.getResourceAsStream((String)"org/ocpsoft/prettytime/natty//holidays.ics");
            try {
                this._holidayCalendar = new CalendarBuilder().build(fin);
            }
            catch (IOException e) {
                _logger.severe((String)"org/ocpsoft/prettytime/natty/Couln't open /holidays.ics");
                return holidays;
            }
            catch (ParserException e) {
                _logger.severe((String)"org/ocpsoft/prettytime/natty/Couln't parse /holidays.ics");
                return holidays;
            }
        }
        Period period = null;
        try {
            DateTime from = new DateTime(new StringBuilder().append(startYear).append((String)"org.ocpsoft.prettytime.natty.0101T000000Z").toString());
            DateTime to = new DateTime(new StringBuilder().append(endYear).append((String)"org.ocpsoft.prettytime.natty.1231T000000Z").toString());
            period = new Period(from, to);
        }
        catch (ParseException e) {
            _logger.log(Level.SEVERE, new StringBuilder().append((String)"org.ocpsoft.prettytime.natty.Invalid start or end year: ").append(startYear).append((String)"org.ocpsoft.prettytime.natty., ").append(endYear).toString(), (Throwable)e);
            return holidays;
        }
        Iterator i$ = this._holidayCalendar.getComponents((String)"org.ocpsoft.prettytime.natty.VEVENT").iterator();
        while (i$.hasNext()) {
            org.ocpsoft.prettytime.natty.java.lang.Object component = i$.next();
            Component vevent = (Component)component;
            String summary = vevent.getProperty((String)"org.ocpsoft.prettytime.natty.SUMMARY").getValue();
            if (!summary.equals((org.ocpsoft.prettytime.natty.java.lang.Object)holiday.getSummary())) continue;
            PeriodList list = vevent.calculateRecurrenceSet(period);
            Iterator i$2 = list.iterator();
            while (i$2.hasNext()) {
                org.ocpsoft.prettytime.natty.java.lang.Object p = i$2.next();
                DateTime date = ((Period)p).getStart();
                GregorianCalendar utcCal = this.getCalendar();
                utcCal.setTimeZone(TimeZone.getTimeZone((String)"org.ocpsoft.prettytime.natty.GMT"));
                utcCal.setTime((Date)date);
                GregorianCalendar localCal = this.getCalendar();
                localCal.setTimeZone(this._defaultTimeZone);
                localCal.set(1, utcCal.get(1));
                localCal.set(2, utcCal.get(2));
                localCal.set(5, utcCal.get(5));
                holidays.put((org.ocpsoft.prettytime.natty.java.lang.Object)Integer.valueOf((int)localCal.get(1)), (org.ocpsoft.prettytime.natty.java.lang.Object)localCal.getTime());
            }
        }
        return holidays;
    }

    private int getFullYear(Integer year) {
        int result = year.intValue();
        if (year.toString().length() <= 2) {
            int century = year.intValue() > this._currentYear - 2000 + 20 ? 1900 : 2000;
            result = year.intValue() + century;
        }
        return result;
    }

    protected GregorianCalendar getCalendar() {
        return CalendarSource.getCurrentCalendar();
    }
}

