/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.natty.com.joestelmach.natty;

import org.ocpsoft.prettytime.natty.com.joestelmach.natty.ANTLRNoCaseInputStream;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.DateGroup;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.NattyTokenSource;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.ParseListener;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.ParseLocation;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.generated.DateLexer;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.generated.DateParser;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.generated.DateWalker;
import org.ocpsoft.prettytime.natty.com.joestelmach.natty.generated.TreeRewrite;
import org.ocpsoft.prettytime.natty.java.io.ByteArrayInputStream;
import org.ocpsoft.prettytime.natty.java.io.IOException;
import org.ocpsoft.prettytime.natty.java.io.InputStream;
import org.ocpsoft.prettytime.natty.java.lang.Exception;
import org.ocpsoft.prettytime.natty.java.lang.String;
import org.ocpsoft.prettytime.natty.java.lang.StringBuilder;
import org.ocpsoft.prettytime.natty.java.lang.Throwable;
import org.ocpsoft.prettytime.natty.java.util.ArrayList;
import org.ocpsoft.prettytime.natty.java.util.Iterator;
import org.ocpsoft.prettytime.natty.java.util.List;
import org.ocpsoft.prettytime.natty.java.util.TimeZone;
import org.ocpsoft.prettytime.natty.java.util.logging.Level;
import org.ocpsoft.prettytime.natty.java.util.logging.Logger;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.CommonTokenStream;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.Token;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.TokenStream;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.tree.CommonTree;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.tree.CommonTreeNodeStream;
import org.ocpsoft.prettytime.natty.org.antlr.runtime.tree.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
extends org.ocpsoft.prettytime.natty.java.lang.Object {
    private TimeZone _defaultTimeZone;
    private static final Logger _logger = Logger.getLogger((String)"org.ocpsoft.prettytime.natty.com.joestelmach.natty");

    public Parser(TimeZone defaultTimeZone) {
        this._defaultTimeZone = defaultTimeZone;
    }

    public Parser() {
        this._defaultTimeZone = TimeZone.getDefault();
    }

    public List<DateGroup> parse(String value) {
        ANTLRNoCaseInputStream input = null;
        try {
            input = new ANTLRNoCaseInputStream((InputStream)new ByteArrayInputStream(value.trim().getBytes()));
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, (String)"org.ocpsoft.prettytime.natty.could not lex input", (Throwable)e);
        }
        DateLexer lexer = new DateLexer(input);
        List<TokenStream> streams = this.collectTokenStreams(new CommonTokenStream(lexer));
        ArrayList groups = new ArrayList();
        for (TokenStream stream : streams) {
            List tokens = ((NattyTokenSource)stream.getTokenSource()).getTokens();
            DateGroup group = this.singleParse(stream);
            while ((group == null || group.getDates().size() == 0) && tokens.size() > 0) {
                Token token;
                if (group != null && group.getDates().size() != 0) continue;
                if (tokens.size() <= 2) {
                    tokens.clear();
                    continue;
                }
                tokens = tokens.subList(2, tokens.size());
                Iterator iter = tokens.iterator();
                while (iter.hasNext() && !DateParser.FOLLOW_empty_in_parse181.member((token = (Token)iter.next()).getType())) {
                    iter.remove();
                }
                this.cleanupGroup((List<Token>)tokens);
                CommonTokenStream newStream = new CommonTokenStream(new NattyTokenSource((List<Token>)tokens));
                group = this.singleParse(newStream);
            }
            if (group == null || group.getDates().size() <= 0) continue;
            groups.add((org.ocpsoft.prettytime.natty.java.lang.Object)group);
        }
        return groups;
    }

    private DateGroup singleParse(TokenStream stream) {
        StringBuilder tokenString = new StringBuilder();
        for (Token token : ((NattyTokenSource)stream.getTokenSource()).getTokens()) {
            tokenString.append(DateParser.tokenNames[token.getType()]);
            tokenString.append((String)"org.ocpsoft.prettytime.natty. ");
        }
        _logger.fine(new StringBuilder().append((String)"org.ocpsoft.prettytime.natty.sub-token stream: ").append(tokenString.toString()).toString());
        DateGroup group = null;
        try {
            ParseListener listener = new ParseListener();
            DateParser parser = new DateParser(stream, listener);
            DateParser.parse_return parseReturn = parser.parse();
            Tree tree = (Tree)parseReturn.getTree();
            _logger.fine(new StringBuilder().append((String)"org.ocpsoft.prettytime.natty.AST: ").append(tree.toStringTree()).toString());
            if (tree.getChildCount() > 0) {
                CommonTreeNodeStream nodes = new CommonTreeNodeStream(tree);
                TreeRewrite s = new TreeRewrite(nodes);
                tree = (CommonTree)s.downup(tree);
                nodes = new CommonTreeNodeStream(tree);
                nodes.setTokenStream(stream);
                DateWalker walker = new DateWalker(nodes);
                walker.getState().setDefaultTimeZone(this._defaultTimeZone);
                walker.parse();
                group = walker.getState().getDateGroup();
                ParseLocation location = listener.getDateGroupLocation();
                group.setLine(location.getLine());
                group.setText(location.getText());
                group.setPosition(location.getStart());
                group.setSyntaxTree(tree);
                group.setParseLocations(listener.getLocations());
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, (String)"org.ocpsoft.prettytime.natty.Could not parse input", (Throwable)e);
        }
        return group;
    }

    private List<TokenStream> collectTokenStreams(TokenStream stream) {
        Token currentToken;
        ArrayList currentGroup = null;
        ArrayList groups = new ArrayList();
        StringBuilder tokenString = new StringBuilder();
        while ((currentToken = stream.getTokenSource().nextToken()).getType() != -1) {
            if (_logger.getLevel() != null && _logger.getLevel().intValue() <= Level.FINE.intValue()) {
                tokenString.append(DateParser.tokenNames[currentToken.getType()]);
                tokenString.append((String)"org.ocpsoft.prettytime.natty. ");
            }
            if (currentGroup == null) {
                if (currentToken.getType() == 241 || !DateParser.FOLLOW_empty_in_parse181.member(currentToken.getType())) continue;
                currentGroup = new ArrayList();
                currentGroup.add((org.ocpsoft.prettytime.natty.java.lang.Object)currentToken);
                continue;
            }
            if (currentToken.getType() == 241) {
                currentGroup.add((org.ocpsoft.prettytime.natty.java.lang.Object)currentToken);
                continue;
            }
            if (currentToken.getType() == 274) {
                if (currentGroup.size() > 0) {
                    this.cleanupGroup((List<Token>)currentGroup);
                    groups.add((org.ocpsoft.prettytime.natty.java.lang.Object)new CommonTokenStream(new NattyTokenSource((List<Token>)currentGroup)));
                }
                currentGroup = null;
                continue;
            }
            if (currentToken.getType() == 4) continue;
            currentGroup.add((org.ocpsoft.prettytime.natty.java.lang.Object)currentToken);
        }
        if (currentGroup != null) {
            this.cleanupGroup((List<Token>)currentGroup);
            groups.add((org.ocpsoft.prettytime.natty.java.lang.Object)new CommonTokenStream(new NattyTokenSource((List<Token>)currentGroup)));
        }
        _logger.fine(new StringBuilder().append((String)"org.ocpsoft.prettytime.natty.global token stream: ").append(tokenString.toString()).toString());
        return groups;
    }

    private void cleanupGroup(List<Token> group) {
        Token lastToken;
        Token firstToken;
        Iterator iter = group.iterator();
        Token previousToken = null;
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (previousToken != null && previousToken.getType() == 241 && token.getType() == 241) {
                iter.remove();
            }
            previousToken = token;
        }
        if (group.size() > 0 && (firstToken = (Token)group.get(0)).getType() == 241) {
            group.remove((org.ocpsoft.prettytime.natty.java.lang.Object)firstToken);
        }
        if (group.size() > 0 && (lastToken = (Token)group.get(group.size() - 1)).getType() == 241) {
            group.remove((org.ocpsoft.prettytime.natty.java.lang.Object)lastToken);
        }
    }
}

