/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.logging.slf4j;

import org.ocpsoft.logging.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JLogAdapter
extends Logger {
    private final org.slf4j.Logger delegate;

    public SLF4JLogAdapter(String name) {
        this.delegate = LoggerFactory.getLogger((String)name);
    }

    protected void log(Logger.Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                if (t == null) {
                    this.delegate.trace(msg);
                    break;
                }
                this.delegate.trace(msg, t);
                break;
            }
            case DEBUG: {
                if (t == null) {
                    this.delegate.debug(msg);
                    break;
                }
                this.delegate.debug(msg, t);
                break;
            }
            case INFO: {
                if (t == null) {
                    this.delegate.info(msg);
                    break;
                }
                this.delegate.info(msg, t);
                break;
            }
            case WARN: {
                if (t == null) {
                    this.delegate.warn(msg);
                    break;
                }
                this.delegate.warn(msg, t);
                break;
            }
            case ERROR: {
                if (t == null) {
                    this.delegate.error(msg);
                    break;
                }
                this.delegate.error(msg, t);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot handle log leve: " + level);
            }
        }
    }

    protected boolean isEnabled(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return this.delegate.isTraceEnabled();
            }
            case DEBUG: {
                return this.delegate.isDebugEnabled();
            }
            case INFO: {
                return this.delegate.isInfoEnabled();
            }
            case WARN: {
                return this.delegate.isWarnEnabled();
            }
            case ERROR: {
                return this.delegate.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException("Cannot handle log leve: " + level);
    }
}

