/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck.search;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.SortedSet;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.PlatformDescription;
import org.objenesis.tck.candidates.SerializableNoConstructor;
import org.objenesis.tck.search.ClassEnumerator;
import org.objenesis.tck.search.SearchWorkingInstantiatorListener;
import org.objenesis.tck.search.SystemOutListener;

public class SearchWorkingInstantiator
implements Serializable {
    private SearchWorkingInstantiatorListener listener;

    public static void main(String[] args) throws Exception {
        System.out.println();
        System.out.println(PlatformDescription.describePlatform());
        System.out.println();
        SearchWorkingInstantiator searchWorkingInstantiator = new SearchWorkingInstantiator(new SystemOutListener());
        searchWorkingInstantiator.searchForInstantiator(SerializableNoConstructor.class);
    }

    public SearchWorkingInstantiator(SearchWorkingInstantiatorListener listener) {
        this.listener = listener;
    }

    public void searchForInstantiator(Class<?> toInstantiate) {
        SortedSet<String> classes = ClassEnumerator.getClassesForPackage(ObjectInstantiator.class.getPackage());
        for (String className : classes) {
            Constructor<?> constructor;
            if (className.contains("$") || !className.endsWith("Instantiator")) continue;
            Class<?> c = null;
            try {
                c = Class.forName(className);
            }
            catch (Exception e) {
                this.listener.instantiatorUnsupported(c, e);
                continue;
            }
            if (c.isInterface() || !ObjectInstantiator.class.isAssignableFrom(c)) continue;
            try {
                constructor = c.getConstructor(Class.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            try {
                ObjectInstantiator instantiator = (ObjectInstantiator)constructor.newInstance(toInstantiate);
                instantiator.newInstance();
                this.listener.instantiatorSupported(c);
            }
            catch (Exception e) {
                Throwable t = e instanceof InvocationTargetException ? e.getCause() : e;
                this.listener.instantiatorUnsupported(c, t);
            }
        }
    }
}

