/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.objenesis.Objenesis;
import org.objenesis.tck.Candidate;
import org.objenesis.tck.Reporter;

public class TextReporter
implements Reporter {
    private final PrintStream summary;
    private final PrintStream log;
    private long startTime;
    private int errorCount;
    private Objenesis objenesisStandard;
    private Objenesis objenesisSerializer;
    private Candidate currentCandidate;
    private final Map<Candidate, Map<Candidate.CandidateType, Result>> results = new TreeMap<Candidate, Map<Candidate.CandidateType, Result>>();
    private String platformDescription;

    public TextReporter(PrintStream summary, PrintStream log) {
        this.summary = summary;
        this.log = log;
    }

    @Override
    public void startTests(String platformDescription, Objenesis objenesisStandard, Objenesis objenesisSerializer) {
        this.platformDescription = platformDescription;
        this.objenesisStandard = objenesisStandard;
        this.objenesisSerializer = objenesisSerializer;
        this.currentCandidate = null;
        this.errorCount = 0;
        this.results.clear();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void startTest(Candidate candidate) {
        this.currentCandidate = candidate;
    }

    @Override
    public void result(Candidate.CandidateType type, boolean success) {
        this.addResult(type, success, null);
    }

    @Override
    public void exception(Candidate.CandidateType type, Exception exception) {
        this.addResult(type, false, exception);
    }

    private void addResult(Candidate.CandidateType type, boolean success, Exception exception) {
        Map<Candidate.CandidateType, Result> result;
        if (!success) {
            ++this.errorCount;
        }
        if ((result = this.results.get(this.currentCandidate)) == null) {
            result = new HashMap<Candidate.CandidateType, Result>();
            this.results.put(this.currentCandidate, result);
        }
        result.put(type, new Result(this.currentCandidate, type, success, exception));
    }

    @Override
    public void endTests() {
        long totalTime = System.currentTimeMillis() - this.startTime;
        this.printResult(totalTime);
    }

    private void printResult(long totalTime) {
        this.summary.println("Running TCK on platform: " + this.platformDescription);
        this.summary.println();
        this.summary.println("Instantiators used: ");
        this.summary.println("   Objenesis standard  : " + this.objenesisStandard.getInstantiatorOf(String.class).getClass().getName());
        this.summary.println("   Objenesis serializer: " + this.objenesisSerializer.getInstantiatorOf(String.class).getClass().getName());
        this.summary.println();
        ArrayList<String> candidateNames = new ArrayList<String>();
        for (Map.Entry<Candidate, Map<Candidate.CandidateType, Result>> entry : this.results.entrySet()) {
            candidateNames.add(entry.getKey().getDescription());
        }
        int maxObjenesisWidth = "Objenesis serializer".length();
        int maxCandidateWidth = this.lengthOfLongestStringIn(candidateNames);
        this.summary.print(this.pad("", maxCandidateWidth) + ' ');
        this.summary.print(this.pad("Objenesis standard", maxObjenesisWidth) + ' ');
        this.summary.print(this.pad("Objenesis serializer", maxObjenesisWidth));
        this.summary.println();
        ArrayList<Result> exceptions = new ArrayList<Result>();
        for (Map.Entry<Candidate, Map<Candidate.CandidateType, Result>> entry : this.results.entrySet()) {
            this.summary.print(this.pad(entry.getKey().getDescription(), maxCandidateWidth) + ' ');
            Result standardResult = entry.getValue().get((Object)Candidate.CandidateType.STANDARD);
            Result serializationResult = entry.getValue().get((Object)Candidate.CandidateType.SERIALIZATION);
            if (standardResult == null && serializationResult == null) continue;
            if (standardResult == null) {
                this.summary.print(this.pad("N/A", maxObjenesisWidth) + " ");
            } else {
                this.summary.print(this.pad(standardResult.result ? "Y" : "n", maxObjenesisWidth) + " ");
                if (standardResult.exception != null) {
                    exceptions.add(standardResult);
                }
            }
            if (serializationResult == null) {
                this.summary.print(this.pad("N/A", maxObjenesisWidth));
            } else {
                this.summary.print(this.pad(serializationResult.result ? "Y" : "n", maxObjenesisWidth));
                if (serializationResult.exception != null) {
                    exceptions.add(serializationResult);
                }
            }
            this.summary.println();
        }
        this.summary.println();
        if (this.errorCount != 0) {
            for (Result element : exceptions) {
                this.log.println("--- Candidate '" + element.candidate.getDescription() + "', Type '" + (Object)((Object)element.type) + "' ---");
                element.exception.printStackTrace(this.log);
                this.log.println();
            }
            this.log.println();
            this.summary.println("--- FAILED: " + this.errorCount + " error(s) occurred ---");
        } else {
            this.summary.println("--- SUCCESSFUL: TCK tests passed without errors in " + totalTime + " ms");
        }
        this.summary.println();
    }

    public boolean hasErrors() {
        return this.errorCount != 0;
    }

    private String pad(String text, int width) {
        if (text.length() == width) {
            return text;
        }
        if (text.length() > width) {
            return text.substring(0, width);
        }
        StringBuilder padded = new StringBuilder(text);
        while (padded.length() < width) {
            padded.append(' ');
        }
        return padded.toString();
    }

    private int lengthOfLongestStringIn(Collection<String> descriptions) {
        int result = 0;
        for (String s : descriptions) {
            result = Math.max(result, s.length());
        }
        return result;
    }

    private static class Result {
        Candidate candidate;
        Candidate.CandidateType type;
        boolean result;
        Exception exception;

        public Result(Candidate candidate, Candidate.CandidateType type, boolean result, Exception exception) {
            this.candidate = candidate;
            this.type = type;
            this.result = result;
            this.exception = exception;
        }
    }
}

