/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.objenesis.Objenesis;
import org.objenesis.tck.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReporter
implements Reporter {
    private final PrintStream summary;
    private final PrintStream log;
    private long startTime;
    private long totalTime = 0L;
    private int errorCount = 0;
    private SortedMap<String, Object> allCandidates = new TreeMap<String, Object>();
    private SortedMap<String, Object> allInstantiators = new TreeMap<String, Object>();
    private String currentObjenesis;
    private String currentCandidate;
    private Map<Object, Map<String, Result>> objenesisResults = new HashMap<Object, Map<String, Result>>();
    private String platformDescription;

    public TextReporter(PrintStream summary, PrintStream log) {
        this.summary = summary;
        this.log = log;
    }

    @Override
    public void startTests(String platformDescription, Map<String, Object> allCandidates, Map<String, Object> allInstantiators) {
        this.platformDescription = platformDescription;
        this.allCandidates.putAll(allCandidates);
        this.allInstantiators.putAll(allInstantiators);
        for (String desc : allInstantiators.keySet()) {
            this.objenesisResults.put(desc, new HashMap());
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void startTest(String candidateDescription, String objenesisDescription) {
        this.currentCandidate = candidateDescription;
        this.currentObjenesis = objenesisDescription;
    }

    @Override
    public void result(boolean instantiatedObject) {
        if (!instantiatedObject) {
            ++this.errorCount;
        }
        this.objenesisResults.get(this.currentObjenesis).put(this.currentCandidate, new Result(this.currentObjenesis, this.currentCandidate, instantiatedObject, null));
    }

    @Override
    public void exception(Exception exception) {
        ++this.errorCount;
        this.objenesisResults.get(this.currentObjenesis).put(this.currentCandidate, new Result(this.currentObjenesis, this.currentCandidate, false, exception));
    }

    @Override
    public void endTest() {
    }

    @Override
    public void endTests() {
        this.totalTime += System.currentTimeMillis() - this.startTime;
    }

    public void printResult(boolean parentConstructorTest) {
        this.summary.println("Running TCK on platform: " + this.platformDescription);
        this.summary.println();
        this.summary.println("Instantiators used: ");
        for (Map.Entry<String, Object> o : this.allInstantiators.entrySet()) {
            String inst = ((Objenesis)o.getValue()).getInstantiatorOf(String.class).getClass().getSimpleName();
            this.summary.println("   " + o.getKey() + ": " + inst);
        }
        this.summary.println();
        this.summary.println("Not serializable parent constructor called as expected: " + (parentConstructorTest ? (char)'Y' : 'N'));
        this.summary.println();
        if (!parentConstructorTest) {
            ++this.errorCount;
        }
        Set<String> instantiators = this.allInstantiators.keySet();
        Set<String> candidates = this.allCandidates.keySet();
        int maxObjenesisWidth = this.lengthOfLongestStringIn(instantiators);
        int maxCandidateWidth = this.lengthOfLongestStringIn(candidates);
        this.summary.print(this.pad("", maxCandidateWidth) + ' ');
        for (String desc : instantiators) {
            this.summary.print(this.pad(desc, maxObjenesisWidth) + ' ');
        }
        this.summary.println();
        ArrayList<Result> exceptions = new ArrayList<Result>();
        for (String candidateDesc : candidates) {
            this.summary.print(this.pad(candidateDesc, maxCandidateWidth) + ' ');
            for (String instDesc : instantiators) {
                Result result = this.objenesisResults.get(instDesc).get(candidateDesc);
                if (result == null) {
                    this.summary.print(this.pad("N/A", maxObjenesisWidth) + " ");
                    continue;
                }
                this.summary.print(this.pad(result.result ? "Y" : "n", maxObjenesisWidth) + " ");
                if (result.exception == null) continue;
                exceptions.add(result);
            }
            this.summary.println();
        }
        this.summary.println();
        if (this.errorCount != 0) {
            for (Result element : exceptions) {
                this.log.println("--- Candidate '" + element.candidateDescription + "', Instantiator '" + element.objenesisDescription + "' ---");
                element.exception.printStackTrace(this.log);
                this.log.println();
            }
            this.log.println();
            this.summary.println("--- FAILED: " + this.errorCount + " error(s) occured ---");
        } else {
            this.summary.println("--- SUCCESSFUL: TCK tests passed without errors in " + this.totalTime + " ms");
        }
        this.summary.println();
    }

    public boolean hasErrors() {
        return this.errorCount != 0;
    }

    private String pad(String text, int width) {
        if (text.length() == width) {
            return text;
        }
        if (text.length() > width) {
            return text.substring(0, width);
        }
        StringBuilder padded = new StringBuilder(text);
        while (padded.length() < width) {
            padded.append(' ');
        }
        return padded.toString();
    }

    private int lengthOfLongestStringIn(Collection<String> descriptions) {
        int result = 0;
        Iterator<String> it = descriptions.iterator();
        while (it.hasNext()) {
            result = Math.max(result, it.next().length());
        }
        return result;
    }

    private static class Result {
        String objenesisDescription;
        String candidateDescription;
        boolean result;
        Exception exception;

        public Result(String objenesisDescription, String candidateDescription, boolean result, Exception exception) {
            this.objenesisDescription = objenesisDescription;
            this.candidateDescription = candidateDescription;
            this.result = result;
            this.exception = exception;
        }
    }
}

