/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.io.IOException;
import java.io.Serializable;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisSerializer;
import org.objenesis.ObjenesisStd;
import org.objenesis.tck.CandidateLoader;
import org.objenesis.tck.Reporter;
import org.objenesis.tck.TCK;
import org.objenesis.tck.TextReporter;

public class Main {
    public static void main(String[] args) throws IOException {
        TextReporter reporter = new TextReporter(System.out, System.err);
        boolean result = Main.run(reporter);
        reporter.printResult(result);
        if (reporter.hasErrors()) {
            System.exit(1);
        }
    }

    public static boolean run(Reporter reporter) {
        Main.runStandardTest(new ObjenesisStd(), reporter);
        Main.runSerializerTest(new ObjenesisSerializer(), reporter);
        boolean result = Main.runParentConstructorTest(new ObjenesisSerializer());
        return result;
    }

    public static void runSerializerTest(Objenesis objenesis, Reporter reporter) {
        Main.runTest(objenesis, reporter, "Objenesis serializer", "candidates/serializable-candidates.properties");
    }

    public static void runStandardTest(Objenesis objenesis, Reporter reporter) {
        Main.runTest(objenesis, reporter, "Objenesis std", "candidates/candidates.properties");
    }

    public static boolean runParentConstructorTest(Objenesis objenesis) {
        try {
            MockClass result;
            MockClass mockObject = result = objenesis.newInstance(MockClass.class);
            return mockObject.isSuperConstructorCalled() && !mockObject.isConstructorCalled();
        }
        catch (Exception e) {
            System.err.println("--- Not serializable parent constructor called ---");
            e.printStackTrace(System.err);
            return false;
        }
    }

    public static void runTest(Objenesis objenesis, Reporter reporter, String description, String candidates) {
        TCK tck = new TCK();
        tck.registerObjenesisInstance(objenesis, description);
        CandidateLoader candidateLoader = new CandidateLoader(tck, Main.class.getClassLoader(), new CandidateLoader.LoggingErrorHandler(System.err));
        try {
            candidateLoader.loadFromResource(Main.class, candidates);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        tck.runTests(reporter);
    }

    private static class MockClass
    extends MockSuperClass
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean constructorCalled;

        public MockClass() {
            this.constructorCalled = true;
        }

        public boolean isConstructorCalled() {
            return this.constructorCalled;
        }
    }

    private static class MockSuperClass {
        private final boolean superConstructorCalled;

        public MockSuperClass() {
            this.superConstructorCalled = true;
        }

        public boolean isSuperConstructorCalled() {
            return this.superConstructorCalled;
        }
    }
}

