/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objenesis.Objenesis;
import org.objenesis.strategy.PlatformDescription;
import org.objenesis.tck.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCK {
    private final List<Objenesis> objenesisInstances = new ArrayList<Objenesis>();
    private final List<Class<?>> candidates = new ArrayList();
    private final Map<Object, String> descriptions = new HashMap<Object, String>();

    public void registerCandidate(Class<?> candidateClass, String description) {
        this.candidates.add(candidateClass);
        this.descriptions.put(candidateClass, description);
    }

    public void registerObjenesisInstance(Objenesis objenesis, String description) {
        this.objenesisInstances.add(objenesis);
        this.descriptions.put(objenesis, description);
    }

    public void runTests(Reporter reporter) {
        reporter.startTests(this.describePlatform(), this.findAllDescriptions(this.candidates, this.descriptions), this.findAllDescriptions(this.objenesisInstances, this.descriptions));
        for (Class<?> candidateClass : this.candidates) {
            String candidateDescription = this.descriptions.get(candidateClass);
            for (Objenesis objenesis : this.objenesisInstances) {
                String objenesisDescription = this.descriptions.get(objenesis);
                reporter.startTest(candidateDescription, objenesisDescription);
                this.runTest(reporter, candidateClass, objenesis);
                reporter.endTest();
            }
        }
        reporter.endTests();
    }

    private void runTest(Reporter reporter, Class<?> candidate, Objenesis objenesis) {
        try {
            Object instance = objenesis.newInstance(candidate);
            boolean success = instance != null && instance.getClass() == candidate;
            reporter.result(success);
        }
        catch (Exception e) {
            reporter.exception(e);
        }
    }

    private Collection<String> findAllDescriptions(List<?> keys, Map<?, String> descriptions) {
        ArrayList<String> results = new ArrayList<String>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            results.add(descriptions.get(keys.get(i)));
        }
        return results;
    }

    protected String describePlatform() {
        return "Java " + PlatformDescription.SPECIFICATION_VERSION + " (" + "vendor=\"" + PlatformDescription.VENDOR + "\", " + "vendor version=" + PlatformDescription.VENDOR_VERSION + ", " + "JVM name=\"" + PlatformDescription.JVM_NAME + "\", " + "JVM version=" + PlatformDescription.VM_VERSION + ", " + "JVM info=" + PlatformDescription.VM_VERSION + ")";
    }
}

