/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.io.IOException;
import java.io.Serializable;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisSerializer;
import org.objenesis.ObjenesisStd;
import org.objenesis.tck.CandidateLoader;
import org.objenesis.tck.Reporter;
import org.objenesis.tck.TCK;
import org.objenesis.tck.TextReporter;

public class Main {
    public static void main(String[] args) throws IOException {
        TextReporter reporter = new TextReporter(System.out, System.err);
        Main.runTest(new ObjenesisStd(), reporter, "Objenesis std", "candidates/candidates.properties");
        Main.runTest(new ObjenesisSerializer(), reporter, "Objenesis serializer", "candidates/serializable-candidates.properties");
        boolean result = Main.runParentConstructorTest();
        reporter.printResult(result);
    }

    private static boolean runParentConstructorTest() {
        try {
            MockClass result;
            MockClass mockObject = result = new ObjenesisSerializer().newInstance(MockClass.class);
            return mockObject.isSuperConstructorCalled() && !mockObject.isConstructorCalled();
        }
        catch (Exception e) {
            System.err.println("--- Not serializable parent constructor called ---");
            e.printStackTrace(System.err);
            return false;
        }
    }

    private static void runTest(Objenesis objenesis, Reporter reporter, String description, String candidates) throws IOException {
        TCK tck = new TCK();
        tck.registerObjenesisInstance(objenesis, description);
        CandidateLoader candidateLoader = new CandidateLoader(tck, Main.class.getClassLoader(), new CandidateLoader.LoggingErrorHandler(System.err));
        candidateLoader.loadFromResource(Main.class, candidates);
        tck.runTests(reporter);
    }

    private static class MockClass
    extends MockSuperClass
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean constructorCalled;

        public MockClass() {
            this.constructorCalled = true;
        }

        public boolean isConstructorCalled() {
            return this.constructorCalled;
        }
    }

    private static class MockSuperClass {
        private final boolean superConstructorCalled;

        public MockSuperClass() {
            this.superConstructorCalled = true;
        }

        public boolean isSuperConstructorCalled() {
            return this.superConstructorCalled;
        }
    }
}

