/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.objenesis.tck.TCK;

public class CandidateLoader {
    private final TCK tck;
    private final ClassLoader classloader;
    private final ErrorHandler errorHandler;

    public CandidateLoader(TCK tck, ClassLoader classloader, ErrorHandler errorHandler) {
        this.tck = tck;
        this.classloader = classloader;
        this.errorHandler = errorHandler;
    }

    public void loadFrom(InputStream inputStream) throws IOException {
        Properties properties = new Properties(){
            private static final long serialVersionUID = 1L;

            public Object put(Object key, Object value) {
                CandidateLoader.this.handlePropertyEntry((String)key, (String)value);
                return null;
            }
        };
        properties.load(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromResource(Class cls, String resource) throws IOException {
        InputStream candidatesConfig = cls.getResourceAsStream(resource);
        if (candidatesConfig == null) {
            throw new IOException("Resource '" + resource + "' not found relative to " + cls.getName());
        }
        try {
            this.loadFrom(candidatesConfig);
        }
        finally {
            candidatesConfig.close();
        }
    }

    private void handlePropertyEntry(String key, String value) {
        try {
            Class<?> candidate = Class.forName(key, true, this.classloader);
            this.tck.registerCandidate(candidate, value);
        }
        catch (ClassNotFoundException e) {
            this.errorHandler.classNotFound(key);
        }
    }

    public static class LoggingErrorHandler
    implements ErrorHandler {
        private final PrintStream out;

        public LoggingErrorHandler(PrintStream out) {
            this.out = out;
        }

        public void classNotFound(String name) {
            this.out.println("Class not found : " + name);
        }
    }

    public static interface ErrorHandler {
        public void classNotFound(String var1);
    }
}

