/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jonas.discovery.internal.manager;

import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.objectweb.jonas.common.Log;
import org.objectweb.jonas.discovery.internal.DuplicateServerNameException;
import org.objectweb.jonas.discovery.internal.comm.DiscoveryComm;
import org.objectweb.jonas.discovery.internal.comm.DiscoveryGreetingListener;
import org.objectweb.jonas.discovery.internal.comm.DiscoveryGreetingResponder;
import org.objectweb.jonas.discovery.internal.manager.DiscoveryManagerMBean;
import org.objectweb.jonas.jmx.oname.J2eeObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DiscoveryManager
implements DiscoveryManagerMBean,
MBeanRegistration,
NotificationListener {
    private static Logger logger = Log.getLogger((String)"org.objectweb.jonas.discovery");
    private int greetingListeningPort;
    private int listeningPort;
    private String listeningIp;
    private DiscoveryComm dc;
    private DiscoveryGreetingResponder dgr;
    private DiscoveryGreetingListener dgl;
    private Thread commDaemon;
    private Thread discoveryGreetingListenerThread;
    private MBeanServer mbeanServer;
    private ObjectName myOn;
    private int ttl = 1;
    private int greetingAckTimeOut;
    private String jonasName = null;
    private String domainName = null;
    private String serverId = null;
    private String[] urls = null;

    public DiscoveryManager(String serverId, int listeningPort, String listeningIp, int greetingListeningPort, int greetingAckTimeOut) {
        this.serverId = serverId;
        this.listeningIp = listeningIp;
        this.listeningPort = listeningPort;
        this.greetingListeningPort = greetingListeningPort;
        this.greetingAckTimeOut = greetingAckTimeOut;
    }

    public void start() {
        this.dgl = new DiscoveryGreetingListener(this);
        this.dgr = new DiscoveryGreetingResponder(this);
        if (this.discoveryGreetingListenerThread == null) {
            this.discoveryGreetingListenerThread = new Thread((Runnable)this.dgl, "GreetingListener");
        }
        this.discoveryGreetingListenerThread.start();
        try {
            this.dgr.handleGreeting();
        }
        catch (DuplicateServerNameException e) {
            logger.log(BasicLevel.ERROR, (Object)"Discovery manager failed to start due to a pre-existing server in the domain with the same ID.", (Throwable)((Object)e));
            throw e;
        }
        this.dc = new DiscoveryComm(this);
        if (this.commDaemon == null) {
            this.commDaemon = new Thread((Runnable)this.dc, "commDaemon");
        }
        this.commDaemon.start();
    }

    public int getGreetingAckTimeOut() {
        return this.greetingAckTimeOut;
    }

    public void setGreetingAckTimeOut(int greetingAckTimeOut) {
        this.greetingAckTimeOut = greetingAckTimeOut;
    }

    public int getGreetingListeningPort() {
        return this.greetingListeningPort;
    }

    public void setGreetingListeningPort(int greetingListeningPort) {
        this.greetingListeningPort = greetingListeningPort;
    }

    public int getListeningPort() {
        return this.listeningPort;
    }

    public void setListeningPort(int listeningPort) {
        this.listeningPort = listeningPort;
    }

    public String getListeningIp() {
        return this.listeningIp;
    }

    public void setListeningIp(String listeningIp) {
        this.listeningIp = listeningIp;
    }

    public void setTimeToLive(int ttl) {
        this.ttl = ttl;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public ObjectName preRegister(MBeanServer mbeanServer, ObjectName on) throws Exception {
        this.mbeanServer = mbeanServer;
        this.myOn = on;
        return this.myOn;
    }

    public void postRegister(Boolean arg0) {
        try {
            ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.mbeanServer.addNotificationListener(delegate, this, null, null);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    public void handleNotification(Notification notification, Object handback) {
        ObjectName j2eeServerName;
        ObjectName notificationSender;
        if (notification.getType().equals("JMX.mbean.unregistered") && (notificationSender = ((MBeanServerNotification)notification).getMBeanName()).equals(j2eeServerName = J2eeObjectName.J2EEServer((String)this.domainName, (String)this.jonasName)) && this.dc != null) {
            this.dc.stop();
        }
    }

    public String getJonasName() {
        return this.jonasName;
    }

    public void setJonasName(String jonasName) {
        this.jonasName = jonasName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainNamle) {
        this.domainName = domainNamle;
    }

    public String[] getUrls() {
        return this.urls;
    }

    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    public void stop() {
        if (this.dc != null) {
            this.dc.stop();
        }
        this.dgl.stop();
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }
}

