/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2005-2007 Bull S.A.S.
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or any later
 * version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * --------------------------------------------------------------------------
 * $Id: DiscGreeting.java 10761 2007-06-27 08:38:39Z danesa $
 * --------------------------------------------------------------------------
 */

package org.objectweb.jonas.discovery.internal.comm.message;

import org.objectweb.jonas.discovery.DiscoveryState;

/**
 * This class represents a special greeting message which has two uses:
 * 1) To act as a broadcast to the domain that a new server with a given
 * server name has started. It also includes a port that the server will
 * listen to objections at, the domain name and state set to STARTUP.
 * 2) To inform the newly started server that server name is already in use
 * by another server.
 *
 * @author Vivek Lakshmanan
 * @version 1.0
 */
public class DiscGreeting extends DiscMessage {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    private String state = null;

    /**
     *
     */
    private String serverName = null;

    /**
     *
     */
    private String domainName = null;

    /**
     *
     */
    private String serverId = null;

    /**
     * @param sourceAddress
     * @param sourcePort
     */
    public DiscGreeting(String sourceAddress, int sourcePort) {
        super(sourceAddress, sourcePort);
    }

    /**
     * Constructor for a Discovery Greeting.
     * @param sourceAddress
     *          the host address to use to receive a response.
     * @param sourcePort
     *          is the port used in the case of a point to point response.
     * @param serverName
     *          is Jonas server name.
     * @param domainName
     *          is Jonas domain name.
     * @param startingUp
     *          is this server starting up or is it reporting back with a
     *          notification stating that it owns this server name?
     * @param serverId TODO
     */
    public DiscGreeting(String sourceAddress, int sourcePort,
            String serverName, String domainName, boolean startingUp,
            String serverId) {
        super(sourceAddress, sourcePort);
        this.serverName = serverName;
        this.domainName = domainName;
        this.serverId = serverId;

        if (startingUp) {
            this.state = DiscoveryState.STARTUP;
        } else {
            this.state = DiscoveryState.DUPLICATE_NAME;
        }

    }

    /**
     * returns server name.
     *
     * @return serverName
     */
    public String getServerName() {
        return serverName;
    }

    /**
     * returns domain name.
     *
     * @return domain name.
     */
    public String getDomainName() {
        return domainName;
    }

    /**
     * sets the domain name.
     *
     * @param domainName the management domain name
     */
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    /**
     * sets the serverName.
     *
     * @param serverName the name of the server sending the discovery greeting
     */
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    /**
     * @return server state.
     */
    public String getState() {
        return state;
    }

    /**
     * sets the server state : STARTINGUP or DUPLICATE_NAME.
     *
     * @param state state of the server sending the discovery greeting, one of DiscGreeting.STARTUP or DiscGreeting.DUPLICATE_NAME
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * The string version of the message.
     * @return the message
     */
    public String toString() {
        String str = super.toString() + " State="
        + state + " DomainName=" + domainName + " ServerName= " + serverName + " serverId= " + serverId;
        return str;

    }
    /**
     *
     * @return serverId
     */
    public String getServerId() {
        return serverId;
    }

    /**
     * Set the serverId.
     * @param serverId value of the serverId to set
     */
    public void setServerId(String serverId) {
        this.serverId = serverId;
    }
}
