/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2004-2007 Bull S.A.S.
 * Contact: jonas-team@objectweb.org
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or any later
 * version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * --------------------------------------------------------------------------
 * $Id: DiscEvent.java 10761 2007-06-27 08:38:39Z danesa $
 * --------------------------------------------------------------------------
 */

package org.objectweb.jonas.discovery.internal.comm.message;

import org.objectweb.jonas.discovery.DiscoveryEvent;


/**
 * @author <a href="mailto:Takoua.Abdellatif@inria.fr">Takoua Abdellatif </a>
 * @author Adriana Danes
 * @version 1.0
 */
public class DiscEvent extends DiscMessage implements DiscoveryEvent {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    private String serverName = null;

    /**
     *
     */
    private String domainName = null;

    /**
    *
    */
    private String state = null;

    /**
     *
     */
    private String serverId = null;


    /**
     *
     */
    private String[] urls = null;

    /**
     * @param sourceAddress
     * @param sourcePort
     * @param serverId The serverId for this server.
     */
    public DiscEvent(final String sourceAddress, final int sourcePort, final String serverId) {
        super(sourceAddress, sourcePort);
    }

    /**
     * Constructor for a Discovery Event.
     * @param sourceAddress
     *          the host address to use to receive a response.
     * @param sourcePort
     *          is the port used in the case of a point to point response.
     * @param serverName
     *          is Jonas server name.
     * @param domainName
     *          is Jonas domain name.
     * @param serverId TODO
     * @param connectorURLs
     *          contains the list of all connector urls registered in the mbean
     *          server.
     */
    public DiscEvent(String sourceAddress, int sourcePort, String serverName,
            String domainName, String serverId, String[] connectorURLs) {
        super(sourceAddress, sourcePort);
        this.serverName = serverName;
        this.domainName = domainName;
        this.serverId = serverId;
        this.urls = connectorURLs;
    }

    /**
     * returns server name.
     *
     * @return serverName
     */
    public String getServerName() {
        return serverName;
    }

    /**
     * returns domain name.
     *
     * @return domain name.
     */
    public String getDomainName() {
        return domainName;
    }

    /**
     * sets the domain name.
     *
     * @param domainName the management domain name
     */
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    /**
     * sets the serverName.
     *
     * @param serverName the name of the server sending the discovery event
     */
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    /**
     * @return the connector URLs of the server sending the discovery event
     */
    public String[] getConnectorURL() {
        return urls;
    }

    /**
     * @param connectorURLs the connector URLs of the server sending the discovery event
     */
    public void setConnectorURL(String[] connectorURLs) {
        this.urls = connectorURLs;
    }

    /**
     * @return server state.
     */
    public String getState() {
        return state;
    }

    /**
     * sets the server state : RUNNING or STOPPING.
     *
     * @param state state of the server sending the discovery event
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * The string version of the message.
     * @return the message
     */
    public String toString() {
        String str = super.toString()
        + " State=" + state
        + " DomainName=" + domainName
        + " ServerName= " + serverName
        + " Serverid = " + serverId;
        if (urls != null) {
            str = str + " URLs= ";
            for (int i = 0; i < urls.length; i++) {
                str = str + urls[i] + " ";
            }
        }
        return str;

    }

    public String getServerId() {
        return serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

}