/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.nutz.qrcode.QRCodeFormat;

public final class QRCode {
    private QRCodeFormat format = null;
    private BufferedImage qrcodeImage = null;
    private File qrcodeFile = null;

    public BufferedImage getQrcodeImage() {
        return this.qrcodeImage;
    }

    public File getQrcodeFile() {
        return this.qrcodeFile;
    }

    private QRCode() {
    }

    public static QRCode NEW(String content) {
        return QRCode.NEW(content, QRCodeFormat.NEW());
    }

    public static QRCode NEW(String content, QRCodeFormat format) {
        QRCode qrcode = new QRCode();
        qrcode.format = format;
        qrcode.qrcodeImage = QRCode.toQRCode(content, format);
        return qrcode;
    }

    public QRCode toFile(String f) {
        return this.toFile(new File(f), this.format.getIcon());
    }

    public QRCode toFile(File qrcodeFile) {
        return this.toFile(qrcodeFile, this.format.getIcon());
    }

    public QRCode toFile(String qrcodeFile, String appendFile) {
        if (null == appendFile || appendFile.length() == 0) {
            return this.toFile(new File(qrcodeFile));
        }
        return this.toFile(new File(qrcodeFile), new File(appendFile));
    }

    public QRCode toFile(File qrcodeFile, File appendFile) {
        try {
            if (!qrcodeFile.exists()) {
                qrcodeFile.getParentFile().mkdirs();
                qrcodeFile.createNewFile();
            }
            if (null != appendFile && appendFile.isFile() && appendFile.length() != 0L) {
                this.appendImage(ImageIO.read(appendFile));
            }
            if (!ImageIO.write((RenderedImage)this.qrcodeImage, this.getSuffixName(qrcodeFile), qrcodeFile)) {
                throw new RuntimeException("Unexpected error writing image");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.qrcodeFile = qrcodeFile;
        return this;
    }

    private void appendImage(BufferedImage appendImage) {
        int maxWidth;
        int baseWidth = this.qrcodeImage.getWidth();
        int baseHeight = this.qrcodeImage.getHeight();
        int maxHeight = maxWidth = (int)Math.sqrt((double)(baseWidth * baseHeight) * this.format.getErrorCorrectionLevelValue() * 0.4);
        int roundRectWidth = maxWidth < appendImage.getWidth() ? maxWidth : appendImage.getWidth();
        int roundRectHeight = maxHeight < appendImage.getHeight() ? maxHeight : appendImage.getWidth();
        BufferedImage roundRect = new BufferedImage(roundRectWidth, roundRectHeight, 2);
        Graphics2D g2 = roundRect.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRoundRect(0, 0, roundRectWidth, roundRectHeight, 27, 27);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage(appendImage, 0, 0, roundRectWidth, roundRectHeight, null);
        g2.dispose();
        Graphics gc = this.qrcodeImage.getGraphics();
        gc.setColor(this.format.getBackGroundColor());
        gc.drawImage(roundRect, (baseWidth - roundRectWidth) / 2, (baseHeight - roundRectHeight) / 2, null);
        gc.dispose();
    }

    public static BufferedImage toQRCode(String content) {
        return QRCode.toQRCode(content, null);
    }

    public static BufferedImage toQRCode(String content, QRCodeFormat format) {
        if (format == null) {
            format = QRCodeFormat.NEW();
        }
        content = new String(content.getBytes(Charset.forName(format.getEncode())));
        BitMatrix matrix = null;
        try {
            matrix = new QRCodeWriter().encode(content, BarcodeFormat.QR_CODE, format.getSize(), format.getSize(), format.getHints());
        }
        catch (WriterException e) {
            throw new RuntimeException(e);
        }
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int fgColor = format.getForeGroundColor().getRGB();
        int bgColor = format.getBackGroundColor().getRGB();
        BufferedImage image = new BufferedImage(width, height, 5);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? fgColor : bgColor);
            }
        }
        return image;
    }

    public static String from(String qrcodeFile) {
        if (qrcodeFile.startsWith("http://") || qrcodeFile.startsWith("https://")) {
            try {
                return QRCode.from(new URL(qrcodeFile));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return QRCode.from(new File(qrcodeFile));
    }

    public static String from(File qrcodeFile) {
        try {
            BufferedImage image = ImageIO.read(qrcodeFile);
            return QRCode.from(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String from(URL qrcodeUrl) {
        try {
            BufferedImage image = ImageIO.read(qrcodeUrl);
            return QRCode.from(image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String from(BufferedImage qrcodeImage) {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(qrcodeImage);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        String content = null;
        try {
            Result result = new QRCodeReader().decode(bitmap);
            content = result.getText();
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (ChecksumException e) {
            throw new RuntimeException(e);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return content;
    }

    private String getSuffixName(File file) {
        String path = file.getAbsolutePath();
        if (null == path) {
            return this.format.getImageFormat();
        }
        int pos = path.lastIndexOf(46);
        if (-1 == pos) {
            return this.format.getImageFormat();
        }
        return path.substring(pos + 1).toUpperCase();
    }
}

