/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.Properties;
import org.noear.solon.core.util.Assert;

public class PropUtil {
    public static String[] expSplit(String expr) {
        if (expr.length() > 2 && expr.charAt(0) == '$' && expr.charAt(1) == '{' && expr.charAt(expr.length() - 1) == '}') {
            expr = expr.substring(2, expr.length() - 1);
        }
        String def = null;
        int defIdx = expr.indexOf(58);
        if (defIdx > 0) {
            def = expr.length() > defIdx + 1 ? expr.substring(defIdx + 1).trim() : "";
            expr = expr.substring(0, defIdx).trim();
        }
        return new String[]{expr, def};
    }

    public static String getByExp(Properties main, Properties target, String expr, String refKey) {
        return PropUtil.getByExp(main, target, expr, refKey, true);
    }

    public static String getByExp(Properties main, Properties target, String expr, String refKey, boolean useDef) {
        int refIdx;
        String[] nameAndDef = PropUtil.expSplit(expr);
        String name = nameAndDef[0];
        if (Assert.isEmpty(name)) {
            return nameAndDef[1];
        }
        if (name.indexOf(46) == 0 && refKey != null && (refIdx = refKey.lastIndexOf(46)) > 0) {
            name = refKey.substring(0, refIdx) + name;
        }
        String val = null;
        if (target != null) {
            val = target.getProperty(name);
        }
        if (val == null) {
            if (main != null) {
                val = main.getProperty(name);
            }
            if (val == null) {
                val = System.getenv(name);
            }
        }
        if (val == null) {
            if (useDef) {
                return nameAndDef[1];
            }
            return null;
        }
        return val;
    }

    public static String getByTml(Properties main, Properties target, String tml, String refKey) {
        return PropUtil.getByTml(main, target, tml, refKey, true);
    }

    public static String getByTml(Properties main, Properties target, String tml, String refKey, boolean useDef) {
        return PropUtil.getByTmlCheckDepth(main, target, tml, refKey, useDef, 0);
    }

    private static String getByTmlCheckDepth(Properties main, Properties target, String tml, String refKey, boolean useDef, int depth) {
        if (Assert.isEmpty(tml)) {
            return tml;
        }
        int start = 0;
        int end = 0;
        while ((start = tml.indexOf("${")) >= 0) {
            end = tml.indexOf(125, start);
            if (end < 0) {
                throw new IllegalStateException("Invalid template expression: " + tml);
            }
            String valueExp = tml.substring(start + 2, end);
            String value = PropUtil.getByExp(main, target, valueExp, refKey, useDef);
            if (value != null && value.contains("${")) {
                int nextDepth = depth + 1;
                if (nextDepth > 10) {
                    throw new IllegalStateException("Circular reference detected or nesting is too deep (over 10 levels) for: " + valueExp);
                }
                if (nextDepth > 3) {
                    System.err.println("Solon-Warning: Configuration property nesting is deep (" + nextDepth + " levels). Check for potential circular references: " + valueExp);
                }
                value = PropUtil.getByTmlCheckDepth(main, target, value, refKey, useDef, nextDepth);
            }
            if (value == null) {
                return null;
            }
            tml = tml.substring(0, start) + value + tml.substring(end + 1);
        }
        return tml;
    }
}

