/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import org.noear.solon.Solon;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ReturnValueHandler;
import org.noear.solon.core.util.DataThrowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnValueHandlerDefault
implements ReturnValueHandler {
    static final Logger log = LoggerFactory.getLogger(ReturnValueHandlerDefault.class);
    public static final ReturnValueHandler INSTANCE = new ReturnValueHandlerDefault();

    @Override
    public boolean matched(Context ctx, Class<?> returnType) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void returnHandle(Context c, Object obj) throws Throwable {
        obj = Solon.app().chains().postResult(c, obj);
        if (!c.getRendered()) {
            c.result = obj;
        }
        if (obj instanceof DataThrowable) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (!(obj instanceof Throwable)) {
            if (c.getRendered()) return;
            c.render(obj);
            return;
        }
        if (!c.remoting()) {
            c.setHandled(false);
            throw (Throwable)obj;
        }
        Throwable objE = (Throwable)obj;
        log.warn("Remoting handle failed: " + c.pathNew(), objE);
        if (c.getRendered()) return;
        if (objE instanceof StatusException) {
            StatusException se = (StatusException)objE;
            c.status(se.getCode(), se.getMessage());
        } else {
            c.status(500, objE.getMessage());
        }
        c.setRendered(true);
    }
}

