/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.NamedThreadFactory;
import org.noear.solon.core.util.ThreadsUtil;
import org.noear.solon.lang.Internal;

@Internal
public class RunHolder {
    private ExecutorService parallelExecutor;
    private ScheduledExecutorService scheduledExecutor;

    public ExecutorService getParallelExecutor() {
        if (this.parallelExecutor == null) {
            Utils.locker().lock();
            try {
                if (this.parallelExecutor == null) {
                    if (Solon.appIf(app -> app.cfg().isEnabledVirtualThreads())) {
                        this.parallelExecutor = ThreadsUtil.newVirtualThreadPerTaskExecutor("Solon-executor-");
                    } else {
                        int asyncPoolSize = Runtime.getRuntime().availableProcessors() * 2;
                        this.parallelExecutor = Executors.newFixedThreadPool(asyncPoolSize, new NamedThreadFactory("Solon-executor-"));
                    }
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return this.parallelExecutor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        if (this.scheduledExecutor == null) {
            Utils.locker().lock();
            try {
                if (this.scheduledExecutor == null) {
                    if (Solon.appIf(app -> app.cfg().isEnabledVirtualThreads())) {
                        this.scheduledExecutor = Executors.newScheduledThreadPool(0, ThreadsUtil.newVirtualThreadFactory("Solon-scheduledExecutor-"));
                    } else {
                        int scheduledPoolSize = Runtime.getRuntime().availableProcessors() * 2;
                        this.scheduledExecutor = Executors.newScheduledThreadPool(scheduledPoolSize, new NamedThreadFactory("Solon-scheduledExecutor-"));
                    }
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return this.scheduledExecutor;
    }

    public void setScheduledExecutor(ScheduledExecutorService executor) {
        if (executor != null) {
            ScheduledExecutorService old = this.scheduledExecutor;
            this.scheduledExecutor = executor;
            if (old != null) {
                old.shutdown();
            }
        }
    }

    public void setParallelExecutor(ExecutorService executor) {
        if (executor != null) {
            ExecutorService old = this.parallelExecutor;
            this.parallelExecutor = executor;
            if (old != null) {
                old.shutdown();
            }
        }
    }

    public void shutdown() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            this.scheduledExecutor = null;
        }
        if (this.parallelExecutor != null) {
            this.parallelExecutor.shutdown();
            this.parallelExecutor = null;
        }
    }
}

