/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.util.CallableTx;
import org.noear.solon.core.util.ScopeLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeLocalJdk8<T>
implements ScopeLocal<T> {
    private static final Logger log = LoggerFactory.getLogger(ScopeLocalJdk8.class);
    private final ThreadLocal<T> ref = FactoryManager.getGlobal().newThreadLocal(ScopeLocalJdk8.class, false);

    @Override
    public T get() {
        return this.ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void with(T value, Runnable runnable) {
        T bak = this.ref.get();
        try {
            this.ref.set(value);
            runnable.run();
        }
        finally {
            if (bak == null) {
                this.ref.remove();
            } else {
                this.ref.set(bak);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R, X extends Throwable> R with(T value, CallableTx<? extends R, X> callable) throws X {
        T bak = this.ref.get();
        try {
            this.ref.set(value);
            R r = callable.call();
            return r;
        }
        finally {
            if (bak == null) {
                this.ref.remove();
            } else {
                this.ref.set(bak);
            }
        }
    }

    @Override
    public ScopeLocal<T> set(T value) {
        log.warn("ScopeLocal.set will be removed, please use ScopeLocal.with");
        this.ref.set(value);
        return this;
    }

    @Override
    public void remove() {
        log.warn("ScopeLocal.remove will be removed, please use ScopeLocal.with");
        this.ref.remove();
    }
}

