/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextEmpty;
import org.noear.solon.core.util.CallableTx;
import org.noear.solon.core.util.JavaUtil;
import org.noear.solon.core.util.ScopeLocal;

public class ContextHolder {
    private static final ScopeLocal<Context> LOCAL = ScopeLocal.newInstance(ContextHolder.class);

    public static void currentWith(Context context, Runnable runnable) {
        LOCAL.with(context, runnable);
    }

    public static <R, X extends Throwable> R currentWith(Context context, CallableTx<R, X> callable) throws X {
        return LOCAL.with(context, callable);
    }

    public static Context current() {
        Context tmp = LOCAL.get();
        if (tmp == null && Solon.appIf(app -> app.cfg().testing()) && JavaUtil.JAVA_MAJOR_VERSION < 21) {
            tmp = new ContextEmpty();
            LOCAL.set(tmp);
        }
        return tmp;
    }

    @Deprecated
    public static void currentSet(Context context) {
        LOCAL.set(context);
    }

    @Deprecated
    public static void currentRemove() {
        LOCAL.remove();
    }
}

