/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.runtime;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.core.runtime.RuntimeService;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.lang.Internal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class IndexFiles {
    private static final Logger log = LoggerFactory.getLogger(IndexFiles.class);
    private static final String INDEX_FILE_SUFFIX = ".index";
    private static final String INDEX_FILE_DIR = "META-INF/solon-index/";

    public static List<String> loadIndexFile(String dir, String tag) {
        String indexFileName = IndexFiles.getIndexFileName(dir, tag);
        try {
            URL uri = ResourceUtil.getResource(INDEX_FILE_DIR + indexFileName);
            if (uri == null) {
                return null;
            }
            ArrayList<String> indexList = new ArrayList<String>();
            try (InputStream inputStream = uri.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    indexList.add(line.trim());
                }
            }
            return indexList;
        }
        catch (IOException e) {
            log.warn("Failed to load class index file for dir: {}", (Object)dir, (Object)e);
            return null;
        }
    }

    public static String getIndexFileName(String dir, String tag) {
        if (Utils.isEmpty(dir)) {
            throw new IllegalArgumentException("dir cannot be null or empty");
        }
        if (Utils.isEmpty(tag)) {
            throw new IllegalArgumentException("tag cannot be null or empty");
        }
        if (dir.contains("..")) {
            throw new IllegalArgumentException("Invalid dir: contains path traversal characters");
        }
        return dir.replace('/', '-').replace('.', '-') + "_" + tag + INDEX_FILE_SUFFIX;
    }

    public static void writeIndexFile(String dir, String tag, List<String> indexList) {
        String indexFileName = IndexFiles.getIndexFileName(dir, tag);
        File indexFile = RuntimeService.singleton().createClassOutputFile(INDEX_FILE_DIR + indexFileName);
        try {
            indexFile.getParentFile().mkdirs();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(indexFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                for (String idx : indexList) {
                    writer.write(idx);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            log.warn("Failed to write class index file for dir: {}", (Object)dir, (Object)e);
        }
    }
}

